/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.components.item.ControllerBinding;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_9331;

public class ItemUpgradeRemote
extends ItemUpgrade {
    private static final int remoteGroupId = ItemUpgrade.getNextGroupId();
    private final boolean groupUpgrade;
    private final boolean bound;

    public ItemUpgradeRemote(boolean groupUpgrade, boolean bound, class_1792.class_1793 properties) {
        super(properties, remoteGroupId);
        this.groupUpgrade = groupUpgrade;
        this.bound = bound;
    }

    @Override
    public boolean isEnabled() {
        if (this.groupUpgrade) {
            return (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableRemoteGroupUpgrade.get();
        }
        return (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableRemoteUpgrade.get();
    }

    @Override
    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 display, Consumer<class_2561> tooltip, class_1836 flag) {
        super.method_67187(stack, context, display, tooltip, flag);
        class_2338 pos = ItemUpgradeRemote.getBoundPosition(stack);
        if (pos != null) {
            tooltip.accept((class_2561)class_2561.method_43469((String)(this.method_7876() + ".bound"), (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_27692(class_124.field_1054));
        } else {
            tooltip.accept((class_2561)class_2561.method_43471((String)(this.method_7876() + ".bound")).method_27692(class_124.field_1061));
        }
    }

    public static class_2338 getBoundPosition(class_1799 itemStack) {
        if (itemStack == null) {
            return null;
        }
        ControllerBinding binding = (ControllerBinding)itemStack.method_58695((class_9331)ModDataComponents.CONTROLLER_BINDING.get(), (Object)ControllerBinding.EMPTY);
        if (!binding.valid()) {
            return null;
        }
        return binding.blockPos();
    }

    public static class_1799 setBoundController(class_1799 itemStack, BlockEntityController controller) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("remote upgrade [{}] set bound controller [{}]", (Object)itemStack, (Object)controller);
        }
        if (itemStack == null || controller == null) {
            return itemStack;
        }
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item = (ItemUpgradeRemote)class_17922;
            class_1799 newStack = new class_1799(item.isGroupUpgrade() ? (class_1935)ModItems.REMOTE_GROUP_UPGRADE_BOUND.get() : (class_1935)ModItems.REMOTE_UPGRADE_BOUND.get(), itemStack.method_7947());
            newStack.method_57379((class_9331)ModDataComponents.CONTROLLER_BINDING.get(), (Object)new ControllerBinding(controller.method_11016()));
            return newStack;
        }
        return itemStack;
    }

    public static class_1799 setUnbound(class_1799 itemStack) {
        class_1792 class_17922;
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("remote upgrade [{}] set unbound", (Object)itemStack);
        }
        if (itemStack != null && (class_17922 = itemStack.method_7909()) instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item = (ItemUpgradeRemote)class_17922;
            return new class_1799(item.isGroupUpgrade() ? (class_1935)ModItems.REMOTE_GROUP_UPGRADE.get() : (class_1935)ModItems.REMOTE_UPGRADE.get(), itemStack.method_7947());
        }
        return itemStack;
    }

    public static class_1799 copyControllerBinding(class_1799 refStack, class_1799 targetStack) {
        if (refStack == null || targetStack == null) {
            return targetStack;
        }
        class_1792 class_17922 = refStack.method_7909();
        if (class_17922 instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote refItem = (ItemUpgradeRemote)class_17922;
            class_17922 = targetStack.method_7909();
            if (class_17922 instanceof ItemUpgradeRemote) {
                ItemUpgradeRemote targetItem = (ItemUpgradeRemote)class_17922;
                class_1792 newItem = targetItem.isGroupUpgrade() ? (refItem.isBound() ? (class_1792)ModItems.REMOTE_GROUP_UPGRADE_BOUND.get() : (class_1792)ModItems.REMOTE_GROUP_UPGRADE.get()) : (refItem.isBound() ? (class_1792)ModItems.REMOTE_UPGRADE_BOUND.get() : (class_1792)ModItems.REMOTE_UPGRADE.get());
                class_1799 newStack = new class_1799((class_1935)newItem, targetStack.method_7947());
                newStack.method_57379((class_9331)ModDataComponents.CONTROLLER_BINDING.get(), (Object)((ControllerBinding)refStack.method_58695((class_9331)ModDataComponents.CONTROLLER_BINDING.get(), (Object)ControllerBinding.EMPTY)));
                return newStack;
            }
        }
        return targetStack;
    }

    public static BlockEntityController getBoundController(class_1799 itemStack, class_1936 level) {
        if (level == null) {
            return null;
        }
        class_2338 pos = ItemUpgradeRemote.getBoundPosition(itemStack);
        if (pos == null) {
            return null;
        }
        class_2586 entity = level.method_8321(pos);
        if (entity instanceof BlockEntityController) {
            BlockEntityController bec = (BlockEntityController)entity;
            return bec;
        }
        return null;
    }

    public static void validateInventory(class_1661 inventory, class_1937 level) {
        if (level == null || inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1792 class_17922;
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof ItemUpgradeRemote)) continue;
            ItemUpgradeRemote item = (ItemUpgradeRemote)class_17922;
            if (!item.bound || ItemUpgradeRemote.getBoundController(stack, (class_1936)level) != null) continue;
            inventory.method_5447(i, ItemUpgradeRemote.setUnbound(stack));
        }
    }

    public boolean isGroupUpgrade() {
        return this.groupUpgrade;
    }

    public boolean isBound() {
        return this.bound;
    }
}

