/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.FaceSlotBlock;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModSecurity;
import com.jaquadro.minecraft.storagedrawers.item.ItemDetachedDrawer;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemKeyring;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import com.texelsaurus.minecraft.chameleon.util.WorldUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockDrawers
extends FaceSlotBlock
implements INetworked,
EntityBlock {
    private static final VoxelShape AABB_NORTH_FULL = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape AABB_SOUTH_FULL = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape AABB_WEST_FULL = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape AABB_EAST_FULL = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape AABB_NORTH_HALF = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_SOUTH_HALF = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape AABB_WEST_HALF = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_EAST_HALF = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private static final Map<UUID, Long> lastLeftClick = new HashMap<UUID, Long>();
    private final int drawerCount;
    private final boolean halfDepth;
    private final int storageUnits;
    public final AABB[] slotGeometry;
    public final AABB[] countGeometry;
    public final AABB[] labelGeometry;
    public final AABB[] indGeometry;
    public final AABB[] indBaseGeometry;
    private long ignoreEventTime;

    public BlockDrawers(int drawerCount, boolean halfDepth, int storageUnits, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.drawerCount = drawerCount;
        this.halfDepth = halfDepth;
        this.storageUnits = storageUnits;
        this.slotGeometry = new AABB[drawerCount];
        this.countGeometry = new AABB[drawerCount];
        this.labelGeometry = new AABB[drawerCount];
        this.indGeometry = new AABB[drawerCount];
        this.indBaseGeometry = new AABB[drawerCount];
        for (int i = 0; i < drawerCount; ++i) {
            this.slotGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.countGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.labelGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.indGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.indBaseGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public boolean retrimBlock(Level world, BlockPos pos, ItemStack prototype) {
        return false;
    }

    public BlockType retrimType() {
        return BlockType.Drawers;
    }

    public boolean repartitionBlock(Level world, BlockPos pos, ItemStack prototype) {
        return false;
    }

    public int getDrawerCount() {
        return this.drawerCount;
    }

    public boolean isHalfDepth() {
        return this.halfDepth;
    }

    public int getStorageUnits() {
        return this.storageUnits;
    }

    public String getNameTypeKey() {
        String type = this.halfDepth ? "half" : "full";
        return "block.storagedrawers.type." + type + "_drawers_" + this.getDrawerCount();
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case EAST: {
                return this.halfDepth ? AABB_EAST_HALF : AABB_EAST_FULL;
            }
            case WEST: {
                return this.halfDepth ? AABB_WEST_HALF : AABB_WEST_FULL;
            }
            case SOUTH: {
                return this.halfDepth ? AABB_SOUTH_HALF : AABB_SOUTH_FULL;
            }
        }
        return this.halfDepth ? AABB_NORTH_HALF : AABB_NORTH_FULL;
    }

    public boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        IDrawerAttributes _attrs;
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityDrawers.class);
        if (blockEntity == null) {
            return;
        }
        CustomData blockEntityData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (blockEntityData != null) {
            blockEntity.readPortable((HolderLookup.Provider)world.registryAccess(), blockEntityData.copyTag());
        } else {
            CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (customData != null) {
                blockEntity.readPortable((HolderLookup.Provider)world.registryAccess(), customData.copyTag());
            }
        }
        ItemKey key = null;
        if (entity != null) {
            Item item = entity.getOffhandItem().getItem();
            if (item instanceof ItemKey) {
                ItemKey itemKey;
                key = itemKey = (ItemKey)item;
            } else {
                item = entity.getOffhandItem().getItem();
                if (item instanceof ItemKeyring) {
                    ItemKeyring itemKeyring = (ItemKeyring)item;
                    key = itemKeyring.getKey().getItem();
                }
            }
        }
        if (key != null && (_attrs = blockEntity.getCapability(Capabilities.DRAWER_ATTRIBUTES)) instanceof IDrawerAttributesModifiable) {
            IDrawerAttributesModifiable attrs = (IDrawerAttributesModifiable)_attrs;
            if (key == ModItems.DRAWER_KEY.get()) {
                attrs.setItemLocked(LockAttribute.LOCK_EMPTY, true);
                attrs.setItemLocked(LockAttribute.LOCK_POPULATED, true);
            } else if (key == ModItems.QUANTIFY_KEY.get()) {
                attrs.setIsShowingQuantity(true);
            } else if (key == ModItems.SHROUD_KEY.get()) {
                attrs.setIsConcealed(true);
            }
        }
    }

    @Deprecated
    protected int getDrawerSlot(Direction correctSide, @NotNull Vec3 normalizedHit) {
        return this.getFaceSlot(correctSide, normalizedHit);
    }

    @Deprecated
    protected boolean hitAny(Direction side, Vec3 normalizedHit) {
        return this.hitWithinArea(side, normalizedHit, 0.0625f, 0.9375f);
    }

    @Deprecated
    protected boolean hitTop(@NotNull Vec3 normalizedHit) {
        return this.hitWithinY(normalizedHit, 0.5f, 1.0f);
    }

    @Deprecated
    protected boolean hitLeft(Direction side, @NotNull Vec3 normalizedHit) {
        return this.hitWithinX(side, normalizedHit, 0.0f, 0.5f);
    }

    @Override
    public Optional<InteractionResult> useSlotInvertible(FaceSlotBlock.InteractContext context) {
        ItemStack item = context.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (item.isEmpty() && ((Boolean)ModCommonConfig.INSTANCE.GENERAL.enableUI.get()).booleanValue() && !context.level.isClientSide && context.player.isShiftKeyDown()) {
            this.openUI(context);
            return Optional.of(InteractionResult.SUCCESS);
        }
        return Optional.empty();
    }

    @Override
    public Optional<InteractionResult> useSlot(FaceSlotBlock.InteractContext context) {
        ItemStack item = context.player.getItemInHand(InteractionHand.MAIN_HAND);
        BlockEntityDrawers blockEntity = context.getCheckedEntity(BlockEntityDrawers.class);
        if (!SecurityManager.hasAccess(context.player, blockEntity)) {
            return Optional.of(InteractionResult.PASS);
        }
        ItemStack keyItem = null;
        Item item2 = item.getItem();
        if (item2 instanceof ItemKeyring) {
            ItemKeyring keyring = (ItemKeyring)item2;
            keyItem = keyring.getKey();
        }
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.enableDetachedDrawers.get()).booleanValue() && context.slot >= 0) {
            if (item.getItem() == ModItems.DRAWER_PULLER.get() || keyItem != null && keyItem.getItem() == ModItems.DRAWER_PULLER.get()) {
                this.interactPullDrawer(context);
                return Optional.of(InteractionResult.SUCCESS);
            }
            if (item.getItem() instanceof ItemDetachedDrawer) {
                this.interactReturnDrawer(context, item);
                return Optional.of(InteractionResult.SUCCESS);
            }
        }
        if (Block.byItem((Item)item.getItem()) instanceof BlockTrim && context.slot >= 0 && context.player.isShiftKeyDown()) {
            if (!this.retrimBlock(context.level, context.pos, item)) {
                return Optional.of(InteractionResult.PASS);
            }
            if (!context.player.isCreative()) {
                item.shrink(1);
                if (item.getCount() <= 0) {
                    context.player.getInventory().setItem(context.player.getInventory().selected, ItemStack.EMPTY);
                }
                context.level.playSound(null, context.pos, SoundEvents.WOOD_PLACE, SoundSource.PLAYERS, 0.2f, ((context.level.random.nextFloat() - context.level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        if (Block.byItem((Item)item.getItem()) instanceof BlockDrawers && context.slot >= 0 && context.player.isShiftKeyDown()) {
            if (!this.repartitionBlock(context.level, context.pos, item)) {
                return Optional.of(InteractionResult.PASS);
            }
            if (!context.player.isCreative()) {
                item.shrink(1);
                if (item.getCount() <= 0) {
                    context.player.getInventory().setItem(context.player.getInventory().selected, ItemStack.EMPTY);
                }
                context.level.playSound(null, context.pos, SoundEvents.WOOD_PLACE, SoundSource.PLAYERS, 0.2f, ((context.level.random.nextFloat() - context.level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        if (item.getItem() instanceof ItemPersonalKey || keyItem != null && keyItem.getItem() instanceof ItemPersonalKey) {
            if (keyItem != null) {
                item = keyItem;
            }
            String securityKey = ((ItemPersonalKey)item.getItem()).getSecurityProviderKey();
            ISecurityProvider provider = ModSecurity.registry.getProvider(securityKey);
            if (blockEntity.getOwner() == null) {
                blockEntity.setOwner(context.player.getUUID());
                blockEntity.setSecurityProvider(provider);
            } else if (SecurityManager.hasOwnership(context.player.getGameProfile(), blockEntity)) {
                blockEntity.setOwner(null);
                blockEntity.setSecurityProvider(null);
            } else {
                return Optional.of(InteractionResult.PASS);
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        if (item.getItem() instanceof ItemKey || item.getItem() instanceof ItemKeyring) {
            return Optional.of(InteractionResult.PASS);
        }
        BlockEntityDrawers entity = context.getCheckedEntity(BlockEntityDrawers.class);
        if (item.getItem() instanceof ItemUpgrade && !context.player.isShiftKeyDown()) {
            if (entity.getGroup().hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.GENERAL.forceDetachedDrawersMaxCapacityCheck.get()).booleanValue()) {
                if (!context.level.isClientSide) {
                    context.player.displayClientMessage((Component)Component.translatable((String)"message.storagedrawers.missing_slots_upgrade"), true);
                }
                return Optional.of(InteractionResult.PASS);
            }
            Item item3 = item.getItem();
            if (item3 instanceof ItemUpgradeRemote) {
                ItemUpgradeRemote remote = (ItemUpgradeRemote)item3;
                if (entity.upgrades().hasRemoteUpgrade() && remote.isBound()) {
                    entity.upgrades().updateRemoteUpgradeBinding(item);
                    BlockPos pos = ItemUpgradeRemote.getBoundPosition(item);
                    if (pos != null) {
                        context.player.displayClientMessage((Component)Component.translatable((String)"message.storagedrawers.updated_remote_binding", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), true);
                    }
                    return Optional.of(InteractionResult.SUCCESS);
                }
            }
            if (!entity.upgrades().canAddUpgrade(item)) {
                if (!context.level.isClientSide) {
                    context.player.displayClientMessage((Component)Component.translatable((String)"message.storagedrawers.cannot_add_upgrade"), true);
                }
                return Optional.of(InteractionResult.PASS);
            }
            if (!entity.upgrades().addUpgrade(item)) {
                if (!context.level.isClientSide) {
                    context.player.displayClientMessage((Component)Component.translatable((String)"message.storagedrawers.max_upgrades"), true);
                }
                return Optional.of(InteractionResult.PASS);
            }
            context.level.sendBlockUpdated(context.pos, context.state, context.state, 3);
            if (!context.player.isCreative()) {
                item.shrink(1);
                if (item.getCount() <= 0) {
                    context.player.getInventory().setItem(context.player.getInventory().selected, ItemStack.EMPTY);
                }
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        return Optional.empty();
    }

    @Override
    public InteractionResult putSlot(FaceSlotBlock.InteractContext context, boolean altAction) {
        ItemStack item = context.player.getItemInHand(InteractionHand.MAIN_HAND);
        BlockEntityDrawers blockEntityDrawers = context.getCheckedEntity(BlockEntityDrawers.class);
        if (blockEntityDrawers == null) {
            return InteractionResult.FAIL;
        }
        if (!SecurityManager.hasAccess(context.player, blockEntityDrawers)) {
            return InteractionResult.PASS;
        }
        blockEntityDrawers.interactPutItemsIntoSlot(context.slot, context.player);
        if (item.isEmpty()) {
            context.player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult takeSlot(FaceSlotBlock.InteractContext context, boolean altAction) {
        BlockEntityDrawers blockEntityDrawers = context.getCheckedEntity(BlockEntityDrawers.class, BlockDrawers.class);
        if (blockEntityDrawers == null) {
            return InteractionResult.FAIL;
        }
        if (!SecurityManager.hasAccess(context.player, blockEntityDrawers)) {
            return InteractionResult.PASS;
        }
        IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(context.slot);
        ItemStack item = altAction ? blockEntityDrawers.takeItemsFromSlot(context.slot, drawer.getStoredItemStackSize()) : blockEntityDrawers.takeItemsFromSlot(context.slot, 1);
        if (!item.isEmpty()) {
            if (!context.player.getInventory().add(item)) {
                this.dropItemStack(context.level, context.pos.relative(context.hit.getDirection()), context.player, item);
                context.level.sendBlockUpdated(context.pos, context.state, context.state, 3);
            } else {
                context.level.playSound(null, context.pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((context.level.random.nextFloat() - context.level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean interactPullDrawer(FaceSlotBlock.InteractContext context) {
        BlockEntityDrawers entity = context.getCheckedEntity(BlockEntityDrawers.class, BlockDrawers.class);
        if (entity == null) {
            return false;
        }
        IDrawer drawer = entity.getGroup().getDrawer(context.slot);
        if (!drawer.isEnabled() || drawer.isMissing() || !drawer.canDetach()) {
            return false;
        }
        ItemStack detachedDrawer = this.pullDrawer(context.level, entity, context.slot);
        if (!detachedDrawer.isEmpty()) {
            drawer.setDetached(true);
        }
        this.giveOrDropItemStack(context, detachedDrawer);
        return true;
    }

    public boolean interactReturnDrawer(FaceSlotBlock.InteractContext context, ItemStack detachedDrawer) {
        if (detachedDrawer.isEmpty()) {
            return false;
        }
        BlockEntityDrawers entity = context.getCheckedEntity(BlockEntityDrawers.class, BlockDrawers.class);
        if (entity == null) {
            return false;
        }
        if (!entity.interactReplaceDrawer(context.slot, detachedDrawer)) {
            return false;
        }
        if (detachedDrawer.getItem() == ModItems.DETACHED_DRAWER.get()) {
            detachedDrawer.setCount(detachedDrawer.getCount() - 1);
            if (detachedDrawer.getCount() > 0) {
                return true;
            }
        }
        context.player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        return true;
    }

    private ItemStack pullDrawer(Level level, BlockEntityDrawers group, int slot) {
        int cap = group.getEffectiveDrawerCapacity() * group.upgrades().getStorageMultiplier();
        Item baseItem = (Item)ModItems.DETACHED_DRAWER_FULL.get();
        IDrawer drawer = group.getDrawer(slot);
        DetachedDrawerData data = new DetachedDrawerData(drawer, cap);
        if (drawer.isEmpty()) {
            baseItem = (Item)ModItems.DETACHED_DRAWER.get();
        }
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.heavyDrawers.get()).booleanValue() && !group.upgrades().hasPortabilityUpgrade()) {
            data.setIsHeavy(true);
        }
        ItemStack stack = new ItemStack((ItemLike)baseItem, 1);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)data.serializeNBT((HolderLookup.Provider)level.registryAccess())));
        return stack;
    }

    private void giveOrDropItemStack(FaceSlotBlock.InteractContext context, @NotNull ItemStack item) {
        if (!item.isEmpty()) {
            if (!context.player.getInventory().add(item)) {
                this.dropItemStack(context.level, context.pos.relative(context.hit.getDirection()), context.player, item);
                context.level.sendBlockUpdated(context.pos, context.state, context.state, 3);
            } else {
                context.level.playSound(null, context.pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((context.level.random.nextFloat() - context.level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    private void openUI(FaceSlotBlock.InteractContext context) {
        MenuProvider provider = context.state.getMenuProvider(context.level, context.pos);
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("Open BlockDrawers UI " + String.valueOf(context.pos));
        }
        if (provider instanceof ContentMenuProvider) {
            ContentMenuProvider menu = (ContentMenuProvider)provider;
            menu.openMenu((ServerPlayer)context.player);
        }
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState blockState, Level level, BlockPos blockPos) {
        BlockEntityDrawers blockEntityDrawers = WorldUtils.getBlockEntity((BlockGetter)level, blockPos, BlockEntityDrawers.class);
        if (blockEntityDrawers == null) {
            return null;
        }
        return new BlockEntityDrawers.ContentProvider(blockEntityDrawers);
    }

    private void dropItemStack(@NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.3f), (double)((float)pos.getZ() + 0.5f), stack);
        Vec3 motion = entity.getDeltaMovement();
        entity.push(-motion.x, -motion.y, -motion.z);
        world.addFreshEntity((Entity)entity);
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getMainDrop(state, (BlockEntityDrawers)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)));
        return items;
    }

    protected ItemStack getMainDrop(BlockState state, BlockEntityDrawers tile) {
        int i;
        ItemStack drop = new ItemStack((ItemLike)this);
        if (tile == null) {
            return drop;
        }
        boolean hasContents = false;
        for (i = 0; i < tile.getGroup().getDrawerCount(); ++i) {
            IDrawer drawer = tile.getGroup().getDrawer(i);
            if (drawer.isEmpty() && !drawer.isMissing()) continue;
            hasContents = true;
        }
        for (i = 0; i < tile.upgrades().getSlotCount(); ++i) {
            if (tile.upgrades().getUpgrade(i).isEmpty()) continue;
            hasContents = true;
        }
        if (hasContents) {
            CompoundTag tiledata = tile.saveWithId((HolderLookup.Provider)tile.getLevel().registryAccess());
            drop.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tiledata));
        }
        if (tile.hasCustomName()) {
            drop.set(DataComponents.CUSTOM_NAME, (Object)tile.getCustomName());
        }
        return drop;
    }

    public boolean isSignalSource(@NotNull BlockState state) {
        return (Boolean)ModCommonConfig.INSTANCE.GENERAL.enableAnalogRedstone.get() == false;
    }

    public int getSignal(@NotNull BlockState state, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        if (!this.isSignalSource(state)) {
            return 0;
        }
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity(blockAccess, pos, BlockEntityDrawers.class);
        if (blockEntity == null || !blockEntity.isRedstone()) {
            return 0;
        }
        return blockEntity.getRedstoneLevel();
    }

    public int getDirectSignal(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull Direction side) {
        return side == Direction.UP ? this.getSignal(state, worldIn, pos, side) : 0;
    }

    public void onRemove(BlockState p_51538_, Level p_51539_, BlockPos p_51540_, BlockState p_51541_, boolean p_51542_) {
        if (!p_51538_.is(p_51541_.getBlock())) {
            p_51539_.updateNeighbourForOutputSignal(p_51540_, (Block)this);
            super.onRemove(p_51538_, p_51539_, p_51540_, p_51541_, p_51542_);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level blockAccess, BlockPos pos) {
        if (!this.hasAnalogOutputSignal(state)) {
            return 0;
        }
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((BlockGetter)blockAccess, pos, BlockEntityDrawers.class);
        if (blockEntity == null || !blockEntity.isRedstone()) {
            return 0;
        }
        return blockEntity.getRedstoneLevel();
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("BlockDrawers [{}] tick", (Object)pos);
        }
        if (world.isClientSide) {
            return;
        }
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityDrawers.class);
        if (blockEntity == null) {
            return;
        }
        blockEntity.validateBoundController();
    }
}

