/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.components.item.ControllerBinding;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemUpgradeRemote
extends ItemUpgrade {
    private static final int remoteGroupId = ItemUpgrade.getNextGroupId();
    private final boolean groupUpgrade;
    private final boolean bound;

    public ItemUpgradeRemote(boolean groupUpgrade, boolean bound, Item.Properties properties) {
        super(properties, remoteGroupId);
        this.groupUpgrade = groupUpgrade;
        this.bound = bound;
    }

    @Override
    public boolean isEnabled() {
        if (this.groupUpgrade) {
            return (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableRemoteGroupUpgrade.get();
        }
        return (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableRemoteUpgrade.get();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        BlockPos pos = ItemUpgradeRemote.getBoundPosition(stack);
        if (pos != null) {
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".bound"), (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".bound")).withStyle(ChatFormatting.RED));
        }
    }

    public static BlockPos getBoundPosition(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ControllerBinding binding = (ControllerBinding)itemStack.getOrDefault((DataComponentType)ModDataComponents.CONTROLLER_BINDING.get(), (Object)ControllerBinding.EMPTY);
        if (!binding.valid()) {
            return null;
        }
        return binding.blockPos();
    }

    public static ItemStack setBoundController(ItemStack itemStack, BlockEntityController controller) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("remote upgrade [{}] set bound controller [{}]", (Object)itemStack, (Object)controller);
        }
        if (itemStack == null || controller == null) {
            return itemStack;
        }
        Item item = itemStack.getItem();
        if (item instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item2 = (ItemUpgradeRemote)item;
            ItemStack newStack = new ItemStack(item2.isGroupUpgrade() ? (ItemLike)ModItems.REMOTE_GROUP_UPGRADE_BOUND.get() : (ItemLike)ModItems.REMOTE_UPGRADE_BOUND.get(), itemStack.getCount());
            newStack.set((DataComponentType)ModDataComponents.CONTROLLER_BINDING.get(), (Object)new ControllerBinding(controller.getBlockPos()));
            return newStack;
        }
        return itemStack;
    }

    public static ItemStack setUnbound(ItemStack itemStack) {
        Item item;
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("remote upgrade [{}] set unbound", (Object)itemStack);
        }
        if (itemStack != null && (item = itemStack.getItem()) instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item2 = (ItemUpgradeRemote)item;
            return new ItemStack(item2.isGroupUpgrade() ? (ItemLike)ModItems.REMOTE_GROUP_UPGRADE.get() : (ItemLike)ModItems.REMOTE_UPGRADE.get(), itemStack.getCount());
        }
        return itemStack;
    }

    public static ItemStack copyControllerBinding(ItemStack refStack, ItemStack targetStack) {
        if (refStack == null || targetStack == null) {
            return targetStack;
        }
        Item item = refStack.getItem();
        if (item instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote refItem = (ItemUpgradeRemote)item;
            item = targetStack.getItem();
            if (item instanceof ItemUpgradeRemote) {
                ItemUpgradeRemote targetItem = (ItemUpgradeRemote)item;
                Item newItem = targetItem.isGroupUpgrade() ? (refItem.isBound() ? (Item)ModItems.REMOTE_GROUP_UPGRADE_BOUND.get() : (Item)ModItems.REMOTE_GROUP_UPGRADE.get()) : (refItem.isBound() ? (Item)ModItems.REMOTE_UPGRADE_BOUND.get() : (Item)ModItems.REMOTE_UPGRADE.get());
                ItemStack newStack = new ItemStack((ItemLike)newItem, targetStack.getCount());
                newStack.set((DataComponentType)ModDataComponents.CONTROLLER_BINDING.get(), (Object)((ControllerBinding)refStack.getOrDefault((DataComponentType)ModDataComponents.CONTROLLER_BINDING.get(), (Object)ControllerBinding.EMPTY)));
                return newStack;
            }
        }
        return targetStack;
    }

    public static BlockEntityController getBoundController(ItemStack itemStack, LevelAccessor level) {
        if (level == null) {
            return null;
        }
        BlockPos pos = ItemUpgradeRemote.getBoundPosition(itemStack);
        if (pos == null) {
            return null;
        }
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof BlockEntityController) {
            BlockEntityController bec = (BlockEntityController)entity;
            return bec;
        }
        return null;
    }

    public static void validateInventory(Inventory inventory, Level level) {
        if (level == null || inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            Item item;
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof ItemUpgradeRemote)) continue;
            ItemUpgradeRemote item2 = (ItemUpgradeRemote)item;
            if (!item2.bound || ItemUpgradeRemote.getBoundController(stack, (LevelAccessor)level) != null) continue;
            inventory.setItem(i, ItemUpgradeRemote.setUnbound(stack));
        }
    }

    public boolean isGroupUpgrade() {
        return this.groupUpgrade;
    }

    public boolean isBound() {
        return this.bound;
    }
}

