/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockControllerIO;
import com.jaquadro.minecraft.storagedrawers.block.KeyType;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8177;
import org.jetbrains.annotations.Nullable;

public class BlockKeyButton
extends class_2341 {
    public static final MapCodec<BlockKeyButton> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)KeyType.CODEC.fieldOf("key_type").forGetter(block -> block.keyType), (App)BlockKeyButton.method_54096()).apply((Applicative)inst, BlockKeyButton::new));
    public static final class_2746 POWERED = class_2741.field_12484;
    protected static final class_265 CEILING_AABB_X = class_2248.method_9541((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final class_265 CEILING_AABB_Z = class_2248.method_9541((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final class_265 FLOOR_AABB_X = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    protected static final class_265 FLOOR_AABB_Z = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    protected static final class_265 NORTH_AABB = class_2248.method_9541((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final class_265 SOUTH_AABB = class_2248.method_9541((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0);
    protected static final class_265 WEST_AABB = class_2248.method_9541((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final class_265 EAST_AABB = class_2248.method_9541((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0);
    protected static final class_265 PRESSED_CEILING_AABB_X = class_2248.method_9541((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final class_265 PRESSED_CEILING_AABB_Z = class_2248.method_9541((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final class_265 PRESSED_FLOOR_AABB_X = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    protected static final class_265 PRESSED_FLOOR_AABB_Z = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    protected static final class_265 PRESSED_NORTH_AABB = class_2248.method_9541((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final class_265 PRESSED_SOUTH_AABB = class_2248.method_9541((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0);
    protected static final class_265 PRESSED_WEST_AABB = class_2248.method_9541((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final class_265 PRESSED_EAST_AABB = class_2248.method_9541((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0);
    private final KeyType keyType;

    public BlockKeyButton(KeyType keyType, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471));
        this.keyType = keyType;
    }

    public MapCodec<BlockKeyButton> method_53969() {
        return CODEC;
    }

    public class_265 method_9530(class_2680 state, class_1922 getter, class_2338 pos, class_3726 collision) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)field_11177);
        boolean powered = (Boolean)state.method_11654((class_2769)POWERED);
        switch ((class_2738)state.method_11654((class_2769)field_11007)) {
            case field_12475: {
                if (dir.method_10166() == class_2350.class_2351.field_11048) {
                    return powered ? PRESSED_FLOOR_AABB_X : FLOOR_AABB_X;
                }
                return powered ? PRESSED_FLOOR_AABB_Z : FLOOR_AABB_Z;
            }
            case field_12471: {
                return switch (dir) {
                    default -> throw new MatchException(null, null);
                    case class_2350.field_11034 -> {
                        if (powered) {
                            yield PRESSED_EAST_AABB;
                        }
                        yield EAST_AABB;
                    }
                    case class_2350.field_11039 -> {
                        if (powered) {
                            yield PRESSED_WEST_AABB;
                        }
                        yield WEST_AABB;
                    }
                    case class_2350.field_11035 -> {
                        if (powered) {
                            yield PRESSED_SOUTH_AABB;
                        }
                        yield SOUTH_AABB;
                    }
                    case class_2350.field_11043, class_2350.field_11036, class_2350.field_11033 -> powered ? PRESSED_NORTH_AABB : NORTH_AABB;
                };
            }
        }
        if (dir.method_10166() == class_2350.class_2351.field_11048) {
            return powered ? PRESSED_CEILING_AABB_X : CEILING_AABB_X;
        }
        return powered ? PRESSED_CEILING_AABB_Z : CEILING_AABB_Z;
    }

    public class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        BlockController blockController;
        BlockControllerIO io;
        BlockEntityController controller;
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            return class_1269.field_21466;
        }
        if (!this.keyType.isEnabled()) {
            return class_1269.field_5811;
        }
        this.press(state, level, pos);
        this.playSound(player, (class_1936)level, pos, true);
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28174, pos);
        class_2338 targetPos = pos.method_10081(((class_2350)state.method_11654((class_2769)field_11177)).method_10153().method_62675());
        if (state.method_11654((class_2769)field_11007) == class_2738.field_12475) {
            targetPos = pos.method_10081(class_2350.field_11033.method_62675());
        } else if (state.method_11654((class_2769)field_11007) == class_2738.field_12473) {
            targetPos = pos.method_10081(class_2350.field_11036.method_62675());
        }
        class_2248 target = level.method_8320(targetPos).method_26204();
        if (target instanceof BlockController) {
            BlockController controller2 = (BlockController)target;
            controller2.toggle(level, targetPos, player, this.keyType);
        } else if (target instanceof BlockControllerIO && (controller = (io = (BlockControllerIO)target).getController(level, targetPos)) != null && (blockController = controller.getBlock()) != null) {
            blockController.toggle(level, controller.method_11016(), player, this.keyType);
        }
        return class_1269.field_5812;
    }

    public void press(class_2680 state, class_1937 level, class_2338 pos) {
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbours(state, level, pos);
        level.method_64310(pos, (class_2248)this, 10);
    }

    protected void playSound(@Nullable class_1657 player, class_1936 level, class_2338 pos, boolean clickOn) {
        level.method_45447((class_1297)(clickOn ? player : null), pos, this.getSound(clickOn), class_3419.field_15245);
    }

    protected class_3414 getSound(boolean clickOn) {
        return clickOn ? class_8177.field_42823.comp_1298() : class_8177.field_42823.comp_1297();
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            this.checkPressed(state, (class_1937)level, pos);
        }
    }

    protected void checkPressed(class_2680 state, class_1937 level, class_2338 pos) {
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            this.updateNeighbours(state, level, pos);
            this.playSound(null, (class_1936)level, pos, false);
            level.method_33596(null, (class_6880)class_5712.field_28175, pos);
        }
    }

    private void updateNeighbours(class_2680 state, class_1937 level, class_2338 pos) {
        level.method_8408(pos, (class_2248)this);
        level.method_8408(pos.method_10093(BlockKeyButton.method_10119((class_2680)state).method_10153()), (class_2248)this);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, POWERED, field_11007});
    }
}

