/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.FractionalDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityDrawersComp
extends BlockEntityDrawers {
    public BlockEntityDrawersComp(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    @Override
    protected boolean emptySlotCanBeCleared(int slot) {
        if (slot != 0) {
            return false;
        }
        IDrawerGroup iDrawerGroup = this.getGroup();
        if (iDrawerGroup instanceof FractionalDrawerGroup) {
            FractionalDrawerGroup fracGroup = (FractionalDrawerGroup)iDrawerGroup;
            return !this.getGroup().getDrawer(0).isEmpty() && fracGroup.getPooledCount() == 0;
        }
        return false;
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    public void clientUpdateCount(int slot, int count) {
        if (this.method_10997() == null || !this.method_10997().method_8608()) {
            return;
        }
        class_310.method_1551().method_63588(() -> this.clientUpdateCountAsync(count));
    }

    private void clientUpdateCountAsync(int count) {
        if (this.getGroup() instanceof FractionalDrawerGroup) {
            ((FractionalDrawerGroup)this.getGroup()).setPooledCount(count);
        }
    }

    protected class GroupData
    extends FractionalDrawerGroup
    implements IProtectable,
    INetworked {
        public GroupData(int slotCount) {
            super(slotCount);
        }

        @Override
        protected class_1937 getWorld() {
            return BlockEntityDrawersComp.this.method_10997();
        }

        @Override
        public boolean isGroupValid() {
            return BlockEntityDrawersComp.this.isGroupValid();
        }

        @Override
        protected void log(String message) {
            if (!this.getWorld().method_8608() && ((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
                ModServices.log.info(message);
            }
        }

        @Override
        protected int getStackCapacity() {
            return BlockEntityDrawersComp.this.upgrades().getStorageMultiplier() * BlockEntityDrawersComp.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            if (this.getWorld() != null && !this.getWorld().method_8608()) {
                int usedSlots = 0;
                for (int slot : this.getAccessibleDrawerSlots()) {
                    IFractionalDrawer drawer = this.getDrawer(slot);
                    if (drawer.isEmpty()) continue;
                    ++usedSlots;
                }
                usedSlots = Math.max(usedSlots, 1);
                EnumCompDrawer open = (EnumCompDrawer)((Object)BlockEntityDrawersComp.this.method_11010().method_11654(BlockCompDrawers.SLOTS));
                if (open.getOpenSlots() != usedSlots) {
                    this.getWorld().method_8652(BlockEntityDrawersComp.this.field_11867, (class_2680)BlockEntityDrawersComp.this.method_11010().method_11657(BlockCompDrawers.SLOTS, (Comparable)((Object)EnumCompDrawer.byOpenSlots(usedSlots))), 3);
                }
                BlockEntityDrawersComp.this.method_5431();
                BlockEntityDrawersComp.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (this.getWorld() != null && !this.getWorld().method_8608()) {
                ChameleonServices.NETWORK.sendToPlayersNear(new CountUpdateMessage(BlockEntityDrawersComp.this.method_11016(), 0, this.getPooledCount()), (class_3218)BlockEntityDrawersComp.this.method_10997(), BlockEntityDrawersComp.this.method_11016().method_10263(), BlockEntityDrawersComp.this.method_11016().method_10264(), BlockEntityDrawersComp.this.method_11016().method_10260(), 500.0);
                BlockEntityDrawersComp.this.method_5431();
            }
        }

        @Override
        public <T> T getCapability(ChameleonCapability<T> capability) {
            if (capability == null || BlockEntityDrawersComp.this.field_11863 == null) {
                return null;
            }
            return capability.getCapability(BlockEntityDrawersComp.this.field_11863, BlockEntityDrawersComp.this.method_11016());
        }

        @Override
        public UUID getOwner() {
            return BlockEntityDrawersComp.this.getOwner();
        }

        @Override
        public boolean setOwner(UUID owner) {
            return BlockEntityDrawersComp.this.setOwner(owner);
        }

        @Override
        public ISecurityProvider getSecurityProvider() {
            return BlockEntityDrawersComp.this.getSecurityProvider();
        }

        @Override
        public boolean setSecurityProvider(ISecurityProvider provder) {
            return BlockEntityDrawersComp.this.setSecurityProvider(provder);
        }

        @Override
        public IControlGroup getBoundControlGroup() {
            return BlockEntityDrawersComp.this.getBoundControlGroup();
        }

        @Override
        public Set<IControlGroup> getSoftBoundControlGroups() {
            return BlockEntityDrawersComp.super.getSoftBoundControlGroups();
        }
    }

    public static class Slot3
    extends BlockEntityDrawersComp {
        private final GroupData groupData = new GroupData(3);

        public Slot3(class_2338 pos, class_2680 state) {
            super((class_2591)ModBlockEntities.FRACTIONAL_DRAWERS_3.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends BlockEntityDrawersComp {
        private final GroupData groupData = new GroupData(2);

        public Slot2(class_2338 pos, class_2680 state) {
            super((class_2591)ModBlockEntities.FRACTIONAL_DRAWERS_2.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }
}

