/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedMaterials;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;

public class MaterialData
extends BlockEntityDataShim
implements IFramedMaterials {
    public static final MaterialData EMPTY = new MaterialData();
    public static final Codec<MaterialData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("frameBase").forGetter(MaterialData::getFrameBase), (App)class_1799.field_24671.fieldOf("materialSide").forGetter(MaterialData::getSide), (App)class_1799.field_24671.fieldOf("materialFront").forGetter(MaterialData::getFront), (App)class_1799.field_24671.fieldOf("materialTrim").forGetter(MaterialData::getTrim)).apply((Applicative)instance, MaterialData::new));
    public static final class_9139<class_9129, MaterialData> STREAM_CODEC = class_9139.method_56905((class_9139)class_1799.field_49268, MaterialData::getFrameBase, (class_9139)class_1799.field_49268, MaterialData::getSide, (class_9139)class_1799.field_49268, MaterialData::getFront, (class_9139)class_1799.field_49268, MaterialData::getTrim, MaterialData::new);
    @NotNull
    private class_1799 frameBase;
    @NotNull
    private class_1799 materialSide;
    @NotNull
    private class_1799 materialFront;
    @NotNull
    private class_1799 materialTrim;

    public MaterialData() {
        this(class_1799.field_8037, class_1799.field_8037, class_1799.field_8037, class_1799.field_8037);
    }

    public MaterialData(@NotNull class_1799 frameBase, @NotNull class_1799 side, @NotNull class_1799 front, @NotNull class_1799 trim) {
        this.frameBase = frameBase;
        this.materialSide = side;
        this.materialFront = front;
        this.materialTrim = trim;
    }

    public MaterialData(IFramedMaterials materials) {
        this();
        if (materials != null) {
            this.frameBase = materials.getHostBlock();
            this.materialSide = materials.getMaterial(FrameMaterial.SIDE);
            this.materialFront = materials.getMaterial(FrameMaterial.FRONT);
            this.materialTrim = materials.getMaterial(FrameMaterial.TRIM);
        }
    }

    @NotNull
    public class_1799 getFrameBase() {
        return this.frameBase;
    }

    @NotNull
    public class_1799 getSide() {
        return this.materialSide;
    }

    @NotNull
    public class_1799 getFront() {
        return this.materialFront;
    }

    @NotNull
    public class_1799 getTrim() {
        return this.materialTrim;
    }

    @NotNull
    public class_1799 getEffectiveSide() {
        return this.materialSide;
    }

    @NotNull
    public class_1799 getEffectiveFront() {
        return !this.materialFront.method_7960() ? this.materialFront : this.materialSide;
    }

    @NotNull
    public class_1799 getEffectiveTrim() {
        return !this.materialTrim.method_7960() ? this.materialTrim : this.materialSide;
    }

    public boolean isMatOpaque(class_1799 mat) {
        class_1792 class_17922 = mat.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return blockItem.method_7711().method_9564().method_26225();
        }
        return false;
    }

    public boolean allMatOpaque() {
        return !(!this.isMatOpaque(this.materialSide) || !this.materialFront.method_7960() && !this.isMatOpaque(this.materialFront) || !this.materialTrim.method_7960() && !this.isMatOpaque(this.materialTrim));
    }

    public void setFrameBase(@NotNull class_1799 frameBase) {
        this.frameBase = frameBase;
    }

    public void setSide(@NotNull class_1799 material) {
        this.materialSide = material;
    }

    public void setFront(@NotNull class_1799 material) {
        this.materialFront = material;
    }

    public void setTrim(@NotNull class_1799 material) {
        this.materialTrim = material;
    }

    public void clear() {
        this.materialSide = class_1799.field_8037;
        this.materialFront = class_1799.field_8037;
        this.materialTrim = class_1799.field_8037;
    }

    public boolean isEmpty() {
        return this.materialFront.method_7960() && this.materialSide.method_7960() && this.materialTrim.method_7960();
    }

    public void read(class_1799 stack) {
        FrameData data = (FrameData)stack.method_58695((class_9331)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY);
        this.frameBase = data.base();
        this.materialSide = data.side();
        this.materialFront = data.front();
        this.materialTrim = data.trim();
    }

    @Override
    public void read(class_11368 input) {
        this.frameBase = input.method_71426("MatB", class_1799.field_24671).orElse(class_1799.field_8037);
        this.materialSide = input.method_71426("MatS", class_1799.field_24671).orElse(class_1799.field_8037);
        this.materialFront = input.method_71426("MatF", class_1799.field_24671).orElse(class_1799.field_8037);
        this.materialTrim = input.method_71426("MatT", class_1799.field_24671).orElse(class_1799.field_8037);
    }

    @Override
    public void write(class_11372 output) {
        if (!this.frameBase.method_7960()) {
            output.method_71468("MatB", class_1799.field_24671, (Object)this.frameBase);
        } else {
            output.method_71478("MatB");
        }
        if (!this.materialSide.method_7960()) {
            output.method_71468("MatS", class_1799.field_24671, (Object)this.materialSide);
        } else {
            output.method_71478("MatS");
        }
        if (!this.materialFront.method_7960()) {
            output.method_71468("MatF", class_1799.field_24671, (Object)this.materialFront);
        } else {
            output.method_71478("MatF");
        }
        if (!this.materialTrim.method_7960()) {
            output.method_71468("MatT", class_1799.field_24671, (Object)this.materialTrim);
        } else {
            output.method_71478("MatT");
        }
    }

    @Override
    @NotNull
    public class_1799 getHostBlock() {
        return this.frameBase;
    }

    @Override
    public void setHostBlock(@NotNull class_1799 stack) {
        this.frameBase = stack;
    }

    @Override
    @NotNull
    public class_1799 getMaterial(FrameMaterial material) {
        return switch (material) {
            default -> throw new MatchException(null, null);
            case FrameMaterial.SIDE -> this.materialSide;
            case FrameMaterial.TRIM -> this.materialTrim;
            case FrameMaterial.FRONT -> this.materialFront;
        };
    }

    @Override
    public void setMaterial(FrameMaterial material, @NotNull class_1799 stack) {
        switch (material) {
            case SIDE: {
                this.materialSide = stack;
                break;
            }
            case TRIM: {
                this.materialTrim = stack;
                break;
            }
            case FRONT: {
                this.materialFront = stack;
            }
        }
    }
}

