/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.state.DrawersRenderState;
import com.jaquadro.minecraft.storagedrawers.config.ModClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import java.util.ArrayList;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5481;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BlockEntityDrawersRenderer
implements class_827<BlockEntityDrawers, DrawersRenderState> {
    private final class_5614.class_5615 context;
    private static final int TEXT_COLOR_TRANSPARENT = class_9848.method_61324((int)0, (int)255, (int)255, (int)255);
    private static final Matrix3f ITEM_LIGHT_ROTATION_3D = new Matrix3f().rotationYXZ(0.36f, -0.36f, -0.014f);
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};
    public static final class_2960 TEXTURE_IND_1 = ModConstants.loc("block/indicator/indicator_1_on");
    public static final class_2960 TEXTURE_IND_2 = ModConstants.loc("block/indicator/indicator_2_on");
    public static final class_2960 TEXTURE_IND_4 = ModConstants.loc("block/indicator/indicator_4_on");
    public static final class_2960 TEXTURE_IND_COMP_3 = ModConstants.loc("block/indicator/indicator_comp_on");
    public static final class_2960 TEXTURE_IND_COMP_2 = ModConstants.loc("block/indicator/indicator_comp2_on");

    public BlockEntityDrawersRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    public DrawersRenderState createRenderState() {
        return new DrawersRenderState();
    }

    public void extractRenderState(BlockEntityDrawers blockEntity, DrawersRenderState renderState, float partialTick, class_243 cameraPos, @Nullable class_11683.class_11792 crumbleOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, partialTick, cameraPos, crumbleOverlay);
        renderState.cameraPos = cameraPos;
        renderState.enforcedLightLevel = blockEntity.upgrades().hasIlluminationUpgrade() ? (Integer)ModCommonConfig.INSTANCE.UPGRADES.illuminationUpgrade.illuminationLevel.get() : (Integer)ModCommonConfig.INSTANCE.UPGRADES.illuminationUpgrade.minIlluminationLevel.get();
        int blockLight = Math.max(renderState.field_62676 % 65536, renderState.enforcedLightLevel * 16);
        renderState.field_62676 = renderState.field_62676 & 0xFFFF0000 | blockLight;
        IDrawerAttributes attr = blockEntity.getDrawerAttributes();
        renderState.isConcealed = attr.isConcealed();
        renderState.showCount = attr.isShowingQuantity();
        renderState.showFill = attr.hasFillLevel();
        int longPos = (int)blockEntity.method_11016().method_10063();
        renderState.items = new ArrayList<DrawersRenderState.SlotState>();
        IDrawerGroup group = blockEntity.getGroup();
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            class_10444 itemState = new class_10444();
            this.context.comp_4536().method_65598(itemState, drawer.getStoredItemPrototype(), class_811.field_4317, blockEntity.method_10997(), null, longPos + i);
            renderState.items.add(new DrawersRenderState.SlotState(itemState, drawer.getStoredItemCount(), drawer.getMaxCapacity()));
        }
    }

    public void submit(DrawersRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (!(renderState.field_62674.method_26204() instanceof BlockDrawers)) {
            return;
        }
        class_2350 side = (class_2350)renderState.field_62674.method_11654((class_2769)BlockDrawers.field_11177);
        if (this.playerBehindBlock(renderState.field_62673, side)) {
            return;
        }
        float distance = (float)Math.sqrt(renderState.field_62673.method_19770((class_2374)renderState.cameraPos));
        double renderDistance = (Double)ModClientConfig.INSTANCE.RENDER.labelRenderDistance.get();
        if (renderDistance > 0.0 && (double)distance > renderDistance) {
            return;
        }
        if (!renderState.isConcealed) {
            this.renderFastItemSet(renderState, poseStack, submitNodeCollector, cameraRenderState, distance);
        }
    }

    private boolean playerBehindBlock(class_2338 blockPos, class_2350 facing) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_2338 playerPos = player.method_24515();
        return switch (facing) {
            case class_2350.field_11043 -> {
                if (playerPos.method_10260() > blockPos.method_10260()) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11035 -> {
                if (playerPos.method_10260() < blockPos.method_10260()) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11039 -> {
                if (playerPos.method_10263() > blockPos.method_10263()) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11034 -> {
                if (playerPos.method_10263() < blockPos.method_10263()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void renderFastItemSet(DrawersRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, float distance) {
        int drawerCount = renderState.items.size();
        for (int i = 0; i < drawerCount; ++i) {
            this.renderFastItem(i, renderState, poseStack, submitNodeCollector, cameraRenderState);
        }
        if (renderState.showCount) {
            double renderDistance;
            float alpha = 1.0f;
            double fadeDistance = (Double)ModClientConfig.INSTANCE.RENDER.quantityFadeDistance.get();
            if (fadeDistance == 0.0 || (double)distance > fadeDistance) {
                alpha = Math.max(1.0f - (distance - 4.0f) / 6.0f, 0.05f);
            }
            if ((renderDistance = ((Double)ModClientConfig.INSTANCE.RENDER.quantityRenderDistance.get()).doubleValue()) == 0.0 || (double)distance < renderDistance) {
                for (int i = 0; i < drawerCount; ++i) {
                    String format = CountFormatter.format(this.context.comp_4540(), renderState.items.get(i).count());
                    this.renderText(i, format, renderState, poseStack, submitNodeCollector, cameraRenderState, alpha);
                }
            }
        }
    }

    private void renderText(int slot, String text, DrawersRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, float alpha) {
        DrawersRenderState.SlotState slotInfo = renderState.items.get(slot);
        class_10444 itemState = slotInfo.itemState();
        if (itemState == null || itemState.method_65606()) {
            return;
        }
        if (text == null || text.isEmpty()) {
            return;
        }
        class_327 fontRenderer = this.context.comp_4540();
        class_2248 class_22482 = renderState.field_62674.method_26204();
        if (!(class_22482 instanceof BlockDrawers)) {
            return;
        }
        BlockDrawers block = (BlockDrawers)class_22482;
        class_238 labelGeometry = block.countGeometry[slot];
        int textWidth = fontRenderer.method_1727(text);
        float x = (float)(labelGeometry.field_1323 + labelGeometry.method_17939() / 2.0);
        float y = 16.0f - (float)labelGeometry.field_1322 - (float)labelGeometry.method_17940();
        float z = (float)labelGeometry.field_1321 * 0.0625f - 0.01f;
        poseStack.method_22903();
        class_2350 side = (class_2350)renderState.field_62674.method_11654((class_2769)BlockDrawers.field_11177);
        this.alignRendering(poseStack, side);
        poseStack.method_46416(x / 16.0f, 1.0f - y / 16.0f, 1.0f - z);
        poseStack.method_22905(0.0078125f, -0.0078125f, 1.0f);
        int color = (int)(255.0f * alpha) << 24 | TEXT_COLOR_TRANSPARENT;
        submitNodeCollector.method_73478(poseStack, (float)(-textWidth) / 2.0f, 0.0f, class_5481.method_30747((String)text, (class_2583)class_2583.field_24360), false, class_327.class_6415.field_33995, renderState.field_62676, color, 0, 0);
        poseStack.method_22909();
    }

    private void renderFastItem(int slot, DrawersRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        DrawersRenderState.SlotState slotInfo = renderState.items.get(slot);
        class_10444 itemState = slotInfo.itemState();
        if (itemState == null || itemState.method_65606()) {
            return;
        }
        class_2248 class_22482 = renderState.field_62674.method_26204();
        if (!(class_22482 instanceof BlockDrawers)) {
            return;
        }
        BlockDrawers block = (BlockDrawers)class_22482;
        class_238 labelGeometry = block.labelGeometry[slot];
        float scaleX = (float)labelGeometry.method_17939() / 16.0f;
        float scaleY = (float)labelGeometry.method_17940() / 16.0f;
        float moveX = (float)labelGeometry.field_1323 + 8.0f * scaleX;
        float moveY = 16.0f - (float)labelGeometry.field_1325 + 8.0f * scaleY;
        float moveZ = (float)labelGeometry.field_1321 * 0.0625f - 0.0025f;
        poseStack.method_22903();
        class_2350 side = (class_2350)renderState.field_62674.method_11654((class_2769)BlockDrawers.field_11177);
        this.alignRendering(poseStack, side);
        poseStack.method_46416(moveX / 16.0f, 1.0f - moveY / 16.0f, 1.0f - moveZ);
        poseStack.method_34425((Matrix4fc)new Matrix4f().scale(scaleX, scaleY, 0.001f));
        poseStack.method_23760().field_48930 = true;
        try {
            poseStack.method_23760().method_23762().rotateYXZ(-this.getRotationYForSide2D(side), 0.0f, 0.0f).mul((Matrix3fc)ITEM_LIGHT_ROTATION_3D);
            itemState.method_65604(poseStack, submitNodeCollector, renderState.field_62676, class_4608.field_21444, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        poseStack.method_22909();
    }

    private void alignRendering(class_4587 poseStack, class_2350 side) {
        poseStack.method_46416(0.5f, 0.0f, 0.5f);
        poseStack.method_34425((Matrix4fc)new Matrix4f().rotateYXZ(this.getRotationYForSide2D(side), 0.0f, 0.0f));
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
    }

    private float getRotationYForSide2D(class_2350 side) {
        return sideRotationY2D[side.ordinal()] * 90.0f * (float)Math.PI / 180.0f;
    }
}

