/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.EnumFramingTablePart;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.renderer.state.FramingRenderState;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BlockEntityFramingRenderer
implements class_827<BlockEntityFramingTable, FramingRenderState> {
    private final class_5614.class_5615 context;

    public BlockEntityFramingRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    public FramingRenderState createRenderState() {
        return new FramingRenderState();
    }

    public void extractRenderState(BlockEntityFramingTable blockEntity, FramingRenderState renderState, float partialTick, class_243 cameraPos, @Nullable class_11683.class_11792 crumbleOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, partialTick, cameraPos, crumbleOverlay);
        int longPos = (int)blockEntity.method_11016().method_10063();
        MaterialData matData = blockEntity.material();
        if (matData != null) {
            class_1747 blockItem;
            class_2248 targetBlock;
            class_1792 class_17922;
            renderState.sideSlotItem = this.getRenderState(matData.getSide(), blockEntity.method_10997(), longPos + 1);
            renderState.trimSlotItem = this.getRenderState(matData.getTrim(), blockEntity.method_10997(), longPos + 2);
            renderState.frontSlotItem = this.getRenderState(matData.getFront(), blockEntity.method_10997(), longPos + 3);
            class_1799 target = blockEntity.inventory().method_5438(0);
            if (target != null && (class_17922 = target.method_7909()) instanceof class_1747 && (targetBlock = (blockItem = (class_1747)class_17922).method_7711()) instanceof IFramedSourceBlock) {
                IFramedSourceBlock fsb = (IFramedSourceBlock)targetBlock;
                class_1799 result = fsb.makeFramedItem(target, matData.getEffectiveSide(), matData.getEffectiveTrim(), matData.getEffectiveFront());
                renderState.mainSlotItem = this.getRenderState(result, blockEntity.method_10997(), longPos);
            }
        }
    }

    private class_10444 getRenderState(class_1799 itemStack, class_1937 level, int id) {
        class_10444 itemState = new class_10444();
        this.context.comp_4536().method_65598(itemState, itemStack, class_811.field_4318, level, null, id);
        return itemState;
    }

    public void submit(FramingRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (!(renderState.field_62674.method_26204() instanceof BlockFramingTable)) {
            return;
        }
        if (renderState.field_62674.method_11654(BlockFramingTable.PART) != EnumFramingTablePart.RIGHT) {
            return;
        }
        this.renderSlot(renderState, renderState.mainSlotItem, poseStack, submitNodeCollector, cameraRenderState, 1.6f, 0.5f, 0.1f, -0.5f);
        this.renderSlot(renderState, renderState.sideSlotItem, poseStack, submitNodeCollector, cameraRenderState, 1.0f, 1.15f, 0.15f, -0.275f);
        this.renderSlot(renderState, renderState.trimSlotItem, poseStack, submitNodeCollector, cameraRenderState, 1.0f, -0.14999998f, 0.15f, -0.275f);
        this.renderSlot(renderState, renderState.frontSlotItem, poseStack, submitNodeCollector, cameraRenderState, 1.0f, 1.15f, 0.15f, -0.725f);
    }

    private void renderSlot(FramingRenderState renderState, class_10444 itemState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, float scale, float tx, float ty, float tz) {
        if (itemState == null || itemState.method_65606()) {
            return;
        }
        class_2350 facing = (class_2350)renderState.field_62674.method_11654((class_2769)BlockFramingTable.field_11177);
        poseStack.method_22903();
        switch (facing) {
            case field_11043: {
                poseStack.method_34425((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(180.0)));
                break;
            }
            case field_11034: {
                poseStack.method_34425((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(90.0)));
                break;
            }
            case field_11039: {
                poseStack.method_34425((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(270.0)));
                break;
            }
            case field_11035: {
                poseStack.method_34425((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(0.0)));
            }
        }
        switch (facing) {
            case field_11043: {
                poseStack.method_46416(-0.5f, 0.8f, 0.0f);
                break;
            }
            case field_11034: {
                poseStack.method_46416(-0.5f, 0.8f, 1.0f);
                break;
            }
            case field_11039: {
                poseStack.method_46416(0.5f, 0.8f, 0.0f);
                break;
            }
            case field_11035: {
                poseStack.method_46416(0.5f, 0.8f, 1.0f);
            }
        }
        poseStack.method_46416(tx, ty, tz);
        poseStack.method_34425((Matrix4fc)new Matrix4f().scale(scale, scale, scale));
        try {
            itemState.method_65604(poseStack, submitNodeCollector, renderState.field_62676, class_4608.field_21444, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        poseStack.method_22909();
    }

    public class_238 getRenderBoundingBox(BlockEntityFramingTable blockEntity) {
        class_2338 pos = blockEntity.method_11016();
        return class_238.method_54784((class_2338)pos.method_10069(-1, 0, -1), (class_2338)pos.method_10069(1, 1, 1));
    }
}

