/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.components.item.KeyringContents;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.tooltip.KeyringTooltip;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.util.ComponentUtil;
import com.texelsaurus.minecraft.chameleon.registry.RegistryEntry;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class ItemKeyring
extends class_1792 {
    private static final String TAG_ITEMS = "Items";
    private final RegistryEntry<? extends ItemKey> key;

    public ItemKeyring(RegistryEntry<? extends ItemKey> key, class_1792.class_1793 properties) {
        super(properties);
        this.key = key;
    }

    public class_1799 getKey() {
        if (this.key == null) {
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)this.key.get(), 1);
    }

    public boolean method_31566(class_1799 targetStack, class_1799 stack, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        class_1799 newStack;
        if (action != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        if (targetStack.method_7947() != 1) {
            return false;
        }
        KeyringContents contents = (KeyringContents)targetStack.method_58695((class_9331)ModDataComponents.KEYRING_CONTENTS.get(), (Object)KeyringContents.EMPTY);
        KeyringContents.Mutable mutable = new KeyringContents.Mutable(contents);
        if (stack.method_7960()) {
            class_1799 removed = mutable.removeOne();
            if (removed != null) {
                access.method_32332(removed);
                if (mutable.size() == 0) {
                    targetStack.method_57381((class_9331)ModDataComponents.KEYRING_CONTENTS.get());
                } else {
                    contents = mutable.toImmutable();
                    targetStack.method_57379((class_9331)ModDataComponents.KEYRING_CONTENTS.get(), (Object)contents);
                }
            }
            if (ItemKeyring.getContents(targetStack).findAny().isEmpty()) {
                class_1799 newStack2 = new class_1799((class_1935)ModItems.KEYRING.get(), 1);
                newStack2.method_57366(targetStack.method_57380());
                slot.method_7673(newStack2);
            } else {
                class_1799 newStack3 = this.rotateKeyring(targetStack);
                slot.method_7673(newStack3);
            }
            return true;
        }
        mutable.tryInsert(stack);
        contents = mutable.toImmutable();
        targetStack.method_57379((class_9331)ModDataComponents.KEYRING_CONTENTS.get(), (Object)contents);
        if (targetStack.method_7909() == ModItems.KEYRING.get() && contents.size() > 0 && !(newStack = ItemKeyring.getKeyring(contents.itemCopyStream().findFirst().orElse(class_1799.field_8037))).method_7960()) {
            newStack.method_57366(targetStack.method_57380());
            newStack.method_57379((class_9331)ModDataComponents.KEYRING_CONTENTS.get(), (Object)contents);
            slot.method_7673(newStack);
        }
        return true;
    }

    public class_1269 method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!player.method_5715()) {
            return class_1269.field_5811;
        }
        List<class_1799> list = ItemKeyring.getContents(stack).toList();
        if (list.isEmpty()) {
            return class_1269.field_5811;
        }
        class_1799 keyring = this.rotateKeyring(stack);
        return class_1269.field_5812.method_61393(keyring);
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036().method_5715()) {
            return class_1269.field_5811;
        }
        if (this.key != null) {
            class_1269 result = ((ItemKey)((Object)this.key.get())).method_7884(context);
            if (result == class_1269.field_5812) {
                context.method_8036().method_7357().method_62835(context.method_8041(), 5);
            }
            return result;
        }
        return class_1269.field_5811;
    }

    public static class_1799 getKeyring(class_1799 item) {
        if (item.method_7960() || !(item.method_7909() instanceof ItemKey)) {
            return class_1799.field_8037;
        }
        Optional<ItemKeyring> keyring = ModItems.getKeyrings().filter(s -> s.getKey().method_7909() == item.method_7909()).findFirst();
        if (!keyring.isPresent()) {
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)keyring.get(), 1);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_10712 tooltipdisplay = (class_10712)stack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
        if (!tooltipdisplay.method_67214((class_9331)ModDataComponents.KEYRING_CONTENTS.get())) {
            return Optional.empty();
        }
        if (!stack.method_57826((class_9331)ModDataComponents.KEYRING_CONTENTS.get())) {
            return Optional.of(new KeyringTooltip(new KeyringContents(List.of())));
        }
        return Optional.ofNullable((KeyringContents)stack.method_58694((class_9331)ModDataComponents.KEYRING_CONTENTS.get())).map(KeyringTooltip::new);
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 display, Consumer<class_2561> tooltip, class_1836 flag) {
        super.method_67187(stack, context, display, tooltip, flag);
        KeyringContents contents = (KeyringContents)stack.method_58694((class_9331)ModDataComponents.KEYRING_CONTENTS.get());
        if (contents == null || contents.isEmpty()) {
            ComponentUtil.appendSplitDescription(tooltip, this.getDescription());
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        if (this.key == null || this.key.get() == null) {
            return super.method_7864(stack);
        }
        class_1799 activeKey = ItemKeyring.getActiveKey(stack, (class_1792)this.key.get());
        Object subName = activeKey != null ? activeKey.method_7964() : class_2561.method_43471((String)((ItemKey)((Object)this.key.get())).method_7876());
        class_5250 name = class_2561.method_43471((String)((ItemKeyring)((Object)ModItems.KEYRING.get())).method_7876());
        return name.method_27693(" (").method_10852(subName).method_27693(")");
    }

    @NotNull
    public class_2561 getDescription() {
        return class_2561.method_43471((String)(((ItemKeyring)((Object)ModItems.KEYRING.get())).method_7876() + ".desc"));
    }

    public void method_33261(class_1542 entity) {
        KeyringContents contents = (KeyringContents)entity.method_6983().method_58694((class_9331)ModDataComponents.KEYRING_CONTENTS.get());
        if (contents != null) {
            entity.method_6983().method_57379((class_9331)ModDataComponents.KEYRING_CONTENTS.get(), (Object)KeyringContents.EMPTY);
            class_5328.method_33263((class_1542)entity, contents.itemsCopy());
        }
    }

    private static class_1799 getActiveKey(class_1799 stack, class_1792 item) {
        KeyringContents contents = (KeyringContents)stack.method_58694((class_9331)ModDataComponents.KEYRING_CONTENTS.get());
        if (contents == null || contents.size() == 0) {
            return null;
        }
        return contents.itemCopyStream().filter(t -> class_1799.method_7984((class_1799)t, (class_1799)new class_1799((class_1935)item))).findFirst().orElse(null);
    }

    private static Stream<class_1799> getContents(class_1799 stack) {
        KeyringContents contents = (KeyringContents)stack.method_58694((class_9331)ModDataComponents.KEYRING_CONTENTS.get());
        if (contents == null || contents.size() == 0) {
            return Stream.empty();
        }
        return contents.itemCopyStream();
    }

    private class_1799 rotateKeyring(class_1799 stack) {
        List<class_1799> list = ItemKeyring.getContents(stack).toList();
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).method_7909() != this.key.get()) continue;
            index = i;
            break;
        }
        if (++index >= list.size()) {
            index = 0;
        }
        class_1799 nextItem = list.get(index);
        class_1799 keyring = ItemKeyring.getKeyring(nextItem);
        keyring.method_57366(stack.method_57380());
        return keyring;
    }
}

