/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;

public class CompactingHelper {
    private static final InventoryLookup lookup1 = new InventoryLookup(1, 1);
    private static final InventoryLookup lookup2 = new InventoryLookup(2, 2);
    private static final InventoryLookup lookup3 = new InventoryLookup(3, 3);
    private final class_1937 world;

    public CompactingHelper(class_1937 world) {
        this.world = world;
    }

    @NotNull
    public Result findHigherTier(@NotNull class_1799 stack) {
        List<class_1792> candidateItems;
        class_1799 modMatch;
        CompTierRegistry.Record record;
        boolean debugTrace = (Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get();
        if (!this.world.method_8608() && debugTrace) {
            ModServices.log.info("Finding ascending candidates for " + stack.toString());
        }
        if ((record = CompTierRegistry.INSTANCE.findHigherTier(stack)) != null) {
            if (!this.world.method_8608() && debugTrace) {
                ModServices.log.info("Found " + record.upper.toString() + " in registry with conv=" + record.convRate);
            }
            return new Result(record.upper, record.convRate);
        }
        ArrayList<class_1799> candidates = new ArrayList<class_1799>();
        int lookupSize = this.setupLookup(lookup3, stack);
        List<class_1799> fwdCandidates = this.findAllMatchingRecipes((class_8566)lookup3);
        if (fwdCandidates.size() == 0) {
            lookupSize = this.setupLookup(lookup2, stack);
            fwdCandidates = this.findAllMatchingRecipes((class_8566)lookup2);
        }
        if (fwdCandidates.size() > 0) {
            block0: for (class_1799 match : fwdCandidates) {
                this.setupLookup(lookup1, match);
                List<class_1799> backCandidates = this.findAllMatchingRecipes((class_8566)lookup1);
                for (class_1799 comp : backCandidates) {
                    if (comp.method_7947() != lookupSize || !ItemStackMatcher.areItemsEqual(comp, stack)) continue;
                    candidates.add(match);
                    if (this.world.method_8608() || !debugTrace) continue block0;
                    ModServices.log.info("Found ascending candidate for " + stack.toString() + ": " + match.toString() + " size=" + lookupSize + ", inverse=" + comp.toString());
                    continue block0;
                }
            }
        }
        if (!(modMatch = this.findMatchingModCandidate(stack, candidateItems = candidates.stream().map(class_1799::method_7909).toList())).method_7960()) {
            return new Result(modMatch, lookupSize);
        }
        if (candidates.size() > 0) {
            return new Result((class_1799)candidates.get(0), lookupSize);
        }
        if (!this.world.method_8608() && debugTrace) {
            ModServices.log.info("No candidates found");
        }
        return new Result(class_1799.field_8037, 0);
    }

    @NotNull
    public Result findLowerTier(@NotNull class_1799 stack) {
        List<class_1792> candidateItems;
        class_1799 modMatch;
        CompTierRegistry.Record record;
        boolean debugTrace = (Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get();
        if (!this.world.method_8608() && debugTrace) {
            ModServices.log.info("Finding descending candidates for " + stack.toString());
        }
        if ((record = CompTierRegistry.INSTANCE.findLowerTier(stack)) != null) {
            if (!this.world.method_8608() && debugTrace) {
                ModServices.log.info("Found " + record.lower.toString() + " in registry with conv=" + record.convRate);
            }
            return new Result(record.lower, record.convRate);
        }
        ArrayList<class_1799> candidates = new ArrayList<class_1799>();
        HashMap<class_1799, Integer> candidatesRate = new HashMap<class_1799, Integer>();
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_8786 recipe : serverWorld.method_64577().field_54638.method_64698(class_3956.field_17545)) {
                class_1799 match;
                class_1860 class_18602 = recipe.comp_1933();
                if (!(class_18602 instanceof class_1869)) continue;
                class_1869 shaped = (class_1869)class_18602;
                class_1799 output = shaped.field_9053;
                List ingredients = shaped.field_47320.method_59997();
                if (!ItemStackMatcher.areItemsEqual(stack, output) || (match = this.tryMatch(stack, ingredients)).method_7960()) continue;
                int lookupSize = this.setupLookup(lookup1, output);
                List<class_1799> compMatches = this.findAllMatchingRecipes((class_8566)lookup1);
                for (class_1799 comp : compMatches) {
                    int recipeSize = ingredients.size();
                    if (ItemStackMatcher.areItemsEqual(match, comp) && comp.method_7947() == recipeSize) {
                        candidates.add(match);
                        candidatesRate.put(match, recipeSize);
                        if (this.world.method_8608() || !debugTrace) continue;
                        ModServices.log.info("Found descending candidate for " + stack.toString() + ": " + match.toString() + " size=" + recipeSize + ", inverse=" + comp.toString());
                        continue;
                    }
                    if (this.world.method_8608() || !debugTrace) continue;
                    ModServices.log.info("Back-check failed for " + match.toString() + " size=" + lookupSize + ", inverse=" + comp.toString());
                }
            }
        }
        if (!(modMatch = this.findMatchingModCandidate(stack, candidateItems = candidates.stream().map(class_1799::method_7909).toList())).method_7960()) {
            return new Result(modMatch, (Integer)candidatesRate.get(modMatch));
        }
        if (candidates.size() > 0) {
            class_1799 match = (class_1799)candidates.get(0);
            return new Result(match, (Integer)candidatesRate.get(match));
        }
        if (!this.world.method_8608() && debugTrace) {
            ModServices.log.info("No candidates found");
        }
        return new Result(class_1799.field_8037, 0);
    }

    private List<class_1799> findAllMatchingRecipes(class_8566 crafting) {
        ArrayList<class_1799> candidates = new ArrayList<class_1799>();
        class_9694 input = crafting.method_59961();
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_8786 recipe : serverWorld.method_64577().field_54638.method_64699(class_3956.field_17545, (class_9695)input, this.world).toList()) {
                class_1799 result;
                if (!((class_3955)recipe.comp_1933()).method_8115((class_9695)input, this.world) || (result = ((class_3955)recipe.comp_1933()).method_8116((class_9695)input, (class_7225.class_7874)this.world.method_30349())).method_7960()) continue;
                candidates.add(result);
            }
        }
        return candidates;
    }

    @NotNull
    private class_1799 findMatchingModCandidate(@NotNull class_1799 reference, List<class_1792> candidates) {
        class_2960 referenceName = class_7923.field_41178.method_10221((Object)reference.method_7909());
        if (referenceName != null) {
            for (class_1792 candidate : candidates) {
                class_2960 matchName = class_7923.field_41178.method_10221((Object)candidate);
                if (matchName == null || !referenceName.method_12836().equals(matchName.method_12832())) continue;
                return new class_1799((class_1935)candidate);
            }
        }
        return class_1799.field_8037;
    }

    @NotNull
    private class_1799 tryMatch(@NotNull class_1799 stack, List<Optional<class_1856>> ingredients) {
        if (ingredients.size() != 9 && ingredients.size() != 4) {
            return class_1799.field_8037;
        }
        if (ingredients.getFirst().isEmpty()) {
            return class_1799.field_8037;
        }
        class_1856 refIngredient = ingredients.getFirst().get();
        List<class_1792> refMatchingItems = refIngredient.method_8105().map(class_6880::comp_349).toList();
        if (refMatchingItems.isEmpty()) {
            return class_1799.field_8037;
        }
        int n = ingredients.size();
        for (int i = 1; i < n; ++i) {
            if (ingredients.get(i).isEmpty()) {
                return class_1799.field_8037;
            }
            boolean match = false;
            block1: for (class_1792 refItem : refMatchingItems) {
                List<class_1792> slotItems = ingredients.get(i).get().method_8105().map(class_6880::comp_349).toList();
                for (class_1792 slotItem : slotItems) {
                    if (!refItem.equals(slotItem)) continue;
                    match = true;
                    continue block1;
                }
            }
            if (match) continue;
            return class_1799.field_8037;
        }
        class_1799 match = this.findMatchingModCandidate(stack, refMatchingItems);
        if (match.method_7960()) {
            match = new class_1799((class_1935)refMatchingItems.getFirst());
        }
        return match;
    }

    private int setupLookup(InventoryLookup inv, @NotNull class_1799 stack) {
        int n = inv.method_5439();
        for (int i = 0; i < n; ++i) {
            inv.method_5447(i, stack);
        }
        return inv.method_5439();
    }

    public static class Result {
        @NotNull
        private final class_1799 stack;
        private final int size;

        public Result(@NotNull class_1799 stack, int size) {
            this.stack = stack;
            this.size = size;
        }

        @NotNull
        public class_1799 getStack() {
            return this.stack;
        }

        public int getSize() {
            return this.size;
        }
    }

    private static class InventoryLookup
    extends class_1715 {
        private final class_2371<class_1799> items;

        public InventoryLookup(int width, int height) {
            super(null, width, height);
            this.items = class_2371.method_10213((int)(width * height), (Object)class_1799.field_8037);
        }

        public int method_5439() {
            return this.items.size();
        }

        public boolean method_5442() {
            for (class_1799 itemstack : this.items) {
                if (itemstack.method_7960()) continue;
                return false;
            }
            return true;
        }

        public class_1799 method_5438(int slot) {
            return slot >= this.method_5439() ? class_1799.field_8037 : (class_1799)this.items.get(slot);
        }

        public void method_5447(int slot, class_1799 stack) {
            stack = stack.method_7972();
            stack.method_7939(1);
            this.items.set(slot, (Object)stack);
        }

        @NotNull
        public class_1799 method_5441(int slot) {
            return class_1799.field_8037;
        }

        @NotNull
        public class_1799 method_5434(int slot, int count) {
            return class_1799.field_8037;
        }

        public void method_5448() {
        }

        public List<class_1799> method_51305() {
            return List.copyOf(this.items);
        }
    }
}

