/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.capabilities.PlatformCapabilities;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.config.MaterialBlacklist;
import com.jaquadro.minecraft.storagedrawers.config.ModClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.config.StorageBlacklist;
import com.jaquadro.minecraft.storagedrawers.core.Api;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModNetworking;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.core.PlayerEventListener;
import com.jaquadro.minecraft.storagedrawers.network.PlayerBoolConfigMessage;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.registry.NeoforgeRegistryContext;
import com.texelsaurus.minecraft.chameleon.service.ChameleonConfig;
import com.texelsaurus.minecraft.chameleon.service.NeoforgeConfig;
import com.texelsaurus.minecraft.chameleon.service.NeoforgeNetworking;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="storagedrawers")
public class StorageDrawers {
    public static final String MOD_ID = "storagedrawers";
    public static final Api api = new Api();
    public static Logger log = LogManager.getLogger();

    public StorageDrawers(ModContainer modContainer, IEventBus modEventBus) {
        ModCommonConfig.INSTANCE.context().init(MOD_ID, ChameleonConfig.Type.COMMON);
        ModClientConfig.INSTANCE.context().init(MOD_ID, ChameleonConfig.Type.CLIENT);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)((NeoforgeConfig)ModCommonConfig.INSTANCE.context()).neoSpec, "storagedrawers-common.v2.toml");
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)((NeoforgeConfig)ModClientConfig.INSTANCE.context()).neoSpec);
        NeoforgeRegistryContext regContext = new NeoforgeRegistryContext(modEventBus);
        ModBlocks.init(regContext);
        ModItems.init(regContext);
        ModBlockEntities.init(regContext);
        ModContainers.init(regContext);
        ModDataComponents.init(regContext);
        ModRecipes.init(regContext);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::onModConfigEvent);
        modEventBus.addListener(ModCreativeTabs::init);
        modEventBus.addListener(PlatformCapabilities::register);
        NeoforgeNetworking.init(MOD_ID, ModNetworking.INSTANCE, regContext);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new PlayerEventListener());
    }

    private void setup(FMLCommonSetupEvent event) {
        CompTierRegistry.INSTANCE.initialize();
        StorageBlacklist.INSTANCE.initialize();
        MaterialBlacklist.INSTANCE.initialize();
    }

    private void onModConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            ModCommonConfig.INSTANCE.setLoaded();
        }
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            ModClientConfig.INSTANCE.setLoaded();
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (!event.getLevel().isClientSide() || !(event.getEntity() instanceof Player)) {
            return;
        }
        if (Minecraft.getInstance().player == null) {
            return;
        }
        UUID playerId = Minecraft.getInstance().player.getUUID();
        if (event.getEntity().getUUID() == playerId) {
            ChameleonServices.NETWORK.sendToServer(new PlayerBoolConfigMessage(playerId.toString(), "invertShift", (Boolean)ModClientConfig.INSTANCE.GENERAL.invertShift.get()));
            ChameleonServices.NETWORK.sendToServer(new PlayerBoolConfigMessage(playerId.toString(), "invertClick", (Boolean)ModClientConfig.INSTANCE.GENERAL.invertClick.get()));
        }
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

