/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IPortable;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class PlayerEventListener {
    private void applyDebuff(Player plr) {
        plr.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 3, true, true));
    }

    @SubscribeEvent
    public void onPlayerPickup(ItemEntityPickupEvent.Post event) {
        if (!ModCommonConfig.INSTANCE.DRAWERS.anyHeavyDrawers()) {
            return;
        }
        this.checkItemDebuf(event.getItemEntity().getItem(), event.getPlayer());
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().tickCount % 60 != 0) {
            return;
        }
        if (event.getEntity() instanceof ServerPlayer) {
            ItemUpgradeRemote.validateInventory(event.getEntity().getInventory(), event.getEntity().level());
        }
        if (!ModCommonConfig.INSTANCE.DRAWERS.anyHeavyDrawers()) {
            return;
        }
        for (ItemStack s : event.getEntity().getAllSlots()) {
            if (!this.checkItemDebuf(s, event.getEntity())) continue;
            return;
        }
        Inventory inv = event.getEntity().getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            if (!this.checkItemDebuf(inv.getItem(i), event.getEntity())) continue;
            return;
        }
    }

    private boolean checkItemDebuf(ItemStack stack, Player player) {
        IPortable ip;
        Item item = stack.getItem();
        if (item instanceof IPortable && (ip = (IPortable)item).isHeavy((HolderLookup.Provider)player.level().registryAccess(), stack)) {
            this.applyDebuff(player);
            return true;
        }
        return false;
    }
}

