/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.components.item.DetachedDrawerContents;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.item.ItemDetachedDrawer;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeDetachedDrawerRecipe
extends CustomRecipe {
    public UpgradeDetachedDrawerRecipe(CraftingBookCategory cat) {
        super(cat);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level world) {
        return this.findContext(inv) != null;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, HolderLookup.Provider access) {
        Context ctx = this.findContext(inv);
        if (ctx == null) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = ctx.drawer.copy();
        CustomData cdata = (CustomData)ret.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        DetachedDrawerData data = new DetachedDrawerData(access, cdata.copyTag());
        int cap = data.getStorageMultiplier();
        if (ctx.upgrades.isEmpty()) {
            ret = ((Item)ModItems.DETACHED_DRAWER.get()).getDefaultInstance();
            data = new DetachedDrawerData();
            data.setStorageMultiplier(cap);
        } else {
            int addedCap = ctx.storageMult * (Integer)ModCommonConfig.INSTANCE.DRAWERS.baseStackStorage.get() * (Integer)ModCommonConfig.INSTANCE.DRAWERS.fullDrawers1x1.unitsPerSlot.get();
            data.setStorageMultiplier(data.getStorageMultiplier() + addedCap);
        }
        ret.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)data.serializeNBT(access)));
        ItemStack savedItem = data.getStoredItemPrototype().copyWithCount(data.getStoredItemCount());
        DetachedDrawerContents contents = new DetachedDrawerContents(savedItem, cap, data.isHeavy());
        ret.set((DataComponentType)ModDataComponents.DETACHED_DRAWER_CONTENTS.get(), (Object)contents);
        return ret;
    }

    @Nullable
    private Context findContext(CraftingInput inv) {
        Context ret = new Context();
        for (int x = 0; x < inv.size(); ++x) {
            ItemStack stack = inv.getItem(x);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ItemDetachedDrawer) {
                if (!ret.drawer.isEmpty()) {
                    return null;
                }
                ret.drawer = stack;
                continue;
            }
            if (stack.getItem() instanceof ItemUpgradeStorage) {
                ret.upgrades.add(stack);
                continue;
            }
            return null;
        }
        if (ret.drawer.isEmpty()) {
            return null;
        }
        for (ItemStack upgrade : ret.upgrades) {
            Item item = upgrade.getItem();
            if (!(item instanceof ItemUpgradeStorage)) continue;
            ItemUpgradeStorage storageUpgrade = (ItemUpgradeStorage)item;
            ret.storageMult += ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(storageUpgrade.level.getLevel());
        }
        return ret;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.DETACHED_UPGRADE_RECIPE_SERIALIZER.get();
    }

    private static class Context {
        ItemStack drawer = ItemStack.EMPTY;
        List<ItemStack> upgrades = new ArrayList<ItemStack>();
        int storageMult = 0;

        private Context() {
        }
    }
}

