/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IPortable;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class PlayerEventListener {
    private void applyDebuff(Player plr) {
        plr.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 3, true, true));
    }

    @SubscribeEvent
    public void onPlayerPickup(EntityItemPickupEvent event) {
        if (!ModCommonConfig.INSTANCE.DRAWERS.anyHeavyDrawers()) {
            return;
        }
        this.checkItemDebuf(event.getItem().getItem(), event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.tickCount % 60 != 0) {
            return;
        }
        if (event.side == LogicalSide.SERVER) {
            ItemUpgradeRemote.validateInventory(event.player.getInventory(), event.player.level());
        }
        if (!ModCommonConfig.INSTANCE.DRAWERS.anyHeavyDrawers()) {
            return;
        }
        for (ItemStack s : event.player.getAllSlots()) {
            if (!this.checkItemDebuf(s, event.player)) continue;
            return;
        }
        Inventory inv = event.player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            if (!this.checkItemDebuf(inv.getItem(i), event.player)) continue;
            return;
        }
    }

    private boolean checkItemDebuf(ItemStack stack, Player player) {
        IPortable ip;
        Item item = stack.getItem();
        if (item instanceof IPortable && (ip = (IPortable)item).isHeavy((HolderLookup.Provider)player.level().registryAccess(), stack)) {
            this.applyDebuff(player);
            return true;
        }
        return false;
    }
}

