/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.block.EnumFramingTablePart;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import com.mojang.serialization.MapCodec;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockFramingTable
extends class_2383
implements class_2343 {
    public static final class_2754<EnumFramingTablePart> PART = class_2754.method_11850((String)"part", EnumFramingTablePart.class);
    public static final MapCodec<BlockFramingTable> CODEC = BlockFramingTable.method_54094(BlockFramingTable::new);
    protected static final class_265 TABLE_TOP = class_2248.method_9541((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 TABLE_BOTTOM_NORTH = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final class_265 TABLE_BOTTOM_SOUTH = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final class_265 TABLE_BOTTOM_WEST = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final class_265 TABLE_BOTTOM_EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final class_265 TABLE_SHAPE_NORTH = class_259.method_1084((class_265)TABLE_TOP, (class_265)TABLE_BOTTOM_NORTH);
    protected static final class_265 TABLE_SHAPE_SOUTH = class_259.method_1084((class_265)TABLE_TOP, (class_265)TABLE_BOTTOM_SOUTH);
    protected static final class_265 TABLE_SHAPE_WEST = class_259.method_1084((class_265)TABLE_TOP, (class_265)TABLE_BOTTOM_WEST);
    protected static final class_265 TABLE_SHAPE_EAST = class_259.method_1084((class_265)TABLE_TOP, (class_265)TABLE_BOTTOM_EAST);
    private static final Logger log = LoggerFactory.getLogger(BlockFramingTable.class);

    public BlockFramingTable(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(PART, (Comparable)((Object)EnumFramingTablePart.RIGHT)));
    }

    protected MapCodec<? extends class_2383> method_53969() {
        return CODEC;
    }

    public static class_2350 getTableDirection(class_1922 getter, class_2338 pos) {
        class_2680 state = getter.method_8320(pos);
        return state.method_26204() instanceof BlockFramingTable ? (class_2350)state.method_11654((class_2769)field_11177) : null;
    }

    private static class_2350 getNeighborDirection(EnumFramingTablePart part, class_2350 direction) {
        return part == EnumFramingTablePart.LEFT ? direction.method_10170() : direction.method_10160();
    }

    public class_265 method_9530(class_2680 state, class_1922 getter, class_2338 pos, class_3726 context) {
        EnumFramingTablePart part = (EnumFramingTablePart)((Object)state.method_11654(PART));
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
        return switch (facing) {
            case class_2350.field_11043 -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_WEST;
                }
                yield TABLE_SHAPE_EAST;
            }
            case class_2350.field_11035 -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_EAST;
                }
                yield TABLE_SHAPE_WEST;
            }
            case class_2350.field_11039 -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_NORTH;
                }
                yield TABLE_SHAPE_SOUTH;
            }
            case class_2350.field_11034 -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_SOUTH;
                }
                yield TABLE_SHAPE_NORTH;
            }
            default -> TABLE_TOP;
        };
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!level.field_9236) {
            BlockFramingTable.preventCreativeDropFromLeft(level, pos, state, player);
            if (!player.method_7337() && state.method_11654(PART) != EnumFramingTablePart.RIGHT) {
                BlockFramingTable.method_9511((class_2680)((class_2680)state.method_11657(PART, (Comparable)((Object)EnumFramingTablePart.RIGHT))), (class_1937)level, (class_2338)pos, null, (class_1297)player, (class_1799)player.method_6047());
            }
        }
        return super.method_9576(level, pos, state, player);
    }

    protected static void preventCreativeDropFromLeft(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 pos2;
        class_2680 state2;
        EnumFramingTablePart part = (EnumFramingTablePart)((Object)state.method_11654(PART));
        if (part == EnumFramingTablePart.RIGHT) {
            class_2338 pos22 = pos.method_10093(BlockFramingTable.getNeighborDirection(part, (class_2350)state.method_11654((class_2769)field_11177)));
            class_2680 state22 = level.method_8320(pos22);
            if (state22.method_27852(state.method_26204()) && state22.method_11654(PART) == EnumFramingTablePart.LEFT) {
                level.method_8652(pos22, class_2246.field_10124.method_9564(), 35);
                level.method_8444(player, 2001, pos22, class_2248.method_9507((class_2680)state22));
            }
        } else if (part == EnumFramingTablePart.LEFT && (state2 = level.method_8320(pos2 = pos.method_10093(BlockFramingTable.getNeighborDirection(part, (class_2350)state.method_11654((class_2769)field_11177))))).method_27852(state.method_26204()) && state2.method_11654(PART) == EnumFramingTablePart.RIGHT) {
            level.method_8652(pos2, class_2246.field_10124.method_9564(), 35);
            level.method_8444(player, 2001, pos2, class_2248.method_9507((class_2680)state2));
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350 direction = context.method_8042();
        class_2350 dirLeft = direction.method_10160();
        class_2338 pos = context.method_8037();
        class_2338 pos2 = pos.method_10093(dirLeft);
        return context.method_8045().method_8320(pos2).method_26166(context) && context.method_8045().method_8621().method_11952(pos2) ? (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction) : null;
    }

    public static class_2350 getConnectedDirection(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        return state.method_11654(PART) == EnumFramingTablePart.RIGHT ? direction.method_10153() : direction;
    }

    public static class_4732.class_4733 getBlockType(class_2680 state) {
        EnumFramingTablePart part = (EnumFramingTablePart)((Object)state.method_11654(PART));
        return part == EnumFramingTablePart.RIGHT ? class_4732.class_4733.field_21784 : class_4732.class_4733.field_21785;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, PART});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BlockEntityFramingTable((class_2591)ModBlockEntities.FRAMING_TABLE.get(), pos, state);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
        super.method_9567(level, pos, state, entity, stack);
        if (!level.field_9236) {
            class_2350 dirLeft = ((class_2350)state.method_11654((class_2769)field_11177)).method_10160();
            class_2338 pos2 = pos.method_10093(dirLeft);
            level.method_8652(pos2, (class_2680)state.method_11657(PART, (Comparable)((Object)EnumFramingTablePart.LEFT)), 3);
            level.method_8408(pos, class_2246.field_10124);
            state.method_30101((class_1936)level, pos, 3);
        }
    }

    public class_1269 method_55766(@NotNull class_2680 state, class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_3965 hit) {
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        if (state.method_11654(PART) != EnumFramingTablePart.RIGHT) {
            pos = pos.method_10093(BlockFramingTable.getNeighborDirection((EnumFramingTablePart)((Object)state.method_11654(PART)), (class_2350)state.method_11654((class_2769)field_11177)));
        }
        this.openUI(level, pos, player);
        return class_1269.field_21466;
    }

    protected void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 replacementState, boolean isMoving) {
        BlockEntityFramingTable blockEntity = WorldUtils.getBlockEntity((class_1922)level, pos, BlockEntityFramingTable.class);
        if (blockEntity != null) {
            for (int i = 0; i < 4; ++i) {
                class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)blockEntity.inventory().method_5438(i));
            }
        }
        super.method_9536(state, level, pos, replacementState, isMoving);
    }

    @Nullable
    protected class_3908 method_17454(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        BlockEntityFramingTable blockEntity = WorldUtils.getBlockEntity((class_1922)level, blockPos, BlockEntityFramingTable.class);
        if (blockEntity == null) {
            return null;
        }
        return new BlockEntityFramingTable.ContentProvider(blockEntity);
    }

    private void openUI(class_1937 level, class_2338 pos, class_1657 player) {
        if (!((Boolean)ModCommonConfig.INSTANCE.GENERAL.enableUI.get()).booleanValue() || !((Boolean)ModCommonConfig.INSTANCE.DRAWERS.framed.enable.get()).booleanValue()) {
            return;
        }
        class_3908 provider = level.method_8320(pos).method_26196(level, pos);
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("Open BlockDrawers UI " + String.valueOf(pos));
        }
        if (provider instanceof ContentMenuProvider) {
            ContentMenuProvider menu = (ContentMenuProvider)provider;
            menu.openMenu((class_3222)player);
        }
    }
}

