/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.capabilities.BasicDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.components.item.DetachedDrawerContents;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModSecurity;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers1;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers2;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers4;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawersComp3;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.storage.StorageUtil;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import com.texelsaurus.minecraft.chameleon.inventory.content.PositionContent;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityDrawers
extends BaseBlockEntity
implements IDrawerGroup,
IProtectable,
INetworked,
IFramedBlockEntity,
class_1275 {
    private MaterialData materialData = new MaterialData();
    private final UpgradeData upgradeData = new DrawerUpgradeData();
    private final ControllerData controllerData = new ControllerData();
    private UUID owner;
    private String securityKey;
    private class_2561 name;
    protected final IDrawerAttributesModifiable drawerAttributes = new DrawerAttributes();
    private long lastClickTime;
    private UUID lastClickUUID;
    private boolean loading;

    protected BlockEntityDrawers(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
        this.upgradeData.setDrawerAttributes(this.drawerAttributes);
        this.injectPortableData(this.upgradeData);
        this.injectPortableData(this.controllerData);
        this.injectData(this.materialData);
    }

    private void checkBoundController() {
        class_1792 class_17922;
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("BlockEntityDrawers [{}] checkBoundController", (Object)this.method_11016());
        }
        BlockEntityController controller = this.controllerData.getController(this);
        class_1799 remote = this.upgradeData.getRemoteUpgrade();
        if (remote == null && controller != null) {
            controller.invalidateRemoteNode(this);
            this.controllerData.bind(null);
            return;
        }
        if (remote != null && (class_17922 = remote.method_7909()) instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote itemRemote = (ItemUpgradeRemote)class_17922;
            BlockEntityController upgradeController = ItemUpgradeRemote.getBoundController(remote, (class_1936)this.field_11863);
            if (controller != null && controller != upgradeController) {
                controller.invalidateRemoteNode(this);
            }
            if (upgradeController != null) {
                this.controllerData.bind(upgradeController);
                if (!upgradeController.addRemoteNode(this)) {
                    this.controllerData.bind(null);
                }
            }
            if (itemRemote.isBound() && this.controllerData.getController(this) == null) {
                this.upgradeData.unbindRemoteUpgrade();
            }
        }
    }

    public void validateBoundController() {
        this.checkBoundController();
    }

    public void onEntityLoad() {
        try {
            if (this.method_10997() == null || this.method_10997().field_9236) {
                return;
            }
            class_2338 pos = this.method_11016();
            try {
                if (!this.method_10997().method_8397().method_8674(pos, (Object)this.method_11010().method_26204())) {
                    this.method_10997().method_39279(pos, this.method_11010().method_26204(), 1);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean supportsDirectControllerLink() {
        return true;
    }

    @Override
    public IControlGroup getBoundControlGroup() {
        return this.controllerData.getController(this);
    }

    @Override
    public boolean canRecurseSearch() {
        class_1799 upgrade = this.upgradeData.getRemoteUpgrade();
        if (upgrade == null) {
            return true;
        }
        class_1792 class_17922 = upgrade.method_7909();
        if (class_17922 instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item = (ItemUpgradeRemote)class_17922;
            return item.isGroupUpgrade();
        }
        return true;
    }

    @Override
    public void unbindControlGroup() {
        this.upgradeData.unbindRemoteUpgrade();
    }

    @NotNull
    public abstract IDrawerGroup getGroup();

    public static IDrawerGroup getGroup(BlockEntityDrawers be) {
        if (be == null) {
            return null;
        }
        return be.getGroup();
    }

    @NotNull
    public IDrawerAttributes getDrawerAttributes() {
        return this.drawerAttributes;
    }

    public static IDrawerAttributes getDrawerAttributes(BlockEntityDrawers be) {
        if (be == null) {
            return null;
        }
        return be.getDrawerAttributes();
    }

    public UpgradeData upgrades() {
        return this.upgradeData;
    }

    @Override
    public MaterialData material() {
        return this.materialData;
    }

    @Override
    public boolean isGroupValid() {
        return !this.method_11015();
    }

    public int getDrawerCapacity() {
        class_2248 block = this.method_11010().method_26204();
        if (!(block instanceof BlockDrawers)) {
            return 0;
        }
        return ((BlockDrawers)block).getStorageUnits();
    }

    public int getEffectiveDrawerCapacity() {
        if (this.upgradeData.hasOneStackUpgrade()) {
            return 1;
        }
        return this.getDrawerCapacity() * (Integer)ModCommonConfig.INSTANCE.DRAWERS.baseStackStorage.get();
    }

    protected boolean emptySlotCanBeCleared(int slot) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        return !drawer.isEmpty() && drawer.getStoredItemCount() == 0;
    }

    @Override
    public UUID getOwner() {
        if (!((Boolean)ModCommonConfig.INSTANCE.TOOLS.personalKey.enable.get()).booleanValue()) {
            return null;
        }
        return this.owner;
    }

    @Override
    public boolean setOwner(UUID owner) {
        if (!((Boolean)ModCommonConfig.INSTANCE.TOOLS.personalKey.enable.get()).booleanValue()) {
            return false;
        }
        if (this.owner != null && !this.owner.equals(owner) || owner != null && !owner.equals(this.owner)) {
            this.owner = owner;
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    @Override
    public ISecurityProvider getSecurityProvider() {
        return ModSecurity.registry.getProvider(this.securityKey);
    }

    @Override
    public boolean setSecurityProvider(ISecurityProvider provider) {
        String newKey;
        if (!((Boolean)ModCommonConfig.INSTANCE.TOOLS.personalKey.enable.get()).booleanValue()) {
            return false;
        }
        String string = newKey = provider == null ? null : provider.getProviderID();
        if (newKey != null && !newKey.equals(this.securityKey) || this.securityKey != null && !this.securityKey.equals(newKey)) {
            this.securityKey = newKey;
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    protected void onAttributeChanged() {
    }

    public boolean isRedstone() {
        return this.upgradeData.getRedstoneType() != null;
    }

    public int getRedstoneLevel() {
        EnumUpgradeRedstone type = this.upgradeData.getRedstoneType();
        if (type == null) {
            return 0;
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case EnumUpgradeRedstone.COMBINED -> this.getCombinedRedstoneLevel();
            case EnumUpgradeRedstone.MAX -> this.getMaxRedstoneLevel();
            case EnumUpgradeRedstone.MIN -> this.getMinRedstoneLevel();
        };
    }

    protected int getCombinedRedstoneLevel() {
        int active = 0;
        float fillRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            if (drawer.getMaxCapacity() > 0) {
                fillRatio += (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity();
            }
            ++active;
        }
        if (active == 0) {
            return 0;
        }
        if (fillRatio == (float)active) {
            return 15;
        }
        return (int)Math.ceil(fillRatio / (float)active * 14.0f);
    }

    protected int getMinRedstoneLevel() {
        float minRatio = 2.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            minRatio = drawer.getMaxCapacity() > 0 ? Math.min(minRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity()) : 0.0f;
        }
        if (minRatio > 1.0f) {
            return 0;
        }
        if (minRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(minRatio * 14.0f);
    }

    protected int getMaxRedstoneLevel() {
        float maxRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled() || drawer.getMaxCapacity() <= 0) continue;
            maxRatio = Math.max(maxRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity());
        }
        if (maxRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(maxRatio * 14.0f);
    }

    @NotNull
    public class_1799 takeItemsFromSlot(int slot, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled() || drawer.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1799 stack = drawer.getStoredItemPrototype().method_7972();
        stack.method_7939(Math.min(count, drawer.getStoredItemCount()));
        drawer.setStoredItemCount(drawer.getStoredItemCount() - stack.method_7947());
        if (this.upgradeData.hasbalancedFillUpgrade() && !this.upgradeData.hasVendingUpgrade()) {
            StorageUtil.rebalanceDrawers(this.getGroup(), slot);
        }
        if (this.isRedstone() && this.method_10997() != null) {
            this.method_10997().method_8452(this.method_11016(), this.method_11010().method_26204());
            this.method_10997().method_8452(this.method_11016().method_10074(), this.method_11010().method_26204());
        }
        return stack;
    }

    public int putItemsIntoSlot(int slot, @NotNull class_1799 stack, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        if (!drawer.canItemBeStoredManual(stack, null)) {
            return 0;
        }
        if (drawer.isEmpty()) {
            drawer = drawer.setStoredItem(stack);
        }
        int countAdded = Math.min(count, stack.method_7947());
        if (!this.drawerAttributes.isVoid()) {
            countAdded = Math.min(countAdded, drawer.getRemainingCapacity());
        }
        drawer.setStoredItemCount(drawer.getStoredItemCount() + countAdded);
        stack.method_7934(countAdded);
        if (this.upgradeData.hasbalancedFillUpgrade() && !this.upgradeData.hasVendingUpgrade()) {
            StorageUtil.rebalanceDrawers(this.getGroup(), slot);
        }
        return countAdded;
    }

    public int interactPutCurrentItemIntoSlot(int slot, class_1657 player) {
        IDrawer drawer = this.getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        class_1799 playerStack = player.method_31548().method_7391();
        if (!playerStack.method_7960()) {
            count = this.putItemsIntoSlot(slot, playerStack, playerStack.method_7947());
        }
        return count;
    }

    public int interactPutCurrentInventoryIntoSlot(int slot, class_1657 player) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        if (!drawer.isEmpty()) {
            int n = player.method_31548().method_5439();
            for (int i = 0; i < n; ++i) {
                class_1799 subStack = player.method_31548().method_5438(i);
                if (subStack.method_7960()) continue;
                int subCount = this.putItemsIntoSlot(slot, subStack, subStack.method_7947());
                if (subCount > 0 && subStack.method_7947() == 0) {
                    player.method_31548().method_5447(i, class_1799.field_8037);
                }
                count += subCount;
            }
        }
        return count;
    }

    public int interactPutItemsIntoSlot(int slot, class_1657 player) {
        if (this.method_10997() == null) {
            return 0;
        }
        int count = this.method_10997().method_8510() - this.lastClickTime < 10L && player.method_5667().equals(this.lastClickUUID) ? this.interactPutCurrentInventoryIntoSlot(slot, player) : this.interactPutCurrentItemIntoSlot(slot, player);
        this.lastClickTime = this.method_10997().method_8510();
        this.lastClickUUID = player.method_5667();
        return count;
    }

    public boolean interactReplaceDrawer(int slot, class_1799 detachedDrawer) {
        class_1799 proto;
        IDrawer drawer = this.getDrawer(slot);
        if (!drawer.isMissing()) {
            return false;
        }
        if (detachedDrawer.method_7960()) {
            return false;
        }
        DetachedDrawerContents contents = (DetachedDrawerContents)detachedDrawer.method_57825((class_9331)ModDataComponents.DETACHED_DRAWER_CONTENTS.get(), (Object)DetachedDrawerContents.EMPTY);
        int count = contents.getItemCount();
        if (count > drawer.getMaxCapacity(proto = contents.getItemPrototype())) {
            return false;
        }
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            int cap = this.getEffectiveDrawerCapacity() * this.upgradeData.getStorageMultiplier();
            if (contents.getStackLimit() < cap) {
                return false;
            }
        }
        drawer.setDetached(false);
        drawer.setStoredItem(proto, count);
        if (this.drawerAttributes.isBalancedFill()) {
            StorageUtil.rebalanceDrawers(this.getGroup(), slot);
        }
        return true;
    }

    @Override
    public void readPortable(class_7225.class_7874 provider, class_2487 tag) {
        this.loading = true;
        super.readPortable(provider, tag);
        if (tag.method_10545("Lock")) {
            EnumSet<LockAttribute> attrs = LockAttribute.getEnumSet(tag.method_10571("Lock"));
            if (attrs != null) {
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, attrs.contains((Object)LockAttribute.LOCK_EMPTY));
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, attrs.contains((Object)LockAttribute.LOCK_POPULATED));
            }
        } else {
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, false);
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, false);
        }
        if (tag.method_10545("Shr")) {
            this.drawerAttributes.setIsConcealed(tag.method_10577("Shr"));
        } else {
            this.drawerAttributes.setIsConcealed(false);
        }
        if (tag.method_10545("Qua")) {
            this.drawerAttributes.setIsShowingQuantity(tag.method_10577("Qua"));
        } else {
            this.drawerAttributes.setIsShowingQuantity(false);
        }
        this.owner = null;
        if (tag.method_10545("Own")) {
            this.owner = UUID.fromString(tag.method_10558("Own"));
        }
        this.securityKey = null;
        if (tag.method_10545("Sec")) {
            this.securityKey = tag.method_10558("Sec");
        }
        if (tag.method_10545("Pri")) {
            this.drawerAttributes.setPriority(tag.method_10550("Pri"));
        } else {
            this.drawerAttributes.setPriority(0);
        }
        if (tag.method_10573("CustomName", 8)) {
            this.name = BlockEntityDrawers.method_59894((String)tag.method_10558("CustomName"), (class_7225.class_7874)provider);
        }
        this.loading = false;
    }

    @Override
    public class_2487 writePortable(class_7225.class_7874 provider, class_2487 tag) {
        tag = super.writePortable(provider, tag);
        EnumSet<LockAttribute> attrs = EnumSet.noneOf(LockAttribute.class);
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_EMPTY)) {
            attrs.add(LockAttribute.LOCK_EMPTY);
        }
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attrs.add(LockAttribute.LOCK_POPULATED);
        }
        if (!attrs.isEmpty()) {
            tag.method_10567("Lock", (byte)LockAttribute.getBitfield(attrs));
        }
        if (this.drawerAttributes.isConcealed()) {
            tag.method_10556("Shr", true);
        }
        if (this.drawerAttributes.isShowingQuantity()) {
            tag.method_10556("Qua", true);
        }
        if (this.owner != null) {
            tag.method_10582("Own", this.owner.toString());
        }
        if (this.securityKey != null) {
            tag.method_10582("Sec", this.securityKey);
        }
        if (this.drawerAttributes.getPriority() != 0) {
            tag.method_10569("Pri", this.drawerAttributes.getPriority());
        }
        if (this.name != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.name, (class_7225.class_7874)provider));
        }
        return tag;
    }

    public void method_5431() {
        if (this.isRedstone() && this.method_10997() != null) {
            this.method_10997().method_8452(this.method_11016(), this.method_11010().method_26204());
            this.method_10997().method_8452(this.method_11016().method_10074(), this.method_11010().method_26204());
        }
        super.method_5431();
    }

    protected void syncClientCount(int slot, int count) {
        if (this.method_10997() != null && this.method_10997().field_9236) {
            return;
        }
        ChameleonServices.NETWORK.sendToPlayersNear(new CountUpdateMessage(this.method_11016(), slot, count), (class_3218)this.method_10997(), this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260(), 500.0);
    }

    public void clientUpdateCount(int slot, int count) {
        if (this.method_10997() == null || !this.method_10997().field_9236) {
            return;
        }
        class_310.method_1551().method_18858(() -> this.clientUpdateCountAsync(slot, count));
    }

    private void clientUpdateCountAsync(int slot, int count) {
        IDrawer drawer = this.getDrawer(slot);
        if (drawer.isEnabled() && drawer.getStoredItemCount() != count) {
            drawer.setStoredItemCount(count);
        }
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    @Deprecated
    public int getDrawerCount() {
        return this.getGroup().getDrawerCount();
    }

    @Override
    @Deprecated
    @NotNull
    public IDrawer getDrawer(int slot) {
        return this.getGroup().getDrawer(slot);
    }

    @Override
    @Deprecated
    public int[] getAccessibleDrawerSlots() {
        return this.getGroup().getAccessibleDrawerSlots();
    }

    public class_2561 method_5477() {
        if (this.name != null) {
            return this.name;
        }
        class_1799 stack = new class_1799((class_1935)this.method_11010().method_26204());
        return stack.method_7909().method_7864(stack);
    }

    public class_2561 method_5797() {
        return this.name;
    }

    protected void method_57568(class_2586.class_9473 input) {
        super.method_57568(input);
        this.name = (class_2561)input.method_58694(class_9334.field_49631);
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(class_9334.field_49631, (Object)this.name);
    }

    public void method_57569(class_2487 tag) {
        tag.method_10551("CustomName");
    }

    @Override
    public <T> T getCapability(ChameleonCapability<T> capability) {
        if (capability == null || this.field_11863 == null) {
            return null;
        }
        return capability.getCapability(this.field_11863, this.method_11016());
    }

    private class DrawerUpgradeData
    extends UpgradeData {
        DrawerUpgradeData() {
            super(7);
        }

        @Override
        public boolean canAddUpgrade(@NotNull class_1799 upgrade) {
            if (!super.canAddUpgrade(upgrade)) {
                return false;
            }
            if (upgrade.method_7909() == ModItems.ONE_STACK_UPGRADE.get()) {
                int currentUpgradeMult = BlockEntityDrawers.this.upgradeData.getStorageMultiplier();
                return this.stackCapacityCheck(currentUpgradeMult);
            }
            return true;
        }

        @Override
        public boolean canRemoveUpgrade(int slot) {
            if (!super.canRemoveUpgrade(slot)) {
                return false;
            }
            class_1799 upgrade = this.getUpgrade(slot);
            if (upgrade.method_7909() instanceof ItemUpgradeStorage) {
                int currentUpgradeMult = BlockEntityDrawers.this.upgradeData.getStorageMultiplier();
                int remLevel = ((ItemUpgradeStorage)upgrade.method_7909()).level.getLevel();
                int remMult = ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(remLevel);
                return this.stackCapacityCheck(BlockEntityDrawers.this.getDrawerCapacity() * (currentUpgradeMult - remMult));
            }
            return true;
        }

        @Override
        public boolean canSwapUpgrade(int slot, @NotNull class_1799 add) {
            if (!(add.method_7909() instanceof ItemUpgradeStorage)) {
                return false;
            }
            class_1799 upgrade = this.getUpgrade(slot);
            if (upgrade.method_7909() == ModItems.ONE_STACK_UPGRADE.get()) {
                return true;
            }
            if (!(upgrade.method_7909() instanceof ItemUpgradeStorage)) {
                return false;
            }
            if (!this.canAddUpgrade(add)) {
                return false;
            }
            if (((ItemUpgradeStorage)add.method_7909()).level.getLevel() > ((ItemUpgradeStorage)upgrade.method_7909()).level.getLevel()) {
                return true;
            }
            int currentUpgradeMult = BlockEntityDrawers.this.upgradeData.getStorageMultiplier();
            int remLevel = ((ItemUpgradeStorage)upgrade.method_7909()).level.getLevel();
            int remMult = ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(remLevel);
            int addLevel = ((ItemUpgradeStorage)add.method_7909()).level.getLevel();
            int addMult = ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(addLevel);
            return this.stackCapacityCheck(BlockEntityDrawers.this.getDrawerCapacity() * (currentUpgradeMult - remMult + addMult));
        }

        @Override
        protected void onUpgradeChanged(class_1799 oldUpgrade, class_1799 newUpgrade) {
            if (BlockEntityDrawers.this.method_10997() != null && !BlockEntityDrawers.this.method_10997().field_9236) {
                BlockEntityDrawers.this.checkBoundController();
                if (BlockEntityDrawers.this.getBoundControlGroup() != null) {
                    BlockEntityDrawers.this.getBoundControlGroup().addRemoteNode(BlockEntityDrawers.this);
                }
                BlockEntityDrawers.this.method_5431();
                BlockEntityDrawers.this.markBlockForUpdate();
            }
        }

        private boolean stackCapacityCheck(int stackCapacity) {
            for (int i = 0; i < BlockEntityDrawers.this.getDrawerCount(); ++i) {
                int newMaxCapacity;
                int currentCount;
                IDrawer drawer = BlockEntityDrawers.this.getDrawer(i);
                if (!drawer.isEnabled() || drawer.isEmpty() || (currentCount = drawer.getStoredItemCount()) <= (newMaxCapacity = stackCapacity * drawer.getStoredItemStackSize())) continue;
                return false;
            }
            return true;
        }
    }

    private class DrawerAttributes
    extends BasicDrawerAttributes {
        private DrawerAttributes() {
        }

        @Override
        protected void onAttributeChanged() {
            if (!BlockEntityDrawers.this.loading && !BlockEntityDrawers.this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                for (int slot = 0; slot < BlockEntityDrawers.this.getGroup().getDrawerCount(); ++slot) {
                    if (!BlockEntityDrawers.this.emptySlotCanBeCleared(slot)) continue;
                    IDrawer drawer = BlockEntityDrawers.this.getGroup().getDrawer(slot);
                    drawer.setStoredItem(class_1799.field_8037);
                }
            }
            BlockEntityDrawers.this.onAttributeChanged();
            if (BlockEntityDrawers.this.method_10997() != null && !BlockEntityDrawers.this.method_10997().field_9236) {
                BlockEntityDrawers.this.method_5431();
                BlockEntityDrawers.this.markBlockForUpdate();
            }
        }
    }

    public static class ContentProvider
    implements ContentMenuProvider<PositionContent> {
        private BlockEntityDrawers entity;

        public ContentProvider(BlockEntityDrawers entity) {
            this.entity = entity;
        }

        @Override
        public PositionContent createContent(class_3222 player) {
            return new PositionContent(this.entity.method_11016());
        }

        public class_2561 method_5476() {
            return this.entity.method_5476();
        }

        @Nullable
        public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
            return switch (this.entity.getGroup().getDrawerCount()) {
                case 1 -> new ContainerDrawers1(id, inventory, this.entity);
                case 2 -> new ContainerDrawers2(id, inventory, this.entity);
                case 4 -> new ContainerDrawers4(id, inventory, this.entity);
                case 3 -> new ContainerDrawersComp3(id, inventory, this.entity);
                default -> null;
            };
        }
    }
}

