/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedMaterials;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;

public class MaterialData
extends BlockEntityDataShim
implements IFramedMaterials {
    public static final MaterialData EMPTY = new MaterialData();
    public static final Codec<MaterialData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("frameBase").forGetter(MaterialData::getFrameBase), (App)class_1799.field_24671.fieldOf("materialSide").forGetter(MaterialData::getSide), (App)class_1799.field_24671.fieldOf("materialFront").forGetter(MaterialData::getFront), (App)class_1799.field_24671.fieldOf("materialTrim").forGetter(MaterialData::getTrim)).apply((Applicative)instance, MaterialData::new));
    public static final class_9139<class_9129, MaterialData> STREAM_CODEC = class_9139.method_56905((class_9139)class_1799.field_49268, MaterialData::getFrameBase, (class_9139)class_1799.field_49268, MaterialData::getSide, (class_9139)class_1799.field_49268, MaterialData::getFront, (class_9139)class_1799.field_49268, MaterialData::getTrim, MaterialData::new);
    @NotNull
    private class_1799 frameBase;
    @NotNull
    private class_1799 materialSide;
    @NotNull
    private class_1799 materialFront;
    @NotNull
    private class_1799 materialTrim;

    public MaterialData() {
        this(class_1799.field_8037, class_1799.field_8037, class_1799.field_8037, class_1799.field_8037);
    }

    public MaterialData(@NotNull class_1799 frameBase, @NotNull class_1799 side, @NotNull class_1799 front, @NotNull class_1799 trim) {
        this.frameBase = frameBase;
        this.materialSide = side;
        this.materialFront = front;
        this.materialTrim = trim;
    }

    public MaterialData(IFramedMaterials materials) {
        this();
        if (materials != null) {
            this.frameBase = materials.getHostBlock();
            this.materialSide = materials.getMaterial(FrameMaterial.SIDE);
            this.materialFront = materials.getMaterial(FrameMaterial.FRONT);
            this.materialTrim = materials.getMaterial(FrameMaterial.TRIM);
        }
    }

    @NotNull
    public class_1799 getFrameBase() {
        return this.frameBase;
    }

    @NotNull
    public class_1799 getSide() {
        return this.materialSide;
    }

    @NotNull
    public class_1799 getFront() {
        return this.materialFront;
    }

    @NotNull
    public class_1799 getTrim() {
        return this.materialTrim;
    }

    @NotNull
    public class_1799 getEffectiveSide() {
        return this.materialSide;
    }

    public boolean isMatOpaque(class_1799 mat) {
        class_1792 class_17922 = mat.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return blockItem.method_7711().method_9564().method_26225();
        }
        return false;
    }

    public boolean allMatOpaque() {
        return !(!this.isMatOpaque(this.materialSide) || !this.materialFront.method_7960() && !this.isMatOpaque(this.materialFront) || !this.materialTrim.method_7960() && !this.isMatOpaque(this.materialTrim));
    }

    @NotNull
    public class_1799 getEffectiveFront() {
        return !this.materialFront.method_7960() ? this.materialFront : this.materialSide;
    }

    @NotNull
    public class_1799 getEffectiveTrim() {
        return !this.materialTrim.method_7960() ? this.materialTrim : this.materialSide;
    }

    public void setFrameBase(@NotNull class_1799 frameBase) {
        this.frameBase = frameBase;
    }

    public void setSide(@NotNull class_1799 material) {
        this.materialSide = material;
    }

    public void setFront(@NotNull class_1799 material) {
        this.materialFront = material;
    }

    public void setTrim(@NotNull class_1799 material) {
        this.materialTrim = material;
    }

    public void clear() {
        this.materialSide = class_1799.field_8037;
        this.materialFront = class_1799.field_8037;
        this.materialTrim = class_1799.field_8037;
    }

    public boolean isEmpty() {
        return this.materialFront.method_7960() && this.materialSide.method_7960() && this.materialTrim.method_7960();
    }

    public void read(class_1799 stack) {
        FrameData data = (FrameData)stack.method_57825((class_9331)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY);
        this.frameBase = data.base();
        this.materialSide = data.side();
        this.materialFront = data.front();
        this.materialTrim = data.trim();
    }

    @Override
    public void read(class_7225.class_7874 provider, class_2487 tag) {
        this.frameBase = class_1799.field_8037;
        if (tag.method_10545("MatB")) {
            this.frameBase = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)tag.method_10562("MatB"));
        }
        this.materialSide = class_1799.field_8037;
        if (tag.method_10545("MatS")) {
            this.materialSide = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)tag.method_10562("MatS"));
        }
        this.materialFront = class_1799.field_8037;
        if (tag.method_10545("MatF")) {
            this.materialFront = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)tag.method_10562("MatF"));
        }
        this.materialTrim = class_1799.field_8037;
        if (tag.method_10545("MatT")) {
            this.materialTrim = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)tag.method_10562("MatT"));
        }
    }

    @Override
    public class_2487 write(class_7225.class_7874 provider, class_2487 tag) {
        if (!this.frameBase.method_7960()) {
            tag.method_10566("MatB", this.frameBase.method_57375(provider));
        } else if (tag.method_10545("MatB")) {
            tag.method_10551("MatB");
        }
        if (!this.materialSide.method_7960()) {
            tag.method_10566("MatS", this.materialSide.method_57375(provider));
        } else if (tag.method_10545("MatS")) {
            tag.method_10551("MatS");
        }
        if (!this.materialFront.method_7960()) {
            tag.method_10566("MatF", this.materialFront.method_57375(provider));
        } else if (tag.method_10545("MatF")) {
            tag.method_10551("MatF");
        }
        if (!this.materialTrim.method_7960()) {
            tag.method_10566("MatT", this.materialTrim.method_57375(provider));
        } else if (tag.method_10545("MatT")) {
            tag.method_10551("MatT");
        }
        return tag;
    }

    @Override
    @NotNull
    public class_1799 getHostBlock() {
        return this.frameBase;
    }

    @Override
    public void setHostBlock(@NotNull class_1799 stack) {
        this.frameBase = stack;
    }

    @Override
    @NotNull
    public class_1799 getMaterial(FrameMaterial material) {
        return switch (material) {
            default -> throw new MatchException(null, null);
            case FrameMaterial.SIDE -> this.materialSide;
            case FrameMaterial.TRIM -> this.materialTrim;
            case FrameMaterial.FRONT -> this.materialFront;
        };
    }

    @Override
    public void setMaterial(FrameMaterial material, @NotNull class_1799 stack) {
        switch (material) {
            case SIDE: {
                this.materialSide = stack;
                break;
            }
            case TRIM: {
                this.materialTrim = stack;
                break;
            }
            case FRONT: {
                this.materialFront = stack;
            }
        }
    }
}

