/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.DrawerModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.FramedModelProperties;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelGeometry;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.PlatformDecoratedModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.DrawerModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.context.FramedModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.CombinedModelDecorator;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.DrawerModelDecorator;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.MaterialModelDecorator;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1087;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class ModelLoadPlugin
implements ModelLoadingPlugin {
    public void onInitializeModelLoader(ModelLoadingPlugin.Context pluginContext) {
        DrawerModelGeometry.loadGeometryData();
        pluginContext.modifyModelAfterBake().register((original, context) -> {
            if (context.topLevelId() == null) {
                return original;
            }
            class_2960 blockId = context.topLevelId().comp_2875();
            if (!blockId.method_12836().equals("storagedrawers")) {
                return original;
            }
            DrawerModelStore.tryAddModel(context.topLevelId(), original);
            if (!DrawerModelStore.INSTANCE.isTargetedModel(context.topLevelId())) {
                return original;
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_FULL_DRAWERS_1.getId())) {
                return ModelLoadPlugin.makeFramedStandardDrawerModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_FULL_DRAWERS_2.getId())) {
                return ModelLoadPlugin.makeFramedStandardDrawerModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_FULL_DRAWERS_4.getId())) {
                return ModelLoadPlugin.makeFramedStandardDrawerModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_HALF_DRAWERS_1.getId())) {
                return ModelLoadPlugin.makeFramedStandardDrawerModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_HALF_DRAWERS_2.getId())) {
                return ModelLoadPlugin.makeFramedStandardDrawerModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_HALF_DRAWERS_4.getId())) {
                return ModelLoadPlugin.makeFramedStandardDrawerModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_COMPACTING_DRAWERS_2.getId())) {
                return ModelLoadPlugin.makeFramedComp2DrawerModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_COMPACTING_HALF_DRAWERS_2.getId())) {
                return ModelLoadPlugin.makeFramedComp2DrawerModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_COMPACTING_DRAWERS_3.getId())) {
                return ModelLoadPlugin.makeFramedComp3DrawerModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_COMPACTING_HALF_DRAWERS_3.getId())) {
                return ModelLoadPlugin.makeFramedComp3DrawerModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_TRIM.getId())) {
                return ModelLoadPlugin.makeFramedTrimModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_CONTROLLER.getId())) {
                return ModelLoadPlugin.makeFramedControllerModel(original);
            }
            if (blockId.equals((Object)ModBlocks.FRAMED_CONTROLLER_IO.getId())) {
                return ModelLoadPlugin.makeFramedControllerIOModel(original);
            }
            return ModelLoadPlugin.makeStandardDrawerModel(original);
        });
    }

    static class_1087 makeStandardDrawerModel(class_1087 parentModel) {
        DrawerModelDecorator decorator = new DrawerModelDecorator(DrawerModelStore.INSTANCE);
        return new PlatformDecoratedModel<DrawerModelContext>(parentModel, decorator, DrawerModelProperties.INSTANCE);
    }

    static class_1087 makeFramedDrawerModel(class_1087 parentModel, DrawerModelStore.FrameMatSet matSet) {
        CombinedModelDecorator<DrawerModelContext> decorator = new CombinedModelDecorator<DrawerModelContext>();
        decorator.add(new DrawerModelDecorator(DrawerModelStore.INSTANCE));
        decorator.add(new MaterialModelDecorator.FacingSizedSlotted(matSet, true));
        return new PlatformDecoratedModel<DrawerModelContext>(parentModel, decorator, DrawerModelProperties.INSTANCE);
    }

    static class_1087 makeFramedStandardDrawerModel(class_1087 parentModel) {
        return ModelLoadPlugin.makeFramedDrawerModel(parentModel, DrawerModelStore.FramedStandardDrawerMaterials);
    }

    static class_1087 makeFramedCompDrawerModel(class_1087 parentModel, DrawerModelStore.FrameMatSet matSet) {
        CombinedModelDecorator<DrawerModelContext> decorator = new CombinedModelDecorator<DrawerModelContext>();
        decorator.add(new DrawerModelDecorator(DrawerModelStore.INSTANCE));
        decorator.add(new MaterialModelDecorator.FacingSizedOpen(matSet, true));
        return new PlatformDecoratedModel<DrawerModelContext>(parentModel, decorator, DrawerModelProperties.INSTANCE);
    }

    static class_1087 makeFramedComp2DrawerModel(class_1087 parentModel) {
        return ModelLoadPlugin.makeFramedCompDrawerModel(parentModel, DrawerModelStore.FramedComp2DrawerMaterials);
    }

    static class_1087 makeFramedComp3DrawerModel(class_1087 parentModel) {
        return ModelLoadPlugin.makeFramedCompDrawerModel(parentModel, DrawerModelStore.FramedComp3DrawerMaterials);
    }

    static class_1087 makeFramedTrimModel(class_1087 parentModel) {
        MaterialModelDecorator.Single decorator = new MaterialModelDecorator.Single(DrawerModelStore.FramedTrimMaterials, true);
        return new PlatformDecoratedModel<FramedModelContext>(parentModel, decorator, FramedModelProperties.INSTANCE);
    }

    static class_1087 makeFramedControllerModel(class_1087 parentModel) {
        MaterialModelDecorator.Facing decorator = new MaterialModelDecorator.Facing(DrawerModelStore.FramedControllerMaterials, true);
        return new PlatformDecoratedModel<FramedModelContext>(parentModel, decorator, FramedModelProperties.INSTANCE);
    }

    static class_1087 makeFramedControllerIOModel(class_1087 parentModel) {
        MaterialModelDecorator.Single decorator = new MaterialModelDecorator.Single(DrawerModelStore.FramedControllerIOMaterials, true);
        return new PlatformDecoratedModel<FramedModelContext>(parentModel, decorator, FramedModelProperties.INSTANCE);
    }
}

