/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityControllerIO;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityTrim;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.api.ChameleonInit;
import com.texelsaurus.minecraft.chameleon.registry.ChameleonRegistry;
import com.texelsaurus.minecraft.chameleon.registry.RegistryEntry;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_7923;

public final class ModBlockEntities {
    public static final ChameleonRegistry<class_2591<?>> BLOCK_ENTITIES = ChameleonServices.REGISTRY.create(class_7923.field_41181, "storagedrawers");
    public static final Set<RegistryEntry<? extends class_2591<? extends BlockEntityDrawers>>> DRAWER_TYPES = new HashSet<RegistryEntry<? extends class_2591<? extends BlockEntityDrawers>>>();
    public static final Set<RegistryEntry<? extends class_2591<? extends BlockEntityDrawers>>> FRAMING_TABLE_TYPES = new HashSet<RegistryEntry<? extends class_2591<? extends BlockEntityDrawers>>>();
    public static final RegistryEntry<class_2591<BlockEntityDrawersStandard>> STANDARD_DRAWERS_1 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_1", ModServices.RESOURCE_FACTORY.createBlockEntityDrawersStandard(1), BlockStandardDrawers.class, 1);
    public static final RegistryEntry<class_2591<BlockEntityDrawersStandard>> STANDARD_DRAWERS_2 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_2", ModServices.RESOURCE_FACTORY.createBlockEntityDrawersStandard(2), BlockStandardDrawers.class, 2);
    public static final RegistryEntry<class_2591<BlockEntityDrawersStandard>> STANDARD_DRAWERS_4 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_4", ModServices.RESOURCE_FACTORY.createBlockEntityDrawersStandard(4), BlockStandardDrawers.class, 4);
    public static final RegistryEntry<class_2591<BlockEntityDrawersComp>> FRACTIONAL_DRAWERS_2 = ModBlockEntities.registerDrawerBlockEntityType("fractional_drawers_2", ModServices.RESOURCE_FACTORY.createBlockEntityDrawersComp(2), BlockCompDrawers.class, 2);
    public static final RegistryEntry<class_2591<BlockEntityDrawersComp>> FRACTIONAL_DRAWERS_3 = ModBlockEntities.registerDrawerBlockEntityType("fractional_drawers_3", ModServices.RESOURCE_FACTORY.createBlockEntityDrawersComp(3), BlockCompDrawers.class, 3);
    public static final RegistryEntry<class_2591<BlockEntityController>> CONTROLLER = ModBlockEntities.registerControllerBlockEntityType("controller", ModServices.RESOURCE_FACTORY.createBlockEntityController());
    public static final RegistryEntry<class_2591<BlockEntityControllerIO>> CONTROLLER_IO = ModBlockEntities.registerControllerIOBlockEntityType("controller_io", ModServices.RESOURCE_FACTORY.createBlockEntityControllerIO());
    public static final RegistryEntry<class_2591<BlockEntityTrim>> TRIM = BLOCK_ENTITIES.register("trim", () -> class_2591.class_2592.method_20528(ModServices.RESOURCE_FACTORY.createBlockEntityTrim(), (class_2248[])new class_2248[]{(class_2248)ModBlocks.FRAMED_TRIM.get()}).method_11034(null));
    public static final RegistryEntry<class_2591<BlockEntityFramingTable>> FRAMING_TABLE = BLOCK_ENTITIES.register("framing_table", () -> class_2591.class_2592.method_20528(ModServices.RESOURCE_FACTORY.createBlockEntityFramingTable(), (class_2248[])new class_2248[]{(class_2248)ModBlocks.FRAMING_TABLE.get()}).method_11034(null));

    private ModBlockEntities() {
    }

    private static <BE extends BlockEntityDrawers, B extends BlockDrawers> RegistryEntry<class_2591<BE>> registerDrawerBlockEntityType(String name, class_2591.class_5559<BE> blockEntitySupplier, Class<B> drawerBlockClass, int size) {
        RegistryEntry<class_2591<BE>> ro = ModBlockEntities.registerBlockEntityType(name, blockEntitySupplier, drawerBlockClass, size);
        DRAWER_TYPES.add(ro);
        return ro;
    }

    private static <BE extends BaseBlockEntity, B extends BlockDrawers> RegistryEntry<class_2591<BE>> registerBlockEntityType(String name, class_2591.class_5559<BE> blockEntitySupplier, Class<B> drawerBlockClass, int size) {
        return BLOCK_ENTITIES.register(name, () -> class_2591.class_2592.method_20528((class_2591.class_5559)blockEntitySupplier, (class_2248[])((class_2248[])ModBlocks.getDrawersOfTypeAndSize(drawerBlockClass, size).toArray(class_2248[]::new))).method_11034(null));
    }

    private static <BE extends BaseBlockEntity, B extends BlockDrawers> RegistryEntry<class_2591<BE>> registerControllerBlockEntityType(String name, class_2591.class_5559<BE> blockEntitySupplier) {
        return BLOCK_ENTITIES.register(name, () -> class_2591.class_2592.method_20528((class_2591.class_5559)blockEntitySupplier, (class_2248[])((class_2248[])ModBlocks.getControllers().toArray(class_2248[]::new))).method_11034(null));
    }

    private static <BE extends BaseBlockEntity, B extends BlockDrawers> RegistryEntry<class_2591<BE>> registerControllerIOBlockEntityType(String name, class_2591.class_5559<BE> blockEntitySupplier) {
        return BLOCK_ENTITIES.register(name, () -> class_2591.class_2592.method_20528((class_2591.class_5559)blockEntitySupplier, (class_2248[])((class_2248[])ModBlocks.getControllerIOs().toArray(class_2248[]::new))).method_11034(null));
    }

    public static void init(ChameleonInit.InitContext context) {
        BLOCK_ENTITIES.init(context);
    }

    public static Stream<class_2591<? extends BlockEntityDrawers>> getDrawerTypes() {
        return DRAWER_TYPES.stream().map(Supplier::get);
    }
}

