/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddUpgradeRecipe
extends class_1852 {
    public AddUpgradeRecipe(class_7710 cat) {
        super(cat);
    }

    public boolean matches(@NotNull class_9694 inv, @NotNull class_1937 world) {
        return this.findContext(inv, (class_7225.class_7874)world.method_30349()) != null;
    }

    @NotNull
    public class_1799 assemble(@NotNull class_9694 inv, class_7225.class_7874 registries) {
        Context ctx = this.findContext(inv, registries);
        if (ctx == null) {
            return class_1799.field_8037;
        }
        class_1799 ret = ctx.drawer.method_7972();
        class_9279 blockData = (class_9279)ret.method_57824(class_9334.field_49611);
        if (blockData != null) {
            class_9279 data = class_9279.method_57456((class_2487)ctx.data.write(registries, blockData.method_57461()));
            ret.method_57379(class_9334.field_49611, (Object)data);
            return ret;
        }
        class_9279 upgradeData = (class_9279)ret.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        class_9279 data = class_9279.method_57456((class_2487)ctx.data.write(registries, upgradeData.method_57461()));
        ret.method_57379(class_9334.field_49628, (Object)data);
        return ret;
    }

    @Nullable
    private Context findContext(class_9694 inv, class_7225.class_7874 registries) {
        Context ret = new Context();
        for (int x = 0; x < inv.method_59983(); ++x) {
            class_1799 stack = inv.method_59984(x);
            if (stack.method_7960()) continue;
            if (stack.method_7909() instanceof ItemDrawers) {
                if (!ret.drawer.method_7960()) {
                    return null;
                }
                ret.drawer = stack;
                continue;
            }
            if (stack.method_7909() instanceof ItemUpgrade) {
                ret.upgrades.add(stack);
                continue;
            }
            return null;
        }
        if (ret.drawer.method_7960() || ret.upgrades.isEmpty()) {
            return null;
        }
        ret.data = new UpgradeData(this, 7){

            @Override
            public boolean setUpgrade(int slot, @NotNull class_1799 upgrade) {
                if (upgrade.method_7960()) {
                    return false;
                }
                upgrade = upgrade.method_7972();
                upgrade.method_7939(1);
                this.upgrades[slot] = upgrade;
                return true;
            }
        };
        class_9279 blocKEntityData = (class_9279)ret.drawer.method_57824(class_9334.field_49611);
        if (blocKEntityData != null) {
            ret.data.read(registries, blocKEntityData.method_57461());
        } else {
            class_9279 customData = (class_9279)ret.drawer.method_57824(class_9334.field_49628);
            if (customData != null) {
                ret.data.read(registries, customData.method_57461());
            }
        }
        for (class_1799 upgrade : ret.upgrades) {
            if (upgrade.method_7909() == ModItems.ONE_STACK_UPGRADE.get()) {
                return null;
            }
            if (!ret.data.hasEmptySlot() || !ret.data.canAddUpgrade(upgrade)) {
                return null;
            }
            ret.data.addUpgrade(upgrade);
        }
        return ret;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)ModRecipes.UPGRADE_RECIPE_SERIALIZER.get();
    }

    private static class Context {
        class_1799 drawer = class_1799.field_8037;
        List<class_1799> upgrades = new ArrayList<class_1799>();
        UpgradeData data = null;

        private Context() {
        }
    }
}

