/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

public class InventoryUpgrade
implements class_1263 {
    private static final int upgradeCapacity = 7;
    private final BlockEntityDrawers blockEntityDrawers;

    public InventoryUpgrade(BlockEntityDrawers blockEntityDrawers) {
        this.blockEntityDrawers = blockEntityDrawers;
    }

    public int method_5439() {
        return 7;
    }

    public boolean method_5442() {
        if (this.blockEntityDrawers == null) {
            return true;
        }
        for (int i = 0; i < 7; ++i) {
            if (this.blockEntityDrawers.upgrades().getUpgrade(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        if (this.blockEntityDrawers == null) {
            return class_1799.field_8037;
        }
        return this.blockEntityDrawers.upgrades().getUpgrade(slot);
    }

    @NotNull
    public class_1799 method_5434(int slot, int count) {
        if (this.blockEntityDrawers == null) {
            return class_1799.field_8037;
        }
        class_1799 stack = this.blockEntityDrawers.upgrades().getUpgrade(slot);
        if (count > 0) {
            this.blockEntityDrawers.upgrades().setUpgrade(slot, class_1799.field_8037);
        }
        return stack;
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        return class_1799.field_8037;
    }

    public void method_5447(int slot, @NotNull class_1799 item) {
        if (this.blockEntityDrawers == null) {
            return;
        }
        this.blockEntityDrawers.upgrades().setUpgrade(slot, item);
    }

    public int method_5444() {
        return 1;
    }

    public void method_5431() {
        if (this.blockEntityDrawers == null) {
            return;
        }
        this.blockEntityDrawers.method_5431();
    }

    public boolean method_5443(@NotNull class_1657 player) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        class_2338 pos = this.blockEntityDrawers.method_11016();
        if (this.blockEntityDrawers.method_10997() == null || this.blockEntityDrawers.method_10997().method_8321(pos) != this.blockEntityDrawers) {
            return false;
        }
        return !(player.method_5707(class_243.method_24953((class_2382)pos)) > 64.0);
    }

    public void method_5435(@NotNull class_1657 player) {
    }

    public void method_5432(@NotNull class_1657 player) {
    }

    public boolean method_5437(int slot, @NotNull class_1799 item) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return false;
        }
        return this.blockEntityDrawers.upgrades().canAddUpgrade(item);
    }

    public void method_5448() {
    }

    public int getStorageMultiplier() {
        if (this.blockEntityDrawers == null) {
            return 1;
        }
        return this.blockEntityDrawers.upgrades().getStorageMultiplier();
    }

    public int getStackCapacity() {
        if (this.blockEntityDrawers == null) {
            return 1;
        }
        try {
            return Math.multiplyExact(this.blockEntityDrawers.getEffectiveDrawerCapacity(), this.blockEntityDrawers.upgrades().getStorageMultiplier());
        }
        catch (ArithmeticException e) {
            return 0x1FFFFFF;
        }
    }

    public boolean slotIsLocked(int slot) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return true;
        }
        if (!this.method_5438(slot).method_7960()) {
            return !this.canRemoveUpgrade(slot);
        }
        return false;
    }

    public boolean canAddUpgrade(@NotNull class_1799 item) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return false;
        }
        return this.blockEntityDrawers.upgrades().canAddUpgrade(item);
    }

    public boolean canRemoveUpgrade(int slot) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return false;
        }
        return this.blockEntityDrawers.upgrades().canRemoveUpgrade(slot);
    }

    public boolean canRemoveStorageUpgrade(int slot) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return false;
        }
        return this.blockEntityDrawers.upgrades().canRemoveUpgrade(slot);
    }

    public boolean canSwapUpgrade(int slot, @NotNull class_1799 item) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return false;
        }
        return this.blockEntityDrawers.upgrades().canSwapUpgrade(slot, item);
    }
}

