/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.phys.AABB;
import org.apache.commons.io.IOUtils;
import org.joml.Vector3f;

public class DrawerModelGeometry {
    private static boolean geometryDataLoaded = false;

    public static void loadGeometryData() {
        if (geometryDataLoaded) {
            return;
        }
        geometryDataLoaded = true;
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_comp_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_comp_drawers_icon_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_count_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_ind_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_indbase_area_3.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_comp_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_comp_drawers_icon_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_count_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_ind_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_indbase_area_3.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, true).toArray(BlockDrawers[]::new));
    }

    private static void populateGeometryData(ResourceLocation locationIcon, ResourceLocation locationCount, ResourceLocation locationInd, ResourceLocation locationIndBase, BlockDrawers ... blocks) {
        BlockModel slotInfo = DrawerModelGeometry.getBlockModel(locationIcon);
        BlockModel countInfo = DrawerModelGeometry.getBlockModel(locationCount);
        BlockModel indInfo = DrawerModelGeometry.getBlockModel(locationInd);
        BlockModel indBaseInfo = DrawerModelGeometry.getBlockModel(locationIndBase);
        for (BlockDrawers block : blocks) {
            Vector3f to;
            Vector3f from;
            int i;
            if (block == null) continue;
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((BlockElement)slotInfo.getElements().get((int)i)).from;
                to = ((BlockElement)slotInfo.getElements().get((int)i)).to;
                block.labelGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((BlockElement)countInfo.getElements().get((int)i)).from;
                to = ((BlockElement)countInfo.getElements().get((int)i)).to;
                block.countGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((BlockElement)indInfo.getElements().get((int)i)).from;
                to = ((BlockElement)indInfo.getElements().get((int)i)).to;
                block.indGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((BlockElement)indBaseInfo.getElements().get((int)i)).from;
                to = ((BlockElement)indBaseInfo.getElements().get((int)i)).to;
                block.indBaseGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlockModel getBlockModel(ResourceLocation location) {
        Resource iresource = null;
        InputStreamReader reader = null;
        try {
            iresource = Minecraft.getInstance().getResourceManager().getResourceOrThrow(location);
            reader = new InputStreamReader(iresource.open(), StandardCharsets.UTF_8);
            BlockModel blockModel = BlockModel.fromStream((Reader)reader);
            IOUtils.closeQuietly((Reader)reader);
            return blockModel;
        }
        catch (IOException e) {
            BlockModel blockModel = null;
            return blockModel;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }
}

