/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BaseBlockEntity
extends BlockEntity {
    private CompoundTag failureSnapshot;
    private List<BlockEntityDataShim> fixedShims;
    private List<BlockEntityDataShim> portableShims;

    public BaseBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public boolean hasDataPacket() {
        return true;
    }

    public boolean dataPacketRequiresRenderUpdate() {
        return false;
    }

    public void injectData(BlockEntityDataShim shim) {
        if (this.fixedShims == null) {
            this.fixedShims = new ArrayList<BlockEntityDataShim>();
        }
        this.fixedShims.add(shim);
    }

    public void injectPortableData(BlockEntityDataShim shim) {
        if (this.portableShims == null) {
            this.portableShims = new ArrayList<BlockEntityDataShim>();
        }
        this.portableShims.add(shim);
    }

    public final void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.readFixed(tag);
        this.readPortable(tag);
        this.onLoadFinished();
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.dataPacketRequiresRenderUpdate()) {
            this.markBlockForRenderUpdate();
        }
    }

    protected void onLoadFinished() {
    }

    public final void read(CompoundTag tag) {
        this.m_142466_(tag);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag = this.writeFixed(tag);
        this.writePortable(tag);
    }

    public void readPortable(CompoundTag tag) {
        if (this.portableShims != null) {
            for (BlockEntityDataShim shim : this.portableShims) {
                shim.read(tag);
            }
        }
    }

    public CompoundTag writePortable(CompoundTag tag) {
        if (this.portableShims != null) {
            for (BlockEntityDataShim shim : this.portableShims) {
                tag = shim.write(tag);
            }
        }
        return tag;
    }

    protected void readFixed(CompoundTag tag) {
        if (this.fixedShims != null) {
            for (BlockEntityDataShim shim : this.fixedShims) {
                shim.read(tag);
            }
        }
    }

    protected CompoundTag writeFixed(CompoundTag tag) {
        if (this.fixedShims != null) {
            for (BlockEntityDataShim shim : this.fixedShims) {
                tag = shim.write(tag);
            }
        }
        return tag;
    }

    private void trapLoadFailure(Throwable t, CompoundTag tag) {
        this.failureSnapshot = tag.m_6426_();
        ModServices.log.error("Tile Load Failure.", t);
    }

    private void restoreLoadFailure(CompoundTag tag) {
        for (String key : this.failureSnapshot.m_128431_()) {
            if (tag.m_128441_(key)) continue;
            tag.m_128365_(key, this.failureSnapshot.m_128423_(key).m_6426_());
        }
    }

    protected boolean loadDidFail() {
        return this.failureSnapshot != null;
    }

    @NotNull
    public final CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return this.hasDataPacket() ? ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this) : null;
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt != null && pkt.m_131708_() != null) {
            this.read(pkt.m_131708_());
        }
        if (this.m_58904_() != null && this.m_58904_().f_46443_ && this.dataPacketRequiresRenderUpdate()) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    public void markBlockForUpdate() {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            BlockState state = this.m_58904_().m_8055_(this.f_58858_);
            this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void markBlockForUpdateClient() {
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            BlockState state = this.m_58904_().m_8055_(this.f_58858_);
            this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void markBlockForRenderUpdate() {
        if (this.m_58904_() == null) {
            return;
        }
        BlockState state = this.m_58904_().m_8055_(this.f_58858_);
        this.m_58904_().m_7260_(this.f_58858_, state, state, 2);
    }
}

