/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.CustomNameData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.capabilities.BasicDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModSecurity;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers1;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers2;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers4;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawersComp3;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.storage.StorageUtil;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import com.texelsaurus.minecraft.chameleon.inventory.content.PositionContent;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityDrawers
extends BaseBlockEntity
implements IDrawerGroup,
IProtectable,
INetworked,
IFramedBlockEntity {
    private final CustomNameData customNameData = new CustomNameData();
    private final MaterialData materialData = new MaterialData();
    private final UpgradeData upgradeData = new DrawerUpgradeData();
    private final ControllerData controllerData = new ControllerData();
    private UUID owner;
    private String securityKey;
    private final IDrawerAttributesModifiable drawerAttributes = new DrawerAttributes();
    private long lastClickTime;
    private UUID lastClickUUID;
    private boolean loading;

    protected BlockEntityDrawers(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.upgradeData.setDrawerAttributes(this.drawerAttributes);
        this.injectPortableData(this.customNameData);
        this.injectPortableData(this.upgradeData);
        this.injectPortableData(this.controllerData);
        this.injectData(this.materialData);
    }

    private void checkBoundController() {
        Item item;
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("BlockEntityDrawers [{}] checkBoundController", (Object)this.m_58899_());
        }
        BlockEntityController controller = this.controllerData.getController(this);
        ItemStack remote = this.upgradeData.getRemoteUpgrade();
        if (remote == null && controller != null) {
            controller.invalidateRemoteNode(this);
            this.controllerData.bind(null);
            return;
        }
        if (remote != null && (item = remote.m_41720_()) instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote itemRemote = (ItemUpgradeRemote)item;
            BlockEntityController upgradeController = ItemUpgradeRemote.getBoundController(remote, (LevelAccessor)this.f_58857_);
            if (controller != null && controller != upgradeController) {
                controller.invalidateRemoteNode(this);
            }
            if (upgradeController != null) {
                this.controllerData.bind(upgradeController);
                if (!upgradeController.addRemoteNode(this)) {
                    this.controllerData.bind(null);
                }
            }
            if (itemRemote.isBound() && this.controllerData.getController(this) == null) {
                this.upgradeData.unbindRemoteUpgrade();
            }
        }
    }

    public void validateBoundController() {
        this.checkBoundController();
    }

    private boolean controllerInrange(BlockPos controllerPos) {
        BlockPos pos = this.m_58899_();
        int distX = Math.abs(controllerPos.m_123341_() - pos.m_123341_());
        int distY = Math.abs(controllerPos.m_123342_() - pos.m_123342_());
        int distZ = Math.abs(controllerPos.m_123343_() - pos.m_123343_());
        int range = (Integer)ModCommonConfig.INSTANCE.GENERAL.controllerRange.get();
        return distX <= range && distY <= range && distZ <= range;
    }

    @Override
    public boolean supportsDirectControllerLink() {
        return true;
    }

    @Override
    public IControlGroup getBoundControlGroup() {
        return this.controllerData.getController(this);
    }

    @Override
    public boolean canRecurseSearch() {
        ItemStack upgrade = this.upgradeData.getRemoteUpgrade();
        if (upgrade == null) {
            return true;
        }
        Item item = upgrade.m_41720_();
        if (item instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item2 = (ItemUpgradeRemote)item;
            return item2.isGroupUpgrade();
        }
        return true;
    }

    @Override
    public void unbindControlGroup() {
        this.upgradeData.unbindRemoteUpgrade();
    }

    @NotNull
    public abstract IDrawerGroup getGroup();

    public static IDrawerGroup getGroup(BlockEntityDrawers be) {
        if (be == null) {
            return null;
        }
        return be.getGroup();
    }

    @NotNull
    public IDrawerAttributes getDrawerAttributes() {
        return this.drawerAttributes;
    }

    public static IDrawerAttributes getDrawerAttributes(BlockEntityDrawers be) {
        if (be == null) {
            return null;
        }
        return be.getDrawerAttributes();
    }

    public UpgradeData upgrades() {
        return this.upgradeData;
    }

    @Override
    public MaterialData material() {
        return this.materialData;
    }

    public CustomNameData customName() {
        return this.customNameData;
    }

    @Override
    public boolean isGroupValid() {
        return !this.m_58901_();
    }

    public int getDrawerCapacity() {
        Block block = this.m_58900_().m_60734_();
        if (!(block instanceof BlockDrawers)) {
            return 0;
        }
        return ((BlockDrawers)block).getStorageUnits();
    }

    public int getEffectiveDrawerCapacity() {
        if (this.upgradeData.hasOneStackUpgrade()) {
            return 1;
        }
        return this.getDrawerCapacity() * (Integer)ModCommonConfig.INSTANCE.GENERAL.baseStackStorage.get();
    }

    protected boolean emptySlotCanBeCleared(int slot) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        return !drawer.isEmpty() && drawer.getStoredItemCount() == 0;
    }

    @Override
    public UUID getOwner() {
        if (!((Boolean)ModCommonConfig.INSTANCE.GENERAL.enablePersonalKey.get()).booleanValue()) {
            return null;
        }
        return this.owner;
    }

    @Override
    public boolean setOwner(UUID owner) {
        if (!((Boolean)ModCommonConfig.INSTANCE.GENERAL.enablePersonalKey.get()).booleanValue()) {
            return false;
        }
        if (this.owner != null && !this.owner.equals(owner) || owner != null && !owner.equals(this.owner)) {
            this.owner = owner;
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    @Override
    public ISecurityProvider getSecurityProvider() {
        return ModSecurity.registry.getProvider(this.securityKey);
    }

    @Override
    public boolean setSecurityProvider(ISecurityProvider provider) {
        String newKey;
        if (!((Boolean)ModCommonConfig.INSTANCE.GENERAL.enablePersonalKey.get()).booleanValue()) {
            return false;
        }
        String string = newKey = provider == null ? null : provider.getProviderID();
        if (newKey != null && !newKey.equals(this.securityKey) || this.securityKey != null && !this.securityKey.equals(newKey)) {
            this.securityKey = newKey;
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    protected void onAttributeChanged() {
    }

    public boolean isRedstone() {
        return this.upgradeData.getRedstoneType() != null;
    }

    public int getRedstoneLevel() {
        EnumUpgradeRedstone type = this.upgradeData.getRedstoneType();
        if (type == null) {
            return 0;
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case EnumUpgradeRedstone.COMBINED -> this.getCombinedRedstoneLevel();
            case EnumUpgradeRedstone.MAX -> this.getMaxRedstoneLevel();
            case EnumUpgradeRedstone.MIN -> this.getMinRedstoneLevel();
        };
    }

    protected int getCombinedRedstoneLevel() {
        int active = 0;
        float fillRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            if (drawer.getMaxCapacity() > 0) {
                fillRatio += (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity();
            }
            ++active;
        }
        if (active == 0) {
            return 0;
        }
        if (fillRatio == (float)active) {
            return 15;
        }
        return (int)Math.ceil(fillRatio / (float)active * 14.0f);
    }

    protected int getMinRedstoneLevel() {
        float minRatio = 2.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            minRatio = drawer.getMaxCapacity() > 0 ? Math.min(minRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity()) : 0.0f;
        }
        if (minRatio > 1.0f) {
            return 0;
        }
        if (minRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(minRatio * 14.0f);
    }

    protected int getMaxRedstoneLevel() {
        float maxRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled() || drawer.getMaxCapacity() <= 0) continue;
            maxRatio = Math.max(maxRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity());
        }
        if (maxRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(maxRatio * 14.0f);
    }

    @NotNull
    public ItemStack takeItemsFromSlot(int slot, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled() || drawer.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = drawer.getStoredItemPrototype().m_41777_();
        stack.m_41764_(Math.min(count, drawer.getStoredItemCount()));
        drawer.setStoredItemCount(drawer.getStoredItemCount() - stack.m_41613_());
        if (this.upgradeData.hasbalancedFillUpgrade() && !this.upgradeData.hasVendingUpgrade()) {
            StorageUtil.rebalanceDrawers(this.getGroup(), slot);
        }
        if (this.isRedstone() && this.m_58904_() != null) {
            this.m_58904_().m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
            this.m_58904_().m_46672_(this.m_58899_().m_7495_(), this.m_58900_().m_60734_());
        }
        return stack;
    }

    public int putItemsIntoSlot(int slot, @NotNull ItemStack stack, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        if (drawer.isEmpty()) {
            drawer = drawer.setStoredItem(stack);
        }
        if (!drawer.canItemBeStored(stack)) {
            return 0;
        }
        int countAdded = Math.min(count, stack.m_41613_());
        if (!this.drawerAttributes.isVoid()) {
            countAdded = Math.min(countAdded, drawer.getRemainingCapacity());
        }
        drawer.setStoredItemCount(drawer.getStoredItemCount() + countAdded);
        stack.m_41774_(countAdded);
        if (this.upgradeData.hasbalancedFillUpgrade() && !this.upgradeData.hasVendingUpgrade()) {
            StorageUtil.rebalanceDrawers(this.getGroup(), slot);
        }
        return countAdded;
    }

    public int interactPutCurrentItemIntoSlot(int slot, Player player) {
        IDrawer drawer = this.getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        ItemStack playerStack = player.m_150109_().m_36056_();
        if (!playerStack.m_41619_()) {
            count = this.putItemsIntoSlot(slot, playerStack, playerStack.m_41613_());
        }
        return count;
    }

    public int interactPutCurrentInventoryIntoSlot(int slot, Player player) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        if (!drawer.isEmpty()) {
            int n = player.m_150109_().m_6643_();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.m_150109_().m_8020_(i);
                if (subStack.m_41619_()) continue;
                int subCount = this.putItemsIntoSlot(slot, subStack, subStack.m_41613_());
                if (subCount > 0 && subStack.m_41613_() == 0) {
                    player.m_150109_().m_6836_(i, ItemStack.f_41583_);
                }
                count += subCount;
            }
        }
        return count;
    }

    public int interactPutItemsIntoSlot(int slot, Player player) {
        if (this.m_58904_() == null) {
            return 0;
        }
        int count = this.m_58904_().m_46467_() - this.lastClickTime < 10L && player.m_20148_().equals(this.lastClickUUID) ? this.interactPutCurrentInventoryIntoSlot(slot, player) : this.interactPutCurrentItemIntoSlot(slot, player);
        this.lastClickTime = this.m_58904_().m_46467_();
        this.lastClickUUID = player.m_20148_();
        return count;
    }

    public boolean interactReplaceDrawer(int slot, ItemStack detachedDrawer) {
        IDrawer drawer = this.getDrawer(slot);
        if (!drawer.isMissing()) {
            return false;
        }
        if (detachedDrawer.m_41619_()) {
            return false;
        }
        DetachedDrawerData data = new DetachedDrawerData(detachedDrawer.m_41784_());
        ItemStack proto = data.getStoredItemPrototype();
        int count = data.getStoredItemCount();
        if (count > drawer.getMaxCapacity(proto)) {
            return false;
        }
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.forceDetachedDrawersMaxCapacityCheck.get()).booleanValue()) {
            int cap = this.getEffectiveDrawerCapacity() * this.upgradeData.getStorageMultiplier();
            if (data.getStorageMultiplier() < cap) {
                return false;
            }
        }
        drawer.setDetached(false);
        drawer.setStoredItem(proto, count);
        if (this.drawerAttributes.isBalancedFill()) {
            StorageUtil.rebalanceDrawers(this.getGroup(), slot);
        }
        return true;
    }

    @Override
    public void readPortable(CompoundTag tag) {
        this.loading = true;
        super.readPortable(tag);
        if (tag.m_128441_("Lock")) {
            EnumSet<LockAttribute> attrs = LockAttribute.getEnumSet(tag.m_128445_("Lock"));
            if (attrs != null) {
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, attrs.contains((Object)LockAttribute.LOCK_EMPTY));
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, attrs.contains((Object)LockAttribute.LOCK_POPULATED));
            }
        } else {
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, false);
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, false);
        }
        if (tag.m_128441_("Shr")) {
            this.drawerAttributes.setIsConcealed(tag.m_128471_("Shr"));
        } else {
            this.drawerAttributes.setIsConcealed(false);
        }
        if (tag.m_128441_("Qua")) {
            this.drawerAttributes.setIsShowingQuantity(tag.m_128471_("Qua"));
        } else {
            this.drawerAttributes.setIsShowingQuantity(false);
        }
        this.owner = null;
        if (tag.m_128441_("Own")) {
            this.owner = UUID.fromString(tag.m_128461_("Own"));
        }
        this.securityKey = null;
        if (tag.m_128441_("Sec")) {
            this.securityKey = tag.m_128461_("Sec");
        }
        if (tag.m_128441_("Pri")) {
            this.drawerAttributes.setPriority(tag.m_128451_("Pri"));
        } else {
            this.drawerAttributes.setPriority(0);
        }
        this.loading = false;
    }

    @Override
    public CompoundTag writePortable(CompoundTag tag) {
        tag = super.writePortable(tag);
        EnumSet<LockAttribute> attrs = EnumSet.noneOf(LockAttribute.class);
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_EMPTY)) {
            attrs.add(LockAttribute.LOCK_EMPTY);
        }
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attrs.add(LockAttribute.LOCK_POPULATED);
        }
        if (!attrs.isEmpty()) {
            tag.m_128344_("Lock", (byte)LockAttribute.getBitfield(attrs));
        }
        if (this.drawerAttributes.isConcealed()) {
            tag.m_128379_("Shr", true);
        }
        if (this.drawerAttributes.isShowingQuantity()) {
            tag.m_128379_("Qua", true);
        }
        if (this.owner != null) {
            tag.m_128359_("Own", this.owner.toString());
        }
        if (this.securityKey != null) {
            tag.m_128359_("Sec", this.securityKey);
        }
        if (this.drawerAttributes.getPriority() != 0) {
            tag.m_128405_("Pri", this.drawerAttributes.getPriority());
        }
        return tag;
    }

    @Override
    protected void onLoadFinished() {
        super.onLoadFinished();
    }

    public void m_6596_() {
        if (this.isRedstone() && this.m_58904_() != null) {
            this.m_58904_().m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
            this.m_58904_().m_46672_(this.m_58899_().m_7495_(), this.m_58900_().m_60734_());
        }
        super.m_6596_();
    }

    protected void syncClientCount(int slot, int count) {
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            return;
        }
        ChameleonServices.NETWORK.sendToPlayersNear(new CountUpdateMessage(this.m_58899_(), slot, count), (ServerLevel)this.m_58904_(), this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_(), 500.0);
    }

    public void clientUpdateCount(int slot, int count) {
        if (this.m_58904_() == null || !this.m_58904_().f_46443_) {
            return;
        }
        Minecraft.m_91087_().m_6937_(() -> this.clientUpdateCountAsync(slot, count));
    }

    private void clientUpdateCountAsync(int slot, int count) {
        IDrawer drawer = this.getDrawer(slot);
        if (drawer.isEnabled() && drawer.getStoredItemCount() != count) {
            drawer.setStoredItemCount(count);
        }
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    @Deprecated
    public int getDrawerCount() {
        return this.getGroup().getDrawerCount();
    }

    @Override
    @Deprecated
    @NotNull
    public IDrawer getDrawer(int slot) {
        return this.getGroup().getDrawer(slot);
    }

    @Override
    @Deprecated
    public int[] getAccessibleDrawerSlots() {
        return this.getGroup().getAccessibleDrawerSlots();
    }

    @Override
    public <T> T getCapability(ChameleonCapability<T> capability) {
        if (capability == null || this.f_58857_ == null) {
            return null;
        }
        return capability.getCapability(this.f_58857_, this.m_58899_());
    }

    private class DrawerUpgradeData
    extends UpgradeData {
        DrawerUpgradeData() {
            super(7);
        }

        @Override
        public boolean canAddUpgrade(@NotNull ItemStack upgrade) {
            if (!super.canAddUpgrade(upgrade)) {
                return false;
            }
            if (upgrade.m_41720_() == ModItems.ONE_STACK_UPGRADE.get()) {
                int lostStackCapacity = BlockEntityDrawers.this.upgradeData.getStorageMultiplier() * (BlockEntityDrawers.this.getEffectiveDrawerCapacity() - 1);
                return this.stackCapacityCheck(lostStackCapacity);
            }
            return true;
        }

        @Override
        public boolean canRemoveUpgrade(int slot) {
            if (!super.canRemoveUpgrade(slot)) {
                return false;
            }
            ItemStack upgrade = this.getUpgrade(slot);
            if (upgrade.m_41720_() instanceof ItemUpgradeStorage) {
                int storageLevel = ((ItemUpgradeStorage)upgrade.m_41720_()).level.getLevel();
                int storageMult = ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(storageLevel);
                int effectiveStorageMult = BlockEntityDrawers.this.upgradeData.getStorageMultiplier();
                if (effectiveStorageMult == storageMult) {
                    --storageMult;
                }
                int addedStackCapacity = storageMult * BlockEntityDrawers.this.getEffectiveDrawerCapacity();
                return this.stackCapacityCheck(addedStackCapacity);
            }
            return true;
        }

        @Override
        public boolean canSwapUpgrade(int slot, @NotNull ItemStack add) {
            if (!(add.m_41720_() instanceof ItemUpgradeStorage)) {
                return false;
            }
            ItemStack upgrade = this.getUpgrade(slot);
            if (upgrade.m_41720_() == ModItems.ONE_STACK_UPGRADE.get()) {
                return true;
            }
            if (!(upgrade.m_41720_() instanceof ItemUpgradeStorage)) {
                return false;
            }
            if (!this.canAddUpgrade(add)) {
                return false;
            }
            if (((ItemUpgradeStorage)add.m_41720_()).level.getLevel() > ((ItemUpgradeStorage)upgrade.m_41720_()).level.getLevel()) {
                return true;
            }
            int currentUpgradeMult = BlockEntityDrawers.this.upgradeData.getStorageMultiplier();
            int storageLevel = ((ItemUpgradeStorage)upgrade.m_41720_()).level.getLevel();
            int storageMult = ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(storageLevel);
            int removedStacks = Math.min(currentUpgradeMult * BlockEntityDrawers.this.getEffectiveDrawerCapacity() - 1, currentUpgradeMult * (BlockEntityDrawers.this.getEffectiveDrawerCapacity() - 1) + storageMult);
            return this.stackCapacityCheck(removedStacks);
        }

        @Override
        protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
            if (BlockEntityDrawers.this.m_58904_() != null && !BlockEntityDrawers.this.m_58904_().f_46443_) {
                BlockEntityDrawers.this.checkBoundController();
                if (BlockEntityDrawers.this.getBoundControlGroup() != null) {
                    BlockEntityDrawers.this.getBoundControlGroup().addRemoteNode(BlockEntityDrawers.this);
                }
                BlockEntityDrawers.this.m_6596_();
                BlockEntityDrawers.this.markBlockForUpdate();
            }
        }

        private boolean stackCapacityCheck(int stackCapacity) {
            for (int i = 0; i < BlockEntityDrawers.this.getDrawerCount(); ++i) {
                IDrawer drawer = BlockEntityDrawers.this.getDrawer(i);
                if (!drawer.isEnabled() || drawer.isEmpty()) continue;
                int addedItemCapacity = stackCapacity * drawer.getStoredItemStackSize();
                if (drawer.getMaxCapacity() - addedItemCapacity >= drawer.getStoredItemCount()) continue;
                return false;
            }
            return true;
        }
    }

    private class DrawerAttributes
    extends BasicDrawerAttributes {
        private DrawerAttributes() {
        }

        @Override
        protected void onAttributeChanged() {
            if (!BlockEntityDrawers.this.loading && !BlockEntityDrawers.this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                for (int slot = 0; slot < BlockEntityDrawers.this.getGroup().getDrawerCount(); ++slot) {
                    if (!BlockEntityDrawers.this.emptySlotCanBeCleared(slot)) continue;
                    IDrawer drawer = BlockEntityDrawers.this.getGroup().getDrawer(slot);
                    drawer.setStoredItem(ItemStack.f_41583_);
                }
            }
            BlockEntityDrawers.this.onAttributeChanged();
            if (BlockEntityDrawers.this.m_58904_() != null && !BlockEntityDrawers.this.m_58904_().f_46443_) {
                BlockEntityDrawers.this.m_6596_();
                BlockEntityDrawers.this.markBlockForUpdate();
            }
        }
    }

    public static class ContentProvider
    implements ContentMenuProvider<PositionContent> {
        private BlockEntityDrawers entity;

        public ContentProvider(BlockEntityDrawers entity) {
            this.entity = entity;
        }

        @Override
        public PositionContent createContent(ServerPlayer player) {
            return new PositionContent(this.entity.m_58899_());
        }

        public Component m_5446_() {
            if (this.entity.customNameData.hasCustomName()) {
                return this.entity.customNameData.getDisplayName();
            }
            ItemStack stack = new ItemStack((ItemLike)this.entity.m_58900_().m_60734_());
            return stack.m_41720_().m_7626_(stack);
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return switch (this.entity.getGroup().getDrawerCount()) {
                case 1 -> new ContainerDrawers1(id, inventory, this.entity);
                case 2 -> new ContainerDrawers2(id, inventory, this.entity);
                case 4 -> new ContainerDrawers4(id, inventory, this.entity);
                case 3 -> new ContainerDrawersComp3(id, inventory, this.entity);
                default -> null;
            };
        }
    }
}

