/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.FractionalDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityDrawersComp
extends BlockEntityDrawers {
    public BlockEntityDrawersComp(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public static BlockEntityDrawersComp createEntity(int slotCount, BlockPos pos, BlockState state) {
        return switch (slotCount) {
            case 2 -> new Slot2(pos, state);
            case 3 -> new Slot3(pos, state);
            default -> null;
        };
    }

    @Override
    protected boolean emptySlotCanBeCleared(int slot) {
        if (slot != 0) {
            return false;
        }
        IDrawerGroup iDrawerGroup = this.getGroup();
        if (iDrawerGroup instanceof FractionalDrawerGroup) {
            FractionalDrawerGroup fracGroup = (FractionalDrawerGroup)iDrawerGroup;
            return !this.getGroup().getDrawer(0).isEmpty() && fracGroup.getPooledCount() == 0;
        }
        return false;
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    public void clientUpdateCount(int slot, int count) {
        if (this.m_58904_() == null || !this.m_58904_().f_46443_) {
            return;
        }
        Minecraft.m_91087_().m_6937_(() -> this.clientUpdateCountAsync(count));
    }

    private void clientUpdateCountAsync(int count) {
        if (this.getGroup() instanceof FractionalDrawerGroup) {
            ((FractionalDrawerGroup)this.getGroup()).setPooledCount(count);
        }
    }

    public static class Slot2
    extends BlockEntityDrawersComp {
        private final GroupData groupData = new GroupData(2);

        public Slot2(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.FRACTIONAL_DRAWERS_2.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot3
    extends BlockEntityDrawersComp {
        private final GroupData groupData = new GroupData(3);

        public Slot3(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.FRACTIONAL_DRAWERS_3.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    private class GroupData
    extends FractionalDrawerGroup {
        public GroupData(int slotCount) {
            super(slotCount);
        }

        @Override
        protected Level getWorld() {
            return BlockEntityDrawersComp.this.m_58904_();
        }

        @Override
        public boolean isGroupValid() {
            return BlockEntityDrawersComp.this.isGroupValid();
        }

        @Override
        protected void log(String message) {
            if (!this.getWorld().f_46443_ && ((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
                ModServices.log.info(message);
            }
        }

        @Override
        protected int getStackCapacity() {
            return BlockEntityDrawersComp.this.upgrades().getStorageMultiplier() * BlockEntityDrawersComp.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            if (this.getWorld() != null && !this.getWorld().f_46443_) {
                int usedSlots = 0;
                for (int slot : this.getAccessibleDrawerSlots()) {
                    IFractionalDrawer drawer = this.getDrawer(slot);
                    if (drawer.isEmpty()) continue;
                    ++usedSlots;
                }
                usedSlots = Math.max(usedSlots, 1);
                EnumCompDrawer open = (EnumCompDrawer)((Object)BlockEntityDrawersComp.this.m_58900_().m_61143_(BlockCompDrawers.SLOTS));
                if (open.getOpenSlots() != usedSlots) {
                    this.getWorld().m_7731_(BlockEntityDrawersComp.this.f_58858_, (BlockState)BlockEntityDrawersComp.this.m_58900_().m_61124_(BlockCompDrawers.SLOTS, (Comparable)((Object)EnumCompDrawer.byOpenSlots(usedSlots))), 3);
                }
                BlockEntityDrawersComp.this.m_6596_();
                BlockEntityDrawersComp.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (this.getWorld() != null && !this.getWorld().f_46443_) {
                ChameleonServices.NETWORK.sendToPlayersNear(new CountUpdateMessage(BlockEntityDrawersComp.this.m_58899_(), 0, this.getPooledCount()), (ServerLevel)BlockEntityDrawersComp.this.m_58904_(), BlockEntityDrawersComp.this.m_58899_().m_123341_(), BlockEntityDrawersComp.this.m_58899_().m_123342_(), BlockEntityDrawersComp.this.m_58899_().m_123343_(), 500.0);
                BlockEntityDrawersComp.this.m_6596_();
            }
        }

        @Override
        public <T> T getCapability(ChameleonCapability<T> capability) {
            if (capability == null || BlockEntityDrawersComp.this.f_58857_ == null) {
                return null;
            }
            return capability.getCapability(BlockEntityDrawersComp.this.f_58857_, BlockEntityDrawersComp.this.m_58899_());
        }
    }
}

