/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.CustomNameData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerFramingTable;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import com.texelsaurus.minecraft.chameleon.inventory.content.PositionContent;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityFramingTable
extends BaseBlockEntity
implements MenuProvider {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_SIDE = 1;
    public static final int SLOT_TRIM = 2;
    public static final int SLOT_FRONT = 3;
    public static final int SLOT_RESULT = 4;
    private final BlockInventory inventory;
    private final CustomNameData customNameData = new CustomNameData();
    private final MaterialData materialData = new MaterialData();
    protected ItemStack inputStack = ItemStack.f_41583_;
    protected ItemStack resultStack = ItemStack.f_41583_;

    public BlockEntityFramingTable(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.injectPortableData(this.customNameData);
        this.injectData(this.materialData);
        this.inventory = new BlockInventory(this);
    }

    public BlockEntityFramingTable(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.FRAMING_TABLE.get(), pos, state);
    }

    public static boolean isMaterialSlot(int slotIndex) {
        return slotIndex == 1 || slotIndex == 2 || slotIndex == 3;
    }

    public MaterialData material() {
        return this.materialData;
    }

    public CustomNameData customName() {
        return this.customNameData;
    }

    public BlockInventory inventory() {
        return this.inventory;
    }

    @Override
    protected void readFixed(CompoundTag tag) {
        super.readFixed(tag);
        this.inputStack = ItemStack.f_41583_;
        if (tag.m_128441_("Input")) {
            this.inputStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Input"));
        }
        this.resultStack = ItemStack.f_41583_;
        if (tag.m_128441_("Result")) {
            this.resultStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Result"));
        }
    }

    @Override
    protected CompoundTag writeFixed(CompoundTag tag) {
        CompoundTag itag;
        tag = super.writeFixed(tag);
        if (!this.inputStack.m_41619_()) {
            itag = new CompoundTag();
            this.inputStack.m_41739_(itag);
            tag.m_128365_("Input", (Tag)itag);
        }
        if (!this.resultStack.m_41619_()) {
            itag = new CompoundTag();
            this.resultStack.m_41739_(itag);
            tag.m_128365_("Result", (Tag)itag);
        }
        return tag;
    }

    public boolean isItemValidTarget(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        if (blockItem.m_40614_() instanceof IFramedBlock) {
            MaterialData data = new MaterialData();
            data.read(stack.m_41784_());
            if (!data.getSide().m_41619_() && !this.materialData.getSide().m_41619_()) {
                return false;
            }
            if (!data.getTrim().m_41619_() && !this.materialData.getTrim().m_41619_()) {
                return false;
            }
            return data.getFront().m_41619_() || this.materialData.getFront().m_41619_();
        }
        return blockItem.m_40614_() instanceof IFramedSourceBlock;
    }

    public static boolean isItemValidMaterial(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState state = blockItem.m_40614_().m_49966_();
        if (state.m_60734_().m_49967_()) {
            return false;
        }
        if (!((Boolean)ModCommonConfig.INSTANCE.GENERAL.restrictFramingMaterials.get()).booleanValue()) {
            return state.m_280296_();
        }
        if (!state.m_60815_()) {
            return false;
        }
        try {
            if (state.m_60739_(null, null) < 15) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!Block.m_49916_((VoxelShape)state.m_60768_(null, null))) {
                return false;
            }
            if (state.m_60631_(null, null)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.storagedrawers.framing_table");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playInventory, @NotNull Player player) {
        return new ContainerFramingTable((MenuType)ModContainers.FRAMING_TABLE.get(), windowId, playInventory, this);
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return BlockEntityFramingTable.encapsulatingFullBlocks(pos.m_7918_(-1, 0, -1), pos.m_7918_(1, 1, 1));
    }

    static AABB encapsulatingFullBlocks(BlockPos $$0, BlockPos $$1) {
        return new AABB((double)Math.min($$0.m_123341_(), $$1.m_123341_()), (double)Math.min($$0.m_123342_(), $$1.m_123342_()), (double)Math.min($$0.m_123343_(), $$1.m_123343_()), (double)(Math.max($$0.m_123341_(), $$1.m_123341_()) + 1), (double)(Math.max($$0.m_123342_(), $$1.m_123342_()) + 1), (double)(Math.max($$0.m_123343_(), $$1.m_123343_()) + 1));
    }

    public static class BlockInventory
    implements Container {
        private BlockEntityFramingTable entity;

        private BlockInventory(BlockEntityFramingTable entity) {
            this.entity = entity;
        }

        public int m_6643_() {
            return 5;
        }

        public boolean m_7983_() {
            if (!this.entity.inputStack.m_41619_()) {
                return false;
            }
            if (!this.entity.resultStack.m_41619_()) {
                return false;
            }
            if (!this.entity.materialData.getSide().m_41619_()) {
                return false;
            }
            if (!this.entity.materialData.getTrim().m_41619_()) {
                return false;
            }
            return this.entity.materialData.getFront().m_41619_();
        }

        public boolean m_7013_(int slotIndex, ItemStack stack) {
            if (slotIndex == 0) {
                return this.entity.isItemValidTarget(stack);
            }
            if (slotIndex == 1 || slotIndex == 2 || slotIndex == 3) {
                return BlockEntityFramingTable.isItemValidMaterial(stack);
            }
            return false;
        }

        public ItemStack m_8020_(int slot) {
            return switch (slot) {
                case 0 -> this.entity.inputStack;
                case 3 -> this.entity.materialData.getFront();
                case 1 -> this.entity.materialData.getSide();
                case 2 -> this.entity.materialData.getTrim();
                case 4 -> this.entity.resultStack;
                default -> null;
            };
        }

        public ItemStack m_7407_(int slot, int amount) {
            if (slot < 0 || slot > this.m_6643_() || amount <= 0) {
                return ItemStack.f_41583_;
            }
            ItemStack ret = this.m_8020_(slot).m_41620_(amount);
            this.rebuildResult();
            this.m_6596_();
            return ret;
        }

        public ItemStack m_8016_(int slot) {
            if (slot < 0 || slot > this.m_6643_()) {
                return ItemStack.f_41583_;
            }
            ItemStack result = this.m_8020_(slot);
            this.m_6836_(slot, ItemStack.f_41583_);
            return result;
        }

        public void m_6836_(int slot, ItemStack stack) {
            if (slot == 4) {
                return;
            }
            switch (slot) {
                case 0: {
                    this.setInputItem(stack);
                    break;
                }
                case 3: {
                    this.entity.materialData.setFront(stack);
                    break;
                }
                case 1: {
                    this.entity.materialData.setSide(stack);
                    break;
                }
                case 2: {
                    this.entity.materialData.setTrim(stack);
                }
            }
            this.m_6596_();
        }

        public void m_6596_() {
            this.rebuildResult();
            this.entity.m_6596_();
        }

        private void setInputItem(ItemStack stack) {
            BlockItem blockItem;
            Block block;
            Item item;
            if (this.entity.f_58857_ != null && !stack.m_41619_() && (item = stack.m_41720_()) instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof IFramedBlock) {
                IFramedBlock fb = (IFramedBlock)block;
                MaterialData data = new MaterialData();
                data.read(stack.m_41784_());
                if (fb.supportsFrameMaterial(FrameMaterial.SIDE) && !this.entity.materialData.getSide().m_41619_() && !data.getSide().m_41619_()) {
                    this.entity.resultStack = stack;
                    return;
                }
                if (fb.supportsFrameMaterial(FrameMaterial.TRIM) && !this.entity.materialData.getTrim().m_41619_() && !data.getTrim().m_41619_()) {
                    this.entity.resultStack = stack;
                    return;
                }
                if (fb.supportsFrameMaterial(FrameMaterial.FRONT) && !this.entity.materialData.getFront().m_41619_() && !data.getFront().m_41619_()) {
                    this.entity.resultStack = stack;
                    return;
                }
                ItemStack source = data.getFrameBase();
                if (!source.m_41619_()) {
                    source.m_41751_(stack.m_41784_().m_6426_());
                    MaterialData empty = new MaterialData();
                    empty.write(source.m_41783_());
                    int count = stack.m_41613_();
                    this.entity.inputStack = source.m_255036_(count);
                    this.entity.materialData.setSide(fb.supportsFrameMaterial(FrameMaterial.SIDE) ? data.getSide().m_255036_(count) : ItemStack.f_41583_);
                    this.entity.materialData.setTrim(fb.supportsFrameMaterial(FrameMaterial.TRIM) ? data.getTrim().m_255036_(count) : ItemStack.f_41583_);
                    this.entity.materialData.setFront(fb.supportsFrameMaterial(FrameMaterial.FRONT) ? data.getFront().m_255036_(count) : ItemStack.f_41583_);
                    return;
                }
            }
            this.entity.inputStack = stack;
        }

        private void rebuildResult() {
            BlockItem blockItem;
            Block block;
            Item item;
            ItemStack target = this.m_8020_(0);
            if (target.m_41619_()) {
                this.entity.resultStack = ItemStack.f_41583_;
                return;
            }
            ItemStack matSide = this.m_8020_(1);
            ItemStack matTrim = this.m_8020_(2);
            ItemStack matFront = this.m_8020_(3);
            if (!target.m_41619_() && (item = target.m_41720_()) instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof IFramedSourceBlock) {
                IFramedSourceBlock fsb = (IFramedSourceBlock)block;
                this.entity.resultStack = matSide.m_41619_() ? ItemStack.f_41583_ : fsb.makeFramedItem(target, matSide, matTrim, matFront);
            }
            int count = this.entity.resultStack.m_41613_();
            if (!matSide.m_41619_()) {
                count = Math.min(count, matSide.m_41613_());
            }
            if (!matTrim.m_41619_()) {
                count = Math.min(count, matTrim.m_41613_());
            }
            if (!matFront.m_41619_()) {
                count = Math.min(count, matFront.m_41613_());
            }
            this.entity.resultStack.m_41764_(count);
        }

        public boolean m_6542_(Player player) {
            return Container.m_272074_((BlockEntity)this.entity, (Player)player);
        }

        public void m_6211_() {
            this.entity.inputStack = ItemStack.f_41583_;
            this.entity.resultStack = ItemStack.f_41583_;
            this.entity.materialData.clear();
        }
    }

    public static class ContentProvider
    implements ContentMenuProvider<PositionContent> {
        private BlockEntityFramingTable entity;

        public ContentProvider(BlockEntityFramingTable entity) {
            this.entity = entity;
        }

        @Override
        public PositionContent createContent(ServerPlayer player) {
            return new PositionContent(this.entity.m_58899_());
        }

        public Component m_5446_() {
            if (this.entity.customNameData.hasCustomName()) {
                return this.entity.customNameData.getDisplayName();
            }
            return Component.m_237115_((String)"container.storagedrawers.framing_table");
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new ContainerFramingTable((MenuType)ModContainers.FRAMING_TABLE.get(), id, inventory, this.entity);
        }
    }
}

