/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesGroupControl;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockEntitySlave
extends BaseBlockEntity
implements IDrawerGroup,
IControlGroup,
IFramedBlockEntity {
    private static final int[] drawerSlots = new int[]{0};
    public final ControllerData controllerData = new ControllerData();
    public final MaterialData materialData = new MaterialData();
    private final ItemRepositoryProxy itemRepository = new ItemRepositoryProxy();

    public BlockEntitySlave(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.injectData(this.controllerData);
        this.injectPortableData(this.materialData);
    }

    public BlockEntitySlave(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.CONTROLLER_IO.get(), pos, state);
    }

    @Override
    public IDrawerGroup getDrawerGroup() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.m_58899_())) {
            return null;
        }
        return controller.getDrawerGroup();
    }

    @Override
    public IDrawerAttributesGroupControl getGroupControllableAttributes(Player player) {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.m_58899_())) {
            return null;
        }
        return controller.getGroupControllableAttributes(player);
    }

    @Override
    public IControlGroup getBoundControlGroup() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.m_58899_())) {
            return null;
        }
        return controller;
    }

    @Override
    public List<INetworked> getBoundRemoteNodes() {
        return List.of();
    }

    @Override
    public void validateRemoteNode(INetworked node) {
    }

    @Override
    public void invalidateRemoteNode(INetworked node) {
    }

    @Override
    public boolean addRemoteNode(INetworked node) {
        return false;
    }

    @Override
    public boolean isGroupValid() {
        return !this.m_58901_();
    }

    public void bindController(BlockPos coord) {
        if (this.controllerData.bindCoord(coord)) {
            this.m_6596_();
        }
    }

    public BlockPos getControllerPos() {
        return this.controllerData.getCoord();
    }

    public BlockEntityController getController() {
        return this.controllerData.getController(this);
    }

    public IItemRepository getItemRepository() {
        return this.itemRepository;
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.m_58899_())) {
            return drawerSlots;
        }
        return controller.getAccessibleDrawerSlots();
    }

    @Override
    public int getDrawerCount() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.m_58899_())) {
            return 0;
        }
        return controller.getDrawerCount();
    }

    @Override
    @NotNull
    public IDrawer getDrawer(int slot) {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.m_58899_())) {
            return Drawers.DISABLED;
        }
        return controller.getDrawer(slot);
    }

    public void m_6596_() {
        BlockEntityController controller = this.getController();
        if (controller != null && controller.isValidIO(this.m_58899_())) {
            controller.m_6596_();
        }
        super.m_6596_();
    }

    @Override
    public <T> T getCapability(ChameleonCapability<T> capability) {
        if (capability == null || this.f_58857_ == null) {
            return null;
        }
        return capability.getCapability(this.f_58857_, this.m_58899_());
    }

    @Override
    public MaterialData material() {
        return this.materialData;
    }

    private class ItemRepositoryProxy
    implements IItemRepository {
        private ItemRepositoryProxy() {
        }

        @Override
        @NotNull
        public NonNullList<IItemRepository.ItemRecord> getAllItems() {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntitySlave.this.m_58899_())) {
                return NonNullList.m_122779_();
            }
            return controller.getItemRepository().getAllItems();
        }

        @Override
        @NotNull
        public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntitySlave.this.m_58899_())) {
                return stack;
            }
            return controller.getItemRepository().insertItem(stack, simulate, predicate);
        }

        @Override
        @NotNull
        public ItemStack extractItem(@NotNull ItemStack stack, int amount, boolean simulate, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntitySlave.this.m_58899_())) {
                return ItemStack.f_41583_;
            }
            return controller.getItemRepository().extractItem(stack, amount, simulate, predicate);
        }

        @Override
        public int getStoredItemCount(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntitySlave.this.m_58899_())) {
                return 0;
            }
            return controller.getItemRepository().getStoredItemCount(stack, predicate);
        }

        @Override
        public int getRemainingItemCapacity(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntitySlave.this.m_58899_())) {
                return 0;
            }
            return controller.getItemRepository().getRemainingItemCapacity(stack, predicate);
        }

        @Override
        public int getItemCapacity(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntitySlave.this.m_58899_())) {
                return 0;
            }
            return controller.getItemRepository().getItemCapacity(stack, predicate);
        }
    }
}

