/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DetachedDrawerData
implements IDrawer {
    private ItemStack protoStack;
    private int count;
    private int storageMult;
    private boolean heavy;

    public DetachedDrawerData() {
        this.protoStack = ItemStack.f_41583_;
        this.count = 0;
        this.storageMult = 1;
        this.heavy = false;
    }

    public DetachedDrawerData(IDrawer sourceDrawer) {
        this(sourceDrawer, 1);
    }

    public DetachedDrawerData(IDrawer sourceDrawer, int storageMult) {
        this.protoStack = sourceDrawer.getStoredItemPrototype();
        this.count = sourceDrawer.getStoredItemCount();
        this.storageMult = storageMult;
    }

    public DetachedDrawerData(CompoundTag serializedTag) {
        this.deserializeNBT(serializedTag);
    }

    public int getStorageMultiplier() {
        return this.storageMult;
    }

    public void setStorageMultiplier(int storageMult) {
        this.storageMult = storageMult;
    }

    public boolean isHeavy() {
        return this.heavy;
    }

    public void setIsHeavy(boolean state) {
        this.heavy = state;
    }

    @Override
    @NotNull
    public ItemStack getStoredItemPrototype() {
        return this.protoStack;
    }

    @Override
    @NotNull
    public IDrawer setStoredItem(@NotNull ItemStack itemPrototype) {
        return this;
    }

    protected IDrawer setStoredItemRaw(@NotNull ItemStack itemPrototype) {
        this.protoStack = itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype);
        this.protoStack.m_41764_(1);
        this.count = 0;
        return this;
    }

    @Override
    public int getStoredItemCount() {
        return this.count;
    }

    @Override
    public void setStoredItemCount(int amount) {
    }

    protected void setStoredItemCountRaw(int amount) {
        this.count = amount;
    }

    @Override
    public int getMaxCapacity(@NotNull ItemStack itemPrototype) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getRemainingCapacity() {
        return this.getMaxCapacity() - this.getStoredItemCount();
    }

    @Override
    public boolean canItemBeStored(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
        return false;
    }

    @Override
    public boolean canItemBeExtracted(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.protoStack.m_41619_();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.storageMult > 1) {
            tag.m_128405_("StorageMult", this.storageMult);
        }
        if (this.protoStack.m_41619_()) {
            return tag;
        }
        CompoundTag item = new CompoundTag();
        this.protoStack.m_41739_(item);
        tag.m_128365_("Item", (Tag)item);
        tag.m_128405_("Count", this.count);
        if (this.heavy) {
            tag.m_128379_("Heavy", true);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ItemStack tagItem = ItemStack.f_41583_;
        int tagCount = 0;
        if (nbt == null) {
            return;
        }
        if (nbt.m_128441_("Item")) {
            tagItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Item"));
        }
        if (nbt.m_128441_("Count")) {
            tagCount = nbt.m_128451_("Count");
        }
        this.storageMult = nbt.m_128441_("StorageMult") ? nbt.m_128451_("StorageMult") : (Integer)ModCommonConfig.INSTANCE.GENERAL.baseStackStorage.get() * 8;
        if (nbt.m_128441_("Heavy")) {
            this.setIsHeavy(nbt.m_128471_("Heavy"));
        }
        this.setStoredItemRaw(tagItem);
        this.setStoredItemCountRaw(tagCount);
    }
}

