/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.storage.StorageUtil;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DrawerItemRepository
implements IItemRepository {
    protected IDrawerGroup group;

    public DrawerItemRepository(IDrawerGroup group) {
        this.group = group;
    }

    @Override
    @NotNull
    public NonNullList<IItemRepository.ItemRecord> getAllItems() {
        NonNullList records = NonNullList.m_122779_();
        if (this.group == null) {
            return records;
        }
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (drawer.isEmpty()) continue;
            ItemStack stack = drawer.getStoredItemPrototype();
            records.add((Object)new IItemRepository.ItemRecord(stack, drawer.getStoredItemCount()));
        }
        return records;
    }

    @Override
    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate, Predicate<ItemStack> predicate) {
        IDrawerAttributes attrs;
        boolean empty;
        IDrawer drawer;
        int amount = stack.m_41613_();
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            drawer = this.group.getDrawer(slot);
            if (!drawer.isEnabled() || !this.testPredicateInsert(drawer, stack, predicate)) continue;
            empty = drawer.isEmpty();
            if (empty && !simulate) {
                drawer = drawer.setStoredItem(stack);
            }
            int capacity = empty ? drawer.getMaxCapacity(stack) : drawer.getRemainingCapacity();
            int adjusted = Math.min(amount, capacity);
            int n = amount = simulate ? Math.max(amount - capacity, 0) : amount - adjusted + drawer.adjustStoredItemCount(adjusted);
            if (amount == 0) break;
        }
        if (amount > 0) {
            for (int slot : this.group.getAccessibleDrawerSlots()) {
                drawer = this.group.getDrawer(slot);
                if (!drawer.isEnabled() || !this.testPredicateInsert(drawer, stack, predicate)) continue;
                empty = drawer.isEmpty();
                if (empty && !simulate) {
                    drawer = drawer.setStoredItem(stack);
                }
                int n = simulate ? Math.max(amount - (empty ? drawer.getAcceptingMaxCapacity(stack) : drawer.getAcceptingRemainingCapacity()), 0) : (amount = drawer.adjustStoredItemCount(amount));
                if (amount == 0) break;
            }
        }
        if ((attrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES)) == null) {
            attrs = EmptyDrawerAttributes.EMPTY;
        }
        if (!simulate && attrs.isBalancedFill() && !attrs.isUnlimitedVending()) {
            StorageUtil.rebalanceDrawers(this.group, stack);
        }
        return amount == 0 ? ItemStack.f_41583_ : this.stackResult(stack, amount);
    }

    @Override
    @NotNull
    public ItemStack extractItem(@NotNull ItemStack stack, int amount, boolean simulate, Predicate<ItemStack> predicate) {
        IDrawerAttributes attrs;
        int remaining = amount;
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!drawer.isEnabled() || !this.testPredicateExtract(drawer, stack, predicate)) continue;
            int n = remaining = simulate ? Math.max(remaining - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-remaining);
            if (remaining == 0) break;
        }
        if ((attrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES)) == null) {
            attrs = EmptyDrawerAttributes.EMPTY;
        }
        if (!simulate && attrs.isBalancedFill() && !attrs.isUnlimitedVending()) {
            StorageUtil.rebalanceDrawers(this.group, stack);
        }
        return amount == remaining ? ItemStack.f_41583_ : this.stackResult(stack, amount - remaining);
    }

    @Override
    public int getStoredItemCount(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
        long count = 0L;
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!this.testPredicateInsert(drawer, stack, predicate) || (count += (long)drawer.getStoredItemCount()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)count;
    }

    @Override
    public int getRemainingItemCapacity(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
        long remainder = 0L;
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!this.testPredicateInsert(drawer, stack, predicate) || (remainder += (long)drawer.getRemainingCapacity()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)remainder;
    }

    @Override
    public int getItemCapacity(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
        long capacity = 0L;
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!this.testPredicateInsert(drawer, stack, predicate) || (capacity += (long)drawer.getMaxCapacity()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)capacity;
    }

    protected boolean testPredicateInsert(IDrawer drawer, @NotNull ItemStack stack, Predicate<ItemStack> predicate) {
        if (predicate instanceof IItemRepository.DefaultPredicate) {
            return drawer.canItemBeStored(stack) || predicate.test(drawer.getStoredItemPrototype());
        }
        return drawer.canItemBeStored(stack, predicate);
    }

    protected boolean testPredicateExtract(IDrawer drawer, @NotNull ItemStack stack, Predicate<ItemStack> predicate) {
        if (predicate instanceof IItemRepository.DefaultPredicate) {
            return drawer.canItemBeExtracted(stack) || predicate.test(drawer.getStoredItemPrototype());
        }
        return drawer.canItemBeStored(stack, predicate);
    }

    protected ItemStack stackResult(@NotNull ItemStack stack, int amount) {
        ItemStack result = stack.m_41777_();
        result.m_41764_(amount);
        return result;
    }
}

