/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ConversionRegistry {
    public static final ConversionRegistry INSTANCE = new ConversionRegistry();
    private Set<TagKey<Item>> tagWhitelist = new HashSet<TagKey<Item>>();
    private Set<TagKey<Item>> tagBlacklist = new HashSet<TagKey<Item>>();
    private List<Set<ResourceLocation>> equivGroups = new ArrayList<Set<ResourceLocation>>();

    public ConversionRegistry() {
        ModCommonConfig.INSTANCE.onLoad(() -> {
            ((List)ModCommonConfig.INSTANCE.CONVERSION.tagWhitelist.get()).forEach(this::addWhitelist);
            ((List)ModCommonConfig.INSTANCE.CONVERSION.tagBlacklist.get()).forEach(this::addBlacklist);
            for (String oreType : (List)ModCommonConfig.INSTANCE.CONVERSION.oreTypes.get()) {
                for (String oreMat : (List)ModCommonConfig.INSTANCE.CONVERSION.oreMaterials.get()) {
                    this.addWhitelist(oreType + "/" + oreMat);
                }
            }
            for (String entry : (List)ModCommonConfig.INSTANCE.CONVERSION.itemEquivGroups.get()) {
                this.addEquivGroup(entry);
            }
        });
    }

    public boolean addBlacklist(String entry) {
        String[] parts = entry.split(":");
        if (parts.length != 2) {
            return false;
        }
        return this.addBlacklist(parts[0], parts[1]);
    }

    public boolean addBlacklist(String namespace, String path) {
        return this.addBlacklist(new ResourceLocation(namespace, path));
    }

    public boolean addBlacklist(ResourceLocation entry) {
        if (entry == null) {
            return false;
        }
        this.tagBlacklist.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)entry));
        return true;
    }

    public boolean addWhitelist(String entry) {
        String[] parts = entry.split(":");
        if (parts.length != 2) {
            return false;
        }
        return this.addWhitelist(parts[0], parts[1]);
    }

    public boolean addWhitelist(String namespace, String path) {
        return this.addWhitelist(new ResourceLocation(namespace, path));
    }

    public boolean addWhitelist(ResourceLocation entry) {
        if (entry == null) {
            return false;
        }
        this.tagWhitelist.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)entry));
        return true;
    }

    public void addEquivGroup(String entry) {
        String[] items = entry.split(";\\s*");
        HashSet<ResourceLocation> group = new HashSet<ResourceLocation>();
        for (String item : items) {
            String[] parts = item.split(":");
            if (parts.length != 2) continue;
            ResourceLocation key = new ResourceLocation(parts[0], parts[1]);
            group.add(key);
        }
        if (group.size() > 1) {
            this.equivGroups.add(group);
        }
    }

    public boolean itemsShareEquivGroup(Item item1, Item item2) {
        ResourceLocation key1 = BuiltInRegistries.f_257033_.m_7981_((Object)item1);
        ResourceLocation key2 = BuiltInRegistries.f_257033_.m_7981_((Object)item2);
        for (Set<ResourceLocation> group : this.equivGroups) {
            if (!group.contains(key1) || !group.contains(key2)) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getEquivItems(Item item) {
        ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Set<ResourceLocation> group : this.equivGroups) {
            if (!group.contains(key)) continue;
            for (ResourceLocation entry : group) {
                Item other = (Item)BuiltInRegistries.f_257033_.m_7745_(entry);
                items.add(new ItemStack((ItemLike)other));
            }
        }
        return items;
    }

    public boolean isEntryValid(TagKey<Item> entry) {
        if (this.tagBlacklist.contains(entry)) {
            return false;
        }
        return this.tagWhitelist.contains(entry);
    }
}

