/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IPortable;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.tooltip.DetachedDrawerTooltip;
import com.jaquadro.minecraft.storagedrawers.util.ComponentUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDetachedDrawer
extends Item
implements IPortable {
    public ItemDetachedDrawer(Item.Properties properties) {
        super(properties);
    }

    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        DetachedDrawerData data = new DetachedDrawerData();
        data.setStorageMultiplier((Integer)ModCommonConfig.INSTANCE.GENERAL.baseStackStorage.get() * 8);
        stack.m_41751_(data.serializeNBT());
        return stack;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        ComponentUtil.appendSplitDescription(tooltip, this);
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.heavyDrawers.get()).booleanValue() && this.isHeavy(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.storagedrawers.drawers.too_heavy").m_130940_(ChatFormatting.RED));
        }
    }

    public String m_5524_() {
        if (this == ModItems.DETACHED_DRAWER.get()) {
            return super.m_5524_();
        }
        return ((Item)ModItems.DETACHED_DRAWER.get()).m_5524_();
    }

    @NotNull
    public Component m_41466_() {
        return (Boolean)ModCommonConfig.INSTANCE.GENERAL.enableDetachedDrawers.get() != false ? Component.m_237115_((String)(this.m_5524_() + ".desc")) : Component.m_237115_((String)"itemConfig.storagedrawers.disabled_tool").m_130940_(ChatFormatting.RED);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        DetachedDrawerData data = new DetachedDrawerData(stack.m_41784_());
        ItemStack innerStack = data.getStoredItemPrototype().m_41777_();
        innerStack.m_41764_(data.getStoredItemCount());
        return Optional.of(new DetachedDrawerTooltip(data, innerStack, data.getStorageMultiplier()));
    }

    @Override
    public boolean isHeavy(@NotNull ItemStack stack) {
        if (stack.m_41720_() != this) {
            return false;
        }
        DetachedDrawerData data = new DetachedDrawerData(stack.m_41783_());
        return data.isHeavy() && data.getStoredItemCount() > data.getStoredItemStackSize();
    }
}

