/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.modelprops;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.DrawerModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.context.DrawerModelContext;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class ForgeDrawerModelProperties
extends DrawerModelProperties {
    public static final ForgeDrawerModelProperties INSTANCE = new ForgeDrawerModelProperties();
    public static final ModelProperty<BlockState> BLOCKSTATE = new ModelProperty();
    public static final ModelProperty<IDrawerAttributes> ATTRIBUTES = new ModelProperty();
    public static final ModelProperty<IDrawerGroup> DRAWER_GROUP = new ModelProperty();
    public static final ModelProperty<IProtectable> PROTECTABLE = new ModelProperty();
    public static final ModelProperty<MaterialData> MATERIAL = new ModelProperty();
    public final ModelData modelData;

    protected ForgeDrawerModelProperties() {
        this.modelData = ModelData.builder().build();
    }

    protected ForgeDrawerModelProperties(BlockEntityDrawers blockEntity) {
        super(blockEntity);
        this.modelData = ModelData.builder().with(ATTRIBUTES, (Object)this.attributes).with(DRAWER_GROUP, (Object)this.group).with(PROTECTABLE, (Object)this.protectable).with(MATERIAL, (Object)this.material).build();
    }

    public static ForgeDrawerModelProperties getForgeModelData(BlockEntityDrawers blockEntity) {
        return new ForgeDrawerModelProperties(blockEntity);
    }

    @Override
    public DrawerModelContext makeContext(@Nullable BlockState state, RandomSource rand, Object renderData) {
        if (renderData instanceof ModelData) {
            ModelData m = (ModelData)renderData;
            return new DrawerModelContext(state, rand).attr((IDrawerAttributes)m.get(ATTRIBUTES)).group((IDrawerGroup)m.get(DRAWER_GROUP)).protectable((IProtectable)m.get(PROTECTABLE)).materialData((MaterialData)m.get(MATERIAL));
        }
        return super.makeContext(state, rand, renderData);
    }

    @Override
    public DrawerModelContext makeContext(ItemStack stack) {
        MaterialData data = ((FrameData)stack.getOrDefault((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY)).asMaterialData();
        Block block = Blocks.AIR;
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            block = blockItem.getBlock();
        }
        return new DrawerModelContext(block.defaultBlockState()).materialData(data);
    }
}

