/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.ForgeDrawerModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.ForgeFramedModelProperties;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.PlatformDecoratedModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.DrawerModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.context.FramedModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.CombinedModelDecorator;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.DrawerModelDecorator;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.MaterialModelDecorator;
import net.minecraft.client.renderer.block.model.BlockStateModel;

public class BakedModelProvider {
    public static BlockStateModel makeStandardDrawerModel(BlockStateModel parentModel) {
        DrawerModelDecorator decorator = new DrawerModelDecorator(DrawerModelStore.INSTANCE);
        return new PlatformDecoratedModel<DrawerModelContext>(parentModel, decorator, ForgeDrawerModelProperties.INSTANCE);
    }

    public static BlockStateModel makeFramedDrawerModel(BlockStateModel parentModel, DrawerModelStore.FrameMatSet matSet) {
        CombinedModelDecorator<DrawerModelContext> decorator = new CombinedModelDecorator<DrawerModelContext>();
        decorator.add(new DrawerModelDecorator(DrawerModelStore.INSTANCE));
        decorator.add(new MaterialModelDecorator.FacingSizedSlotted(matSet, true));
        return new PlatformDecoratedModel<DrawerModelContext>(parentModel, decorator, ForgeDrawerModelProperties.INSTANCE);
    }

    public static BlockStateModel makeFramedStandardDrawerModel(BlockStateModel parentModel) {
        return BakedModelProvider.makeFramedDrawerModel(parentModel, DrawerModelStore.FramedStandardDrawerMaterials);
    }

    public static BlockStateModel makeFramedCompDrawerModel(BlockStateModel parentModel, DrawerModelStore.FrameMatSet matSet) {
        CombinedModelDecorator<DrawerModelContext> decorator = new CombinedModelDecorator<DrawerModelContext>();
        decorator.add(new DrawerModelDecorator(DrawerModelStore.INSTANCE));
        decorator.add(new MaterialModelDecorator.FacingSizedOpen(matSet, true));
        return new PlatformDecoratedModel<DrawerModelContext>(parentModel, decorator, ForgeDrawerModelProperties.INSTANCE);
    }

    public static BlockStateModel makeFramedComp2DrawerModel(BlockStateModel parentModel) {
        return BakedModelProvider.makeFramedCompDrawerModel(parentModel, DrawerModelStore.FramedComp2DrawerMaterials);
    }

    public static BlockStateModel makeFramedComp3DrawerModel(BlockStateModel parentModel) {
        return BakedModelProvider.makeFramedCompDrawerModel(parentModel, DrawerModelStore.FramedComp3DrawerMaterials);
    }

    public static BlockStateModel makeFramedTrimModel(BlockStateModel parentModel) {
        MaterialModelDecorator.Single decorator = new MaterialModelDecorator.Single(DrawerModelStore.FramedTrimMaterials, true);
        return new PlatformDecoratedModel<FramedModelContext>(parentModel, decorator, ForgeFramedModelProperties.INSTANCE);
    }

    public static BlockStateModel makeFramedControllerModel(BlockStateModel parentModel) {
        MaterialModelDecorator.Facing decorator = new MaterialModelDecorator.Facing(DrawerModelStore.FramedControllerMaterials, true);
        return new PlatformDecoratedModel<FramedModelContext>(parentModel, decorator, ForgeFramedModelProperties.INSTANCE);
    }

    public static BlockStateModel makeFramedControllerIOModel(BlockStateModel parentModel) {
        MaterialModelDecorator.Single decorator = new MaterialModelDecorator.Single(DrawerModelStore.FramedControllerIOMaterials, true);
        return new PlatformDecoratedModel<FramedModelContext>(parentModel, decorator, ForgeFramedModelProperties.INSTANCE);
    }
}

