/*
 * Decompiled with CFR 0.152.
 */
package com.agent772.createshufflefilter.mixins;

import com.agent772.createshufflefilter.CreateShuffleFilter;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FilterItem.class})
public class MixinFilterItemSummary {
    @Inject(method={"makeSummary"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceShuffleFilterSummary(ItemStack filter, CallbackInfoReturnable<List<Component>> cir) {
        if (filter.is((Item)CreateShuffleFilter.SHUFFLE_FILTER.get())) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            if (filter.isComponentsPatchEmpty()) {
                cir.setReturnValue(list);
                return;
            }
            boolean useWeightedMode = false;
            try {
                DataComponentMap components = filter.getComponents();
                String componentsStr = components.toString();
                if (componentsStr.contains("create:filter_items_respect_nbt=>")) {
                    String valueStr;
                    int startIndex = componentsStr.indexOf("create:filter_items_respect_nbt=>") + "create:filter_items_respect_nbt=>".length();
                    String remaining = componentsStr.substring(startIndex);
                    int endIndex = remaining.indexOf(44);
                    if (endIndex == -1) {
                        endIndex = remaining.indexOf(125);
                    }
                    if (endIndex == -1) {
                        endIndex = remaining.length();
                    }
                    if ((valueStr = remaining.substring(0, endIndex).trim()).equals("false")) {
                        useWeightedMode = true;
                    }
                }
            }
            catch (Exception components) {
                // empty catch block
            }
            MutableComponent modeComponent = Component.literal((String)"Mode: ").withStyle(ChatFormatting.GOLD).append((Component)(useWeightedMode ? Component.literal((String)"Weighted").withStyle(ChatFormatting.GREEN) : Component.literal((String)"Equal").withStyle(ChatFormatting.BLUE)));
            list.add(modeComponent);
            try {
                ItemStackHandler filterItems = FilterItem.getFilterItems((ItemStack)filter);
                boolean blacklist = (Boolean)filter.getOrDefault(AllDataComponents.FILTER_ITEMS_BLACKLIST, (Object)false);
                list.add((blacklist ? CreateLang.translateDirect((String)"gui.filter.deny_list", (Object[])new Object[0]) : CreateLang.translateDirect((String)"gui.filter.allow_list", (Object[])new Object[0])).withStyle(ChatFormatting.GOLD));
                int count = 0;
                for (int i = 0; i < filterItems.getSlots(); ++i) {
                    if (count > 3) {
                        list.add(Component.literal((String)"- ...").withStyle(ChatFormatting.DARK_GRAY));
                        break;
                    }
                    ItemStack filterStack = filterItems.getStackInSlot(i);
                    if (filterStack.isEmpty()) continue;
                    list.add(Component.literal((String)"- ").append(filterStack.getHoverName()).withStyle(ChatFormatting.GRAY));
                    ++count;
                }
                if (count == 0) {
                    cir.setReturnValue(Collections.singletonList(modeComponent));
                    return;
                }
            }
            catch (Exception e) {
                cir.setReturnValue(Collections.singletonList(modeComponent));
                return;
            }
            cir.setReturnValue(list);
        }
    }
}

