/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.block.redstone;

import net.caffeinemc.mods.lithium.common.util.DirectionConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;

public class RedstoneWirePowerCalculations {
    private static final int MIN = 0;
    private static final int MAX = 15;
    private static final int MAX_WIRE = 14;

    public static int getNeighborBlockSignal(Block wireBlock, RedstoneWireEvaluator evaluator, Level level, BlockPos pos) {
        return RedstoneWirePowerCalculations.getNeighborSignal(wireBlock, evaluator, level, pos, false, true);
    }

    public static int getNeighborWireSignal(Block wireBlock, RedstoneWireEvaluator evaluator, Level level, BlockPos pos) {
        return RedstoneWirePowerCalculations.getNeighborSignal(wireBlock, evaluator, level, pos, true, false);
    }

    public static int getNeighborSignal(Block wireBlock, RedstoneWireEvaluator evaluator, Level level, BlockPos pos, boolean ignoreNonWires, boolean ignoreWires) {
        int signal = 0;
        LevelChunk chunk = level.getChunkAt(pos);
        if (!ignoreNonWires) {
            for (Direction dir : DirectionConstants.VERTICAL) {
                BlockPos side = pos.relative(dir);
                BlockState neighbor = chunk.getBlockState(side);
                if (neighbor.isAir() || neighbor.is(wireBlock) || (signal = Math.max(signal, RedstoneWirePowerCalculations.getSignalFromVertical(level, side, neighbor, dir, wireBlock))) < 15) continue;
                return 15;
            }
        }
        boolean checkWiresAbove = false;
        if (!ignoreWires) {
            BlockPos above = pos.above();
            checkWiresAbove = !chunk.getBlockState(above).isRedstoneConductor((BlockGetter)level, above);
        }
        for (Direction dir : DirectionConstants.HORIZONTAL) {
            if ((signal = Math.max(signal, RedstoneWirePowerCalculations.getSignalFromSide(level, pos.relative(dir), dir, checkWiresAbove, ignoreNonWires, ignoreWires, wireBlock, evaluator))) < 15) continue;
            return 15;
        }
        return signal;
    }

    private static int getSignalFromVertical(Level level, BlockPos pos, BlockState state, Direction toDir, Block wireBlock) {
        int signal = state.getSignal((BlockGetter)level, pos, toDir);
        if (signal >= 15) {
            return 15;
        }
        if (state.isRedstoneConductor((BlockGetter)level, pos)) {
            return Math.max(signal, RedstoneWirePowerCalculations.getDirectSignalTo(level, pos, toDir.getOpposite(), wireBlock));
        }
        return signal;
    }

    private static int getSignalFromSide(Level level, BlockPos pos, Direction toDir, boolean checkWiresAbove, boolean ignoreNonWires, boolean ignoreWires, Block wireBlock, RedstoneWireEvaluator evaluator) {
        BlockPos below;
        BlockState belowState;
        LevelChunk chunk = level.getChunkAt(pos);
        BlockState state = chunk.getBlockState(pos);
        if (state.is(wireBlock)) {
            return !ignoreWires ? evaluator.getWireSignal(pos, state) - 1 : 0;
        }
        int signal = 0;
        if (!ignoreNonWires && (signal = state.getSignal((BlockGetter)level, pos, toDir)) >= 15) {
            return 15;
        }
        if (state.isRedstoneConductor((BlockGetter)level, pos)) {
            BlockPos above;
            BlockState aboveState;
            if (!ignoreNonWires && (signal = Math.max(signal, RedstoneWirePowerCalculations.getDirectSignalTo(level, pos, toDir.getOpposite(), wireBlock))) >= 15) {
                return 15;
            }
            if (!ignoreWires && checkWiresAbove && signal < 14 && (aboveState = chunk.getBlockState(above = pos.above())).is(wireBlock)) {
                signal = Math.max(signal, evaluator.getWireSignal(above, aboveState) - 1);
            }
        } else if (!ignoreWires && signal < 14 && (belowState = chunk.getBlockState(below = pos.below())).is(wireBlock)) {
            signal = Math.max(signal, evaluator.getWireSignal(below, belowState) - 1);
        }
        return signal;
    }

    private static int getDirectSignalTo(Level level, BlockPos pos, Direction ignore, Block wireBlock) {
        int signal = 0;
        for (Direction dir : DirectionConstants.ALL) {
            BlockPos side;
            BlockState neighbor;
            if (dir == ignore || (neighbor = level.getBlockState(side = pos.relative(dir))).isAir() || neighbor.is(wireBlock) || (signal = Math.max(signal, neighbor.getDirectSignal((BlockGetter)level, side, dir))) < 15) continue;
            return 15;
        }
        return signal;
    }
}

