/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.hopper;

import net.caffeinemc.mods.lithium.api.inventory.LithiumDefaultedList;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import net.caffeinemc.mods.lithium.common.hopper.ComparatorUpdatePattern;
import net.caffeinemc.mods.lithium.common.hopper.HopperHelper;
import net.caffeinemc.mods.lithium.common.hopper.LithiumDoubleStackList;
import net.caffeinemc.mods.lithium.common.util.change_tracking.ChangePublisher;
import net.caffeinemc.mods.lithium.common.util.change_tracking.ChangeSubscriber;
import net.caffeinemc.mods.lithium.mixin.block.hopper.NonNullListAccessor;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LithiumStackList
extends NonNullList<ItemStack>
implements LithiumDefaultedList,
ChangeSubscriber.CountChangeSubscriber<ItemStack> {
    final int maxCountPerStack;
    protected int cachedSignalStrength;
    private ComparatorUpdatePattern cachedComparatorUpdatePattern;
    private boolean signalStrengthOverride;
    private long modCount;
    private int occupiedSlots;
    private int fullSlots;
    LithiumDoubleStackList parent;
    InventoryChangeTracker inventoryModificationCallback;

    public LithiumStackList(NonNullList<ItemStack> original, int maxCountPerStack) {
        super(((NonNullListAccessor)original).getDelegate(), (Object)ItemStack.EMPTY);
        this.maxCountPerStack = maxCountPerStack;
        this.cachedSignalStrength = -1;
        this.cachedComparatorUpdatePattern = null;
        this.modCount = 0L;
        this.signalStrengthOverride = false;
        this.occupiedSlots = 0;
        this.fullSlots = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = (ItemStack)this.get(i);
            if (stack.isEmpty()) continue;
            ++this.occupiedSlots;
            if (stack.getMaxStackSize() <= stack.getCount()) {
                ++this.fullSlots;
            }
            ((ChangePublisher)stack).lithium$subscribe(this, i);
        }
        this.inventoryModificationCallback = null;
    }

    public LithiumStackList(int maxCountPerStack) {
        super(null, (Object)ItemStack.EMPTY);
        this.maxCountPerStack = maxCountPerStack;
        this.cachedSignalStrength = -1;
        this.inventoryModificationCallback = null;
    }

    public long getModCount() {
        return this.modCount;
    }

    public void changedALot() {
        ItemStack stack;
        int i;
        this.changed();
        this.occupiedSlots = 0;
        this.fullSlots = 0;
        int size = this.size();
        for (i = 0; i < size; ++i) {
            stack = (ItemStack)this.get(i);
            if (stack.isEmpty()) continue;
            ++this.occupiedSlots;
            if (stack.getMaxStackSize() <= stack.getCount()) {
                ++this.fullSlots;
            }
            ((ChangePublisher)stack).lithium$unsubscribe(this);
        }
        for (i = 0; i < size; ++i) {
            stack = (ItemStack)this.get(i);
            if (stack.isEmpty()) continue;
            ((ChangePublisher)stack).lithium$subscribe(this, i);
        }
    }

    public void changed() {
        this.cachedSignalStrength = -1;
        this.cachedComparatorUpdatePattern = null;
        ++this.modCount;
        InventoryChangeTracker inventoryModificationCallback = this.inventoryModificationCallback;
        if (inventoryModificationCallback != null) {
            this.inventoryModificationCallback = null;
            inventoryModificationCallback.lithium$emitContentModified();
        }
    }

    public ItemStack set(int index, ItemStack element) {
        boolean isSubscribed;
        ItemStack previous = (ItemStack)super.set(index, (Object)element);
        if (previous == element && !element.isEmpty() && !(isSubscribed = ((ChangePublisher)previous).lithium$isSubscribedWithData(this, index))) {
            previous = ItemStack.EMPTY;
        }
        if (previous != element) {
            if (!previous.isEmpty()) {
                ((ChangePublisher)previous).lithium$unsubscribeWithData(this, index);
            }
            if (!element.isEmpty()) {
                ((ChangePublisher)element).lithium$subscribe(this, index);
            }
            this.occupiedSlots += (previous.isEmpty() ? 1 : 0) - (element.isEmpty() ? 1 : 0);
            this.fullSlots += (element.getCount() >= element.getMaxStackSize() ? 1 : 0) - (previous.getCount() >= previous.getMaxStackSize() ? 1 : 0);
            this.changed();
        }
        return previous;
    }

    public void add(int slot, ItemStack element) {
        super.add(slot, (Object)element);
        if (!element.isEmpty()) {
            ((ChangePublisher)element).lithium$subscribe(this, this.indexOf(element));
        }
        this.changedALot();
    }

    public ItemStack remove(int index) {
        ItemStack previous = (ItemStack)super.remove(index);
        if (!previous.isEmpty()) {
            ((ChangePublisher)previous).lithium$unsubscribeWithData(this, index);
        }
        this.changedALot();
        return previous;
    }

    public void clear() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = (ItemStack)this.get(i);
            if (stack.isEmpty()) continue;
            ((ChangePublisher)stack).lithium$unsubscribeWithData(this, i);
        }
        super.clear();
        this.changedALot();
    }

    public boolean hasSignalStrengthOverride() {
        return this.signalStrengthOverride;
    }

    public int getSignalStrength(Container inventory) {
        if (this.signalStrengthOverride) {
            return 0;
        }
        int signalStrength = this.cachedSignalStrength;
        if (signalStrength == -1) {
            this.cachedSignalStrength = this.calculateSignalStrength(inventory.getContainerSize());
            return this.cachedSignalStrength;
        }
        return signalStrength;
    }

    int calculateSignalStrength(int inventorySize) {
        int i = 0;
        float f = 0.0f;
        inventorySize = Math.min(inventorySize, this.size());
        for (int j = 0; j < inventorySize; ++j) {
            ItemStack itemStack = (ItemStack)this.get(j);
            if (itemStack.isEmpty()) continue;
            f += (float)itemStack.getCount() / (float)Math.min(this.maxCountPerStack, itemStack.getMaxStackSize());
            ++i;
        }
        return Mth.floor((float)((f /= (float)inventorySize) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public void setReducedSignalStrengthOverride() {
        this.signalStrengthOverride = true;
    }

    public void clearSignalStrengthOverride() {
        this.signalStrengthOverride = false;
    }

    public void runComparatorUpdatePatternOnFailedExtract(LithiumStackList masterStackList, Container inventory) {
        if (inventory instanceof BlockEntity) {
            if (this.cachedComparatorUpdatePattern == null) {
                this.cachedComparatorUpdatePattern = HopperHelper.determineComparatorUpdatePattern(inventory, masterStackList);
            }
            this.cachedComparatorUpdatePattern.apply((BlockEntity)inventory, masterStackList);
        }
    }

    public boolean maybeSendsComparatorUpdatesOnFailedExtract() {
        return this.cachedComparatorUpdatePattern == null || this.cachedComparatorUpdatePattern != ComparatorUpdatePattern.NO_UPDATE;
    }

    public int getOccupiedSlots() {
        return this.occupiedSlots;
    }

    public int getFullSlots() {
        return this.fullSlots;
    }

    @Override
    public void changedInteractionConditions() {
        this.changed();
    }

    public void setInventoryModificationCallback(@NotNull InventoryChangeTracker inventoryModificationCallback) {
        if (this.inventoryModificationCallback != null && this.inventoryModificationCallback != inventoryModificationCallback) {
            this.inventoryModificationCallback.emitCallbackReplaced();
        }
        this.inventoryModificationCallback = inventoryModificationCallback;
    }

    public void removeInventoryModificationCallback(@NotNull InventoryChangeTracker inventoryModificationCallback) {
        if (this.inventoryModificationCallback != null && this.inventoryModificationCallback == inventoryModificationCallback) {
            this.inventoryModificationCallback = null;
        }
    }

    @Override
    public void lithium$notify(@Nullable ItemStack publisher, int subscriberData) {
    }

    @Override
    public void lithium$forceUnsubscribe(ItemStack publisher, int subscriberData) {
        throw new UnsupportedOperationException("Cannot force unsubscribe on a LithiumStackList!");
    }

    @Override
    public void lithium$notifyCount(ItemStack stack, int index, int newCount) {
        assert (stack == this.get(index));
        int count = stack.getCount();
        if (newCount <= 0) {
            ((ChangePublisher)stack).lithium$unsubscribeWithData(this, index);
        }
        int maxCount = stack.getMaxStackSize();
        this.occupiedSlots -= newCount <= 0 ? 1 : 0;
        this.fullSlots += (newCount >= maxCount ? 1 : 0) - (count >= maxCount ? 1 : 0);
        this.changed();
    }
}

