/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.caffeinemc.mods.lithium.common.shapes.VoxelShapeAlignedCuboid;
import net.caffeinemc.mods.lithium.common.shapes.lists.OffsetFractionalDoubleList;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeAlignedCuboidOffset
extends VoxelShapeAlignedCuboid {
    private final double xOffset;
    private final double yOffset;
    private final double zOffset;

    public VoxelShapeAlignedCuboidOffset(VoxelShapeAlignedCuboid originalShape, DiscreteVoxelShape voxels, double xOffset, double yOffset, double zOffset) {
        super(voxels, originalShape.minX + xOffset, originalShape.minY + yOffset, originalShape.minZ + zOffset, originalShape.maxX + xOffset, originalShape.maxY + yOffset, originalShape.maxZ + zOffset, originalShape.xyzResolution);
        if (originalShape instanceof VoxelShapeAlignedCuboidOffset) {
            this.xOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).xOffset + xOffset;
            this.yOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).yOffset + yOffset;
            this.zOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).zOffset + zOffset;
        } else {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
        }
    }

    @Override
    public VoxelShape move(double x, double y, double z) {
        return new VoxelShapeAlignedCuboidOffset(this, this.shape, x, y, z);
    }

    @Override
    public double collideX(AxisCycle cycleDirection, AABB box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(AxisCycle dir, AABB box, double maxDist) {
        switch (dir) {
            case NONE: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minX, this.maxX, this.getXSegments(), this.xOffset, box.minX, box.maxX, maxDist);
            }
            case FORWARD: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minZ, this.maxZ, this.getZSegments(), this.zOffset, box.minZ, box.maxZ, maxDist);
            }
            case BACKWARD: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minY, this.maxY, this.getYSegments(), this.yOffset, box.minY, box.maxY, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    private static double calculatePenetration(double aMin, double aMax, int segmentsPerUnit, double shapeOffset, double bMin, double bMax, double maxDist) {
        if (maxDist > 0.0) {
            double gap = aMin - bMax;
            if (gap >= -1.0E-7) {
                return Math.min(gap, maxDist);
            }
            if (segmentsPerUnit == 1) {
                return maxDist;
            }
            int segment = Mth.ceil((double)((bMax - 1.0E-6 - shapeOffset) * (double)segmentsPerUnit));
            double wallPos = (double)segment / (double)segmentsPerUnit + shapeOffset;
            if (wallPos < bMax - 1.0E-7) {
                wallPos = (double)(++segment) / (double)segmentsPerUnit + shapeOffset;
            }
            if (wallPos < aMax - 1.0E-6) {
                return Math.min(maxDist, wallPos - bMax);
            }
            return maxDist;
        }
        double gap = aMax - bMin;
        if (gap <= 1.0E-7) {
            return Math.max(gap, maxDist);
        }
        if (segmentsPerUnit == 1) {
            return maxDist;
        }
        int segment = Mth.floor((double)((bMin + 1.0E-6 - shapeOffset) * (double)segmentsPerUnit));
        double wallPos = (double)segment / (double)segmentsPerUnit + shapeOffset;
        if (wallPos > bMin + 1.0E-7) {
            wallPos = (double)(--segment) / (double)segmentsPerUnit + shapeOffset;
        }
        if (wallPos > aMin + 1.0E-6) {
            return Math.max(maxDist, wallPos - bMin);
        }
        return maxDist;
    }

    @Override
    public DoubleList getCoords(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> new OffsetFractionalDoubleList(this.getXSegments(), this.xOffset);
            case Direction.Axis.Y -> new OffsetFractionalDoubleList(this.getYSegments(), this.yOffset);
            case Direction.Axis.Z -> new OffsetFractionalDoubleList(this.getZSegments(), this.zOffset);
        };
    }

    @Override
    protected double get(Direction.Axis axis, int index) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> this.xOffset + (double)index / (double)this.getXSegments();
            case Direction.Axis.Y -> this.yOffset + (double)index / (double)this.getYSegments();
            case Direction.Axis.Z -> this.zOffset + (double)index / (double)this.getZSegments();
        };
    }

    @Override
    protected int findIndex(Direction.Axis axis, double coord) {
        int numSegments;
        coord = switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                numSegments = this.getXSegments();
                yield (coord - this.xOffset) * (double)numSegments;
            }
            case Direction.Axis.Y -> {
                numSegments = this.getYSegments();
                yield (coord - this.yOffset) * (double)numSegments;
            }
            case Direction.Axis.Z -> {
                numSegments = this.getZSegments();
                yield (coord - this.zOffset) * (double)numSegments;
            }
        };
        return Mth.clamp((int)Mth.floor((double)coord), (int)-1, (int)numSegments);
    }
}

