/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.world.block_pattern_matching;

import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.minecraft.core.BlockBox;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class BlockSearch {
    public static boolean hasAtLeast(LevelReader levelReader, BlockBox searchBox, Block requiredBlock, int requiredBlockCount) {
        Predicate<BlockState> predicate = blockState -> blockState.is(requiredBlock);
        for (int chunkX = SectionPos.blockToSectionCoord((int)searchBox.min().getX()); chunkX <= SectionPos.blockToSectionCoord((int)searchBox.max().getX()); ++chunkX) {
            for (int chunkZ = SectionPos.blockToSectionCoord((int)searchBox.min().getZ()); chunkZ <= SectionPos.blockToSectionCoord((int)searchBox.max().getZ()); ++chunkZ) {
                ChunkAccess chunk = levelReader.getChunk(chunkX, chunkZ);
                int minSectionYIndex = Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)levelReader, searchBox.min().getY());
                int maxSectionYIndex = Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)levelReader, searchBox.max().getY());
                for (int sectionYIndex = minSectionYIndex; sectionYIndex <= maxSectionYIndex; ++sectionYIndex) {
                    if (sectionYIndex >= 0 && sectionYIndex < chunk.getSectionsCount()) {
                        LevelChunkSection section = chunk.getSection(sectionYIndex);
                        if (!section.maybeHas(predicate)) continue;
                        int sectionYCoord = Pos.SectionYCoord.fromSectionIndex((LevelHeightAccessor)levelReader, sectionYIndex);
                        if ((requiredBlockCount -= BlockSearch.countBlocksInBoxInSection(section, Math.max(searchBox.min().getX(), chunkX << 4), Math.max(searchBox.min().getY(), sectionYCoord << 4), Math.max(searchBox.min().getZ(), chunkZ << 4), Math.min(searchBox.max().getX(), (chunkX << 4) + 15), Math.min(searchBox.max().getY(), (sectionYCoord << 4) + 15), Math.min(searchBox.max().getZ(), (chunkZ << 4) + 15), requiredBlock, requiredBlockCount)) > 0) continue;
                        return true;
                    }
                    if (requiredBlock != Blocks.VOID_AIR) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int countBlocksInBoxInSection(LevelChunkSection section, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block requiredBlock, int findMax) {
        int found = 0;
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    if (!section.getBlockState(x & 0xF, y & 0xF, z & 0xF).is(requiredBlock) || ++found < findMax) continue;
                    return found;
                }
            }
        }
        return found;
    }
}

