/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.world.listeners;

import java.util.WeakHashMap;
import net.caffeinemc.mods.lithium.common.world.listeners.WorldBorderListenerOnce;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import org.jetbrains.annotations.NotNull;

public class WorldBorderPositionListenerMulti
implements BorderChangeListener {
    private final WeakHashMap<WorldBorderListenerOnce, Object> delegate = new WeakHashMap();

    public void add(WorldBorderListenerOnce listener) {
        this.delegate.put(listener, null);
    }

    public void onAreaReplaced(WorldBorder border) {
        for (WorldBorderListenerOnce listener : this.delegate.keySet()) {
            listener.onAreaReplaced(border);
        }
        this.delegate.clear();
    }

    public void onSetSize(@NotNull WorldBorder border, double size) {
        for (WorldBorderListenerOnce listener : this.delegate.keySet()) {
            listener.onSetSize(border, size);
        }
        this.delegate.clear();
    }

    public void onLerpSize(@NotNull WorldBorder border, double fromSize, double toSize, long time) {
        for (WorldBorderListenerOnce listener : this.delegate.keySet()) {
            listener.onLerpSize(border, fromSize, toSize, time);
        }
        this.delegate.clear();
    }

    public void onSetCenter(@NotNull WorldBorder border, double centerX, double centerZ) {
        for (WorldBorderListenerOnce listener : this.delegate.keySet()) {
            listener.onSetCenter(border, centerX, centerZ);
        }
        this.delegate.clear();
    }

    public void onSetWarningTime(@NotNull WorldBorder border, int warningTime) {
    }

    public void onSetWarningBlocks(@NotNull WorldBorder border, int warningBlockDistance) {
    }

    public void onSetDamagePerBlock(@NotNull WorldBorder border, double damagePerBlock) {
    }

    public void onSetSafeZone(@NotNull WorldBorder border, double safeZoneRadius) {
    }
}

