/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.sensor.replace_streams.tempting;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.TemptingSensor;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={TemptingSensor.class})
public abstract class TemptingSensorMixin {
    @Shadow
    @Final
    private static TargetingConditions TEMPT_TARGETING;

    @Shadow
    protected abstract boolean playerHoldingTemptation(Player var1);

    @Overwrite
    public void doTick(ServerLevel serverLevel, PathfinderMob pathfinderMob) {
        Brain brain = pathfinderMob.getBrain();
        TargetingConditions targetingConditions = TEMPT_TARGETING.copy().range((double)((float)pathfinderMob.getAttributeValue(Attributes.TEMPT_RANGE)));
        ServerPlayer closestPlayer = null;
        double minDist = Double.MAX_VALUE;
        for (ServerPlayer serverPlayer : serverLevel.players()) {
            double dist;
            if (!EntitySelector.NO_SPECTATORS.test(serverPlayer) || !targetingConditions.test(serverLevel, (LivingEntity)pathfinderMob, (LivingEntity)serverPlayer) || !this.playerHoldingTemptation((Player)serverPlayer) || pathfinderMob.hasPassenger((Entity)serverPlayer) || !((dist = pathfinderMob.distanceToSqr((Entity)serverPlayer)) < minDist)) continue;
            minDist = dist;
            closestPlayer = serverPlayer;
        }
        if (closestPlayer != null) {
            brain.setMemory(MemoryModuleType.TEMPTING_PLAYER, closestPlayer);
        } else {
            brain.eraseMemory(MemoryModuleType.TEMPTING_PLAYER);
        }
    }
}

