/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.world.explosions.entity_raycast;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.function.BiFunction;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.caffeinemc.mods.lithium.common.world.explosions.ClipContextAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerExplosion.class})
public class ServerExplosionMixin {
    @Unique
    private static final BlockHitResult MISS = BlockHitResult.miss(null, null, null);

    @Inject(method={"getSeenPercent"}, at={@At(value="HEAD")})
    private static void createMutableContext(Vec3 to, Entity entity, CallbackInfoReturnable<Float> cir, @Share(value="blockHitFactory") LocalRef<BiFunction<ClipContext, BlockPos, BlockHitResult>> hitFactoryRef) {
        hitFactoryRef.set(ServerExplosionMixin.blockHitFactory(entity));
    }

    @Redirect(method={"getSeenPercent"}, at=@At(value="NEW", target="net/minecraft/world/level/ClipContext"))
    private static ClipContext reuseClipContext(Vec3 from, Vec3 to, ClipContext.Block block, ClipContext.Fluid fluid, Entity entity, @Share(value="context") LocalRef<ClipContext> contextRef) {
        ClipContext clipContext = (ClipContext)contextRef.get();
        if (clipContext == null) {
            clipContext = new ClipContext(from, to, block, fluid, entity);
            contextRef.set((Object)clipContext);
        } else {
            ((ClipContextAccess)clipContext).lithium$setFrom(from);
        }
        return clipContext;
    }

    @Redirect(method={"getSeenPercent"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;clip(Lnet/minecraft/world/level/ClipContext;)Lnet/minecraft/world/phys/BlockHitResult;"))
    private static BlockHitResult simplifyRaycast(Level level, ClipContext clipContext, @Share(value="blockHitFactory") LocalRef<BiFunction<ClipContext, BlockPos, BlockHitResult>> hitFactoryRef) {
        return (BlockHitResult)BlockGetter.traverseBlocks((Vec3)clipContext.getFrom(), (Vec3)clipContext.getTo(), (Object)clipContext, (BiFunction)((BiFunction)hitFactoryRef.get()), ctx -> MISS);
    }

    @Unique
    private static BiFunction<ClipContext, BlockPos, BlockHitResult> blockHitFactory(final Entity entity) {
        return new BiFunction<ClipContext, BlockPos, BlockHitResult>(){
            final Level level;
            int chunkX;
            int chunkZ;
            ChunkAccess chunk;
            {
                this.level = entity.level();
                this.chunkX = Integer.MIN_VALUE;
                this.chunkZ = Integer.MIN_VALUE;
                this.chunk = null;
            }

            @Override
            public BlockHitResult apply(ClipContext clipContext, BlockPos blockPos) {
                BlockState state = this.getBlock((LevelReader)this.level, blockPos);
                return state.getCollisionShape((BlockGetter)this.level, blockPos, ((ClipContextAccess)clipContext).lithium$getCollisionContext()).clip(clipContext.getFrom(), clipContext.getTo(), blockPos);
            }

            private BlockState getBlock(LevelReader world, BlockPos blockPos) {
                LevelChunkSection section;
                ChunkAccess chunk;
                if (world.isOutsideBuildHeight(blockPos.getY())) {
                    return Blocks.VOID_AIR.defaultBlockState();
                }
                int chunkX = Pos.ChunkCoord.fromBlockCoord(blockPos.getX());
                int chunkZ = Pos.ChunkCoord.fromBlockCoord(blockPos.getZ());
                if (this.chunkX != chunkX || this.chunkZ != chunkZ) {
                    this.chunk = world.getChunk(chunkX, chunkZ);
                    this.chunkX = chunkX;
                    this.chunkZ = chunkZ;
                }
                if ((chunk = this.chunk) != null && (section = chunk.getSections()[Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)chunk, blockPos.getY())]) != null && !section.hasOnlyAir()) {
                    return section.getBlockState(blockPos.getX() & 0xF, blockPos.getY() & 0xF, blockPos.getZ() & 0xF);
                }
                return Blocks.AIR.defaultBlockState();
            }
        };
    }
}

