/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.ai.non_poi_block_search;

import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.util.collections.FixedChunkAccessSectionBitBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class CheckAndCacheBlockChecker {
    private final FixedChunkAccessSectionBitBuffer chunkSections2MaybeContainsMatchingBlock;
    private final LevelReader levelReader;
    public final boolean shouldChunkLoad;
    public final Predicate<BlockState> blockStatePredicate;
    private int unloadedPossibleChunkSections = 0;
    public final int minSectionY;

    public CheckAndCacheBlockChecker(BlockPos origin, int horizontalRangeInclusive, int verticalRangeInclusive, LevelReader levelReader, Predicate<BlockState> blockStatePredicate, boolean shouldChunkLoad) {
        this.chunkSections2MaybeContainsMatchingBlock = new FixedChunkAccessSectionBitBuffer(origin, horizontalRangeInclusive, verticalRangeInclusive);
        this.levelReader = levelReader;
        this.shouldChunkLoad = shouldChunkLoad;
        this.blockStatePredicate = blockStatePredicate;
        this.minSectionY = levelReader.getMinSectionY();
    }

    public void initializeChunks() {
        this.initializeChunks(null);
    }

    public void initializeChunks(Consumer<Long> chunkCollector) {
        boolean nullChunkCollector = chunkCollector == null;
        LongIterator longIterator = this.chunkSections2MaybeContainsMatchingBlock.getChunkPosInRange().iterator();
        while (longIterator.hasNext()) {
            long chunkPos = (Long)longIterator.next();
            int x = ChunkPos.getX((long)chunkPos);
            int z = ChunkPos.getZ((long)chunkPos);
            boolean chunkMaybeHas = false;
            ChunkAccess chunkAccess = this.levelReader.getChunk(x, z, ChunkStatus.FULL, false);
            if (chunkAccess != null) {
                this.chunkSections2MaybeContainsMatchingBlock.setChunkAccess(chunkPos, chunkAccess);
                var10_9 = this.chunkSections2MaybeContainsMatchingBlock.getSectionYInRange().iterator();
                while (var10_9.hasNext()) {
                    y = (Integer)var10_9.next();
                    chunkMaybeHas = this.checkChunkSection(chunkAccess, x, y, z) || chunkMaybeHas;
                }
            } else if (this.shouldChunkLoad) {
                var10_9 = this.chunkSections2MaybeContainsMatchingBlock.getSectionYInRange().iterator();
                while (var10_9.hasNext()) {
                    y = (Integer)var10_9.next();
                    this.chunkSections2MaybeContainsMatchingBlock.setChunkSectionStatus(SectionPos.asLong((int)x, (int)y, (int)z), !this.levelReader.isOutsideBuildHeight(SectionPos.sectionToBlockCoord((int)y)));
                    ++this.unloadedPossibleChunkSections;
                }
                chunkMaybeHas = true;
            }
            if (nullChunkCollector || !chunkMaybeHas) continue;
            chunkCollector.accept(chunkPos);
        }
    }

    public int getChunkSize() {
        return this.chunkSections2MaybeContainsMatchingBlock.numChunks;
    }

    public boolean hasUnloadedPossibleChunks() {
        return this.unloadedPossibleChunkSections > 0;
    }

    private boolean checkChunkSection(ChunkAccess chunkAccess, int chunkX, int chunkY, int chunkZ) {
        int chunkSectionYIndex = chunkY - this.minSectionY;
        LevelChunkSection[] chunkSections = chunkAccess.getSections();
        if (chunkSectionYIndex >= 0 && chunkSectionYIndex < chunkSections.length && chunkSections[chunkSectionYIndex].maybeHas(this.blockStatePredicate)) {
            this.chunkSections2MaybeContainsMatchingBlock.setChunkSectionStatus(SectionPos.asLong((int)chunkX, (int)chunkY, (int)chunkZ), true);
            return true;
        }
        return false;
    }

    public boolean checkCachedSection(int chunkX, int chunkY, int chunkZ) {
        return this.chunkSections2MaybeContainsMatchingBlock.getChunkSectionBit(chunkX, chunkY, chunkZ);
    }

    public ChunkAccess getCachedChunkAccess(long chunkPos) {
        return this.chunkSections2MaybeContainsMatchingBlock.getChunkAccess(chunkPos);
    }

    public ChunkAccess getCachedChunkAccess(BlockPos blockPos) {
        return this.chunkSections2MaybeContainsMatchingBlock.getChunkAccess(blockPos);
    }

    public boolean shouldStop() {
        return this.chunkSections2MaybeContainsMatchingBlock.hasNoTrueChunkSections();
    }

    public boolean checkPosition(BlockPos blockPos) {
        if (!this.chunkSections2MaybeContainsMatchingBlock.getChunkSectionBit(blockPos)) {
            return false;
        }
        ChunkAccess chunkAccess = this.chunkSections2MaybeContainsMatchingBlock.getChunkAccess(blockPos);
        if (chunkAccess == null) {
            if (!this.shouldChunkLoad) {
                return false;
            }
            int chunkX = SectionPos.blockToSectionCoord((int)blockPos.getX());
            int chunkY = SectionPos.blockToSectionCoord((int)blockPos.getY());
            int chunkZ = SectionPos.blockToSectionCoord((int)blockPos.getZ());
            chunkAccess = this.levelReader.getChunk(chunkX, chunkZ, ChunkStatus.FULL, true);
            assert (chunkAccess != null);
            this.chunkSections2MaybeContainsMatchingBlock.setChunkAccess(blockPos, chunkAccess);
            if (!this.checkChunkSection(chunkAccess, chunkX, chunkY, chunkZ)) {
                --this.unloadedPossibleChunkSections;
                return false;
            }
        }
        return this.blockStatePredicate.test(chunkAccess.getBlockState(blockPos));
    }
}

