/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;

public class Distances {
    public static double getMinChunkToBlockDistanceL2Sq(BlockPos origin, int chunkX, int chunkZ) {
        int zDistance;
        int chunkMinX = SectionPos.sectionToBlockCoord((int)chunkX);
        int chunkMinZ = SectionPos.sectionToBlockCoord((int)chunkZ);
        int xDistance = origin.getX() - chunkMinX;
        if (xDistance > 0) {
            xDistance = Math.max(0, xDistance - 15);
        }
        if ((zDistance = origin.getZ() - chunkMinZ) > 0) {
            zDistance = Math.max(0, zDistance - 15);
        }
        return xDistance * xDistance + zDistance * zDistance;
    }

    public static boolean isWithinSquareRadius(BlockPos origin, int radius, BlockPos pos) {
        return Math.abs(pos.getX() - origin.getX()) <= radius && Math.abs(pos.getZ() - origin.getZ()) <= radius;
    }

    public static boolean isWithinCircleRadius(BlockPos origin, double radiusSq, BlockPos pos) {
        return origin.distSqr((Vec3i)pos) <= radiusSq;
    }

    public static int getClosestAlongSectionAxis(int originAxis, int chunkMinAxis) {
        return Math.min(Math.max(originAxis, chunkMinAxis), chunkMinAxis + 15);
    }

    public static long getClosestPositionWithinChunk(BlockPos origin, int chunkX, int chunkZ) {
        int chunkMinX = SectionPos.sectionToBlockCoord((int)chunkX);
        int chunkMinZ = SectionPos.sectionToBlockCoord((int)chunkZ);
        return BlockPos.asLong((int)Distances.getClosestAlongSectionAxis(origin.getX(), chunkMinX), (int)origin.getY(), (int)Distances.getClosestAlongSectionAxis(origin.getZ(), chunkMinZ));
    }
}

