/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.world.section;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Arrays;
import net.caffeinemc.mods.lithium.common.block.BlockCountingSection;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlagHolder;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlags;
import net.caffeinemc.mods.lithium.common.world.section.LithiumSectionData;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class RandomTickingSectionDataHelper {
    public static final int MINISECTION_SIZE = 248;
    public static final int MINISECTION_BITS = Mth.ceillog2((int)248);
    public static final int MINISECTION_COUNT = Mth.ceil((float)16.516129f);
    public static final int MINISECTIONS_PER_BYTE = 8 / MINISECTION_BITS;
    public static final int BYTE_COUNT = Mth.ceil((float)((float)MINISECTION_COUNT / (float)MINISECTIONS_PER_BYTE));
    public static final int RANDOM_TICKING_FLAG_MASK = 1 << BlockStateFlags.RANDOM_TICKING.getIndex();

    public static void naiveInitializeData(LevelChunkSection section, byte[] data) {
        if (data.length != BYTE_COUNT) {
            throw new IllegalArgumentException("Invalid data length: " + data.length + ", expected " + BYTE_COUNT);
        }
        Arrays.fill(data, 0, BYTE_COUNT, (byte)0);
        if (!section.maybeHas(blockState -> blockState.isRandomlyTicking() || blockState.getFluidState().isRandomlyTicking())) {
            return;
        }
        PalettedContainer states = section.getStates();
        for (int blockIndex = 0; blockIndex < 4096; ++blockIndex) {
            int byteIndex;
            BlockState blockState2 = (BlockState)states.get(RandomTickingSectionDataHelper.unpackX(blockIndex), RandomTickingSectionDataHelper.unpackY(blockIndex), RandomTickingSectionDataHelper.unpackZ(blockIndex));
            if ((((BlockStateFlagHolder)blockState2).lithium$getAllFlags() & RANDOM_TICKING_FLAG_MASK) == 0) continue;
            int n = byteIndex = blockIndex / 248;
            data[n] = (byte)(data[n] + 1);
        }
    }

    public static void randomTickNthBlock(LevelChunkSection section, int randomBlockIndex, byte[] data, ServerLevel level, int sectionBlockX, int sectionBlockY, int sectionBlockZ, RandomSource random) {
        int countInMinisection;
        assert (data.length == BYTE_COUNT);
        assert ((sectionBlockX & 0xF) == 0);
        assert ((sectionBlockY & 0xF) == 0);
        assert ((sectionBlockZ & 0xF) == 0);
        for (int minisectionIndex = 0; minisectionIndex < data.length && randomBlockIndex >= (countInMinisection = Byte.toUnsignedInt(data[minisectionIndex])); randomBlockIndex -= countInMinisection, ++minisectionIndex) {
        }
        for (int blockIndex = minisectionIndex * 248; blockIndex < 4096; ++blockIndex) {
            FluidState fluidState;
            int z;
            int y;
            int x = RandomTickingSectionDataHelper.unpackX(blockIndex);
            BlockState blockState = section.getBlockState(x, y = RandomTickingSectionDataHelper.unpackY(blockIndex), z = RandomTickingSectionDataHelper.unpackZ(blockIndex));
            if ((((BlockStateFlagHolder)blockState).lithium$getAllFlags() & RANDOM_TICKING_FLAG_MASK) == 0 || randomBlockIndex-- != 0) continue;
            BlockPos immutableRandomTickPos = new BlockPos(sectionBlockX | x, sectionBlockY | y, sectionBlockZ | z);
            if (blockState.isRandomlyTicking()) {
                blockState.randomTick(level, immutableRandomTickPos, random);
            }
            if ((fluidState = blockState.getFluidState()).isRandomlyTicking()) {
                fluidState.randomTick(level, immutableRandomTickPos, random);
            }
            return;
        }
        throw new IllegalStateException("Failed to find random tickable position! This means lithium's random tickable block optimization encountered inconsistent data, hinting at a mod compatibility issue.");
    }

    public static void addAt(int x, int y, int z, byte[] data) {
        int n = RandomTickingSectionDataHelper.getMinisectionIndex(x, y, z);
        data[n] = (byte)(data[n] + 1);
    }

    public static void removeAt(int x, int y, int z, byte[] data) {
        int n = RandomTickingSectionDataHelper.getMinisectionIndex(x, y, z);
        data[n] = (byte)(data[n] - 1);
    }

    public static int getMinisectionIndex(int x, int y, int z) {
        return RandomTickingSectionDataHelper.pack(x, y, z) / 248;
    }

    private static int pack(int x, int y, int z) {
        return (y << 4 | z) << 4 | x;
    }

    public static int unpackX(int index) {
        return index & 0xF;
    }

    public static int unpackY(int index) {
        return index >> 8 & 0xF;
    }

    public static int unpackZ(int index) {
        return index >> 4 & 0xF;
    }

    public static class LithiumBlockCounter
    implements PalettedContainer.CountConsumer<BlockState> {
        private final byte[] randomTickData;
        private byte lastRandomTickableBlockCountTotal;
        private int minisectionIndex;
        private final PalettedContainer.CountConsumer<BlockState> delegate;

        public LithiumBlockCounter(byte[] randomTickData, PalettedContainer.CountConsumer<BlockState> original) {
            this.randomTickData = randomTickData;
            this.lastRandomTickableBlockCountTotal = 0;
            this.minisectionIndex = 0;
            this.delegate = original;
        }

        public void accept(@NotNull BlockState blockState, int i) {
            this.delegate.accept((Object)blockState, i);
        }

        public void finishedCountingMinisection(Int2IntOpenHashMap indexCounts, Palette<BlockState> palette) {
            int n = this.minisectionIndex;
            this.randomTickData[n] = (byte)(this.randomTickData[n] - this.lastRandomTickableBlockCountTotal);
            indexCounts.int2IntEntrySet().forEach(entry -> {
                BlockState blockState = (BlockState)palette.valueFor(entry.getIntKey());
                if ((((BlockStateFlagHolder)blockState).lithium$getAllFlags() & RANDOM_TICKING_FLAG_MASK) != 0) {
                    int n = this.minisectionIndex;
                    this.randomTickData[n] = (byte)(this.randomTickData[n] + (byte)entry.getIntValue());
                }
            });
            this.lastRandomTickableBlockCountTotal = (byte)(this.lastRandomTickableBlockCountTotal + this.randomTickData[this.minisectionIndex]);
            ++this.minisectionIndex;
        }

        public void handleAfterCounting(LevelChunkSection section) {
            if (MINISECTION_COUNT != this.minisectionIndex) {
                if (this.randomTickData != ((LithiumSectionData)section).lithium$getSectionData().getRandomTickableBlocksByY()) {
                    throw new IllegalArgumentException("Lithium random tick data was replaced unexpectedly!");
                }
                Arrays.fill(this.randomTickData, 0, this.randomTickData.length, (byte)0);
                RandomTickingSectionDataHelper.naiveInitializeData(section, this.randomTickData);
            }
            assert (0 == this.sanityCheckRandomTickableBlockCount((BlockCountingSection)section));
        }

        private int sanityCheckRandomTickableBlockCount(BlockCountingSection section) {
            int randomTickableStatesCount = section.lithium$getCount(BlockStateFlags.RANDOM_TICKING);
            int sum = 0;
            for (byte randomTickDatum : this.randomTickData) {
                sum += Byte.toUnsignedInt(randomTickDatum);
            }
            if (randomTickableStatesCount != sum) {
                throw new IllegalStateException("Lithium random tick data initialization calculated inconsistent results: " + randomTickableStatesCount + " != " + sum);
            }
            return 0;
        }
    }
}

