/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.world.chunk_ticking.random_block_ticking;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Objects;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlagHolder;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlags;
import net.caffeinemc.mods.lithium.common.world.section.LithiumSectionData;
import net.caffeinemc.mods.lithium.common.world.section.RandomTickingSectionDataHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunkSection.class}, priority=2000)
public abstract class LevelChunkSectionMixin
implements LithiumSectionData {
    @Shadow
    @Final
    private PalettedContainer<BlockState> states;

    @Inject(method={"<init>(Lnet/minecraft/world/level/chunk/PalettedContainerFactory;)V"}, at={@At(value="RETURN")})
    private void initAirSection(PalettedContainerFactory palettedContainerFactory, CallbackInfo ci) {
        LithiumSectionData.SectionData sectionData = this.lithium$getSectionData();
        if (sectionData.getRandomTickableBlocksByY() != null) {
            throw new IllegalStateException("RandomTickableBlocksByY already initialized!");
        }
        sectionData.setRandomTickableBlocksByY(new byte[RandomTickingSectionDataHelper.BYTE_COUNT]);
        if (this.states.maybeHas((Predicate)BlockStateFlags.RANDOM_TICKING)) {
            byte[] randomTickableBlocksByY = sectionData.getRandomTickableBlocksByY();
            int numBlocks = 4096;
            for (int i = 0; i < randomTickableBlocksByY.length; ++i) {
                randomTickableBlocksByY[i] = (byte)Math.min(248, numBlocks);
                numBlocks -= randomTickableBlocksByY[i];
            }
        }
    }

    @Inject(method={"recalcBlockCounts()V"}, at={@At(value="HEAD")})
    private void createFlagCounters(CallbackInfo ci) {
        this.lithium$getSectionData().setRandomTickableBlocksByY(new byte[RandomTickingSectionDataHelper.BYTE_COUNT]);
    }

    @WrapOperation(method={"recalcBlockCounts()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/PalettedContainer;count(Lnet/minecraft/world/level/chunk/PalettedContainer$CountConsumer;)V")})
    private void initFlagCounters(PalettedContainer<BlockState> instance, PalettedContainer.CountConsumer<BlockState> countConsumer, Operation<Void> original) {
        byte[] randomTickableBlocksByY = Objects.requireNonNull(this.lithium$getSectionData().getRandomTickableBlocksByY());
        RandomTickingSectionDataHelper.LithiumBlockCounter lithiumBlockCounter = new RandomTickingSectionDataHelper.LithiumBlockCounter(randomTickableBlocksByY, countConsumer);
        original.call(new Object[]{instance, lithiumBlockCounter});
        lithiumBlockCounter.handleAfterCounting((LevelChunkSection)this);
    }

    @Inject(method={"setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFluidState()Lnet/minecraft/world/level/material/FluidState;", ordinal=0)})
    private void updateRandomTickableBlockCounts(int x, int y, int z, BlockState newState, boolean lock, CallbackInfoReturnable<BlockState> cir, @Local(ordinal=1) BlockState oldState) {
        int prevFlags = ((BlockStateFlagHolder)oldState).lithium$getAllFlags();
        int flags = ((BlockStateFlagHolder)newState).lithium$getAllFlags();
        int mask = 1 << BlockStateFlags.RANDOM_TICKING.getIndex();
        if ((prevFlags & mask) != (flags & mask)) {
            if ((prevFlags & mask) != 0) {
                RandomTickingSectionDataHelper.removeAt(x, y, z, this.lithium$getSectionDataDirect().getRandomTickableBlocksByY());
            } else {
                RandomTickingSectionDataHelper.addAt(x, y, z, this.lithium$getSectionDataDirect().getRandomTickableBlocksByY());
            }
        }
    }
}

