/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.world.chunk_ticking.random_block_ticking;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.caffeinemc.mods.lithium.common.block.BlockCountingSection;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlags;
import net.caffeinemc.mods.lithium.common.world.section.LithiumSectionData;
import net.caffeinemc.mods.lithium.common.world.section.RandomTickingSectionDataHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntityGetter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level
implements ServerEntityGetter,
WorldGenLevel {
    @Unique
    private static final int MAX_COUNT_FOR_BLOCK_SEARCH_AFTER_RANDOM_CHANCE = 384;

    protected ServerLevelMixin(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, RegistryAccess registryAccess, Holder<DimensionType> holder, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, bl, bl2, l, i);
    }

    @ModifyExpressionValue(method={"tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V"}, at={@At(value="CONSTANT", args={"intValue=0"})}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/core/SectionPos;sectionToBlockCoord(I)I"), to=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getBlockRandomPos(IIII)Lnet/minecraft/core/BlockPos;", ordinal=1))})
    private int lithiumRandomTick(int original, @Local LevelChunkSection levelChunkSection, @Local(ordinal=0, argsOnly=true) int randomTickSpeed, @Local(ordinal=1) int chunkX, @Local(ordinal=5) int sectionY, @Local(ordinal=2) int chunkZ) {
        short randomTickableStatesCount = ((BlockCountingSection)levelChunkSection).lithium$getCount(BlockStateFlags.RANDOM_TICKING);
        if (randomTickableStatesCount <= 384) {
            for (int p = 0; p < randomTickSpeed; ++p) {
                int randomBlockIndex = this.getRandomBlockIndexForRandomTick();
                if (randomBlockIndex >= randomTickableStatesCount) continue;
                RandomTickingSectionDataHelper.randomTickNthBlock(levelChunkSection, randomBlockIndex, ((LithiumSectionData)levelChunkSection).lithium$getSectionData().getRandomTickableBlocksByY(), (ServerLevel)this, chunkX, sectionY, chunkZ, this.random);
                randomTickableStatesCount = ((BlockCountingSection)levelChunkSection).lithium$getCount(BlockStateFlags.RANDOM_TICKING);
            }
            return randomTickSpeed;
        }
        return original;
    }

    @Unique
    private int getRandomBlockIndexForRandomTick() {
        this.randValue = this.randValue * 3 + 1013904223;
        int r = this.randValue >> 2;
        return r & 0xF | r >> 8 & 0xF00 | r >> 4 & 0xF0;
    }
}

