/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.world.explosions.block_raycast;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerExplosion.class})
public abstract class ServerExplosionMixin {
    @Unique
    private static final HashSet<?> DUMMY_HASHSET = new HashSet(0);
    @Shadow
    @Final
    private float radius;
    @Shadow
    @Final
    private ServerLevel level;
    @Shadow
    @Final
    private ExplosionDamageCalculator damageCalculator;
    @Shadow
    @Final
    private boolean fire;
    @Shadow
    @Final
    private Vec3 center;
    @Unique
    private final BlockPos.MutableBlockPos cachedPos = new BlockPos.MutableBlockPos();
    @Unique
    private int prevChunkX = Integer.MIN_VALUE;
    @Unique
    private int prevChunkZ = Integer.MIN_VALUE;
    @Unique
    private ChunkAccess prevChunk;
    @Unique
    private boolean explodeAirBlocks;
    @Unique
    private int explodedPositions;
    @Unique
    private int bottomY;
    @Unique
    private int topY;

    @Inject(method={"<init>(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;Lnet/minecraft/world/phys/Vec3;FZLnet/minecraft/world/level/Explosion$BlockInteraction;)V"}, at={@At(value="TAIL")})
    private void init(ServerLevel serverLevel, Entity entity, DamageSource damageSource, ExplosionDamageCalculator explosionDamageCalculator, Vec3 vec3, float f, boolean bl, Explosion.BlockInteraction blockInteraction, CallbackInfo ci) {
        this.bottomY = this.level.getMinY();
        this.topY = this.level.getMaxY();
        boolean explodeAir = this.fire;
        if (!explodeAir && this.level.dimension() == Level.END && this.level.dimensionTypeRegistration().is(BuiltinDimensionTypes.END)) {
            float overestimatedExplosionRange = 8 + (int)(6.0f * this.radius);
            boolean endPortalX = false;
            boolean endPortalZ = false;
            if ((double)overestimatedExplosionRange > Math.abs(this.center.x - (double)endPortalX) && (double)overestimatedExplosionRange > Math.abs(this.center.z - (double)endPortalZ)) {
                explodeAir = true;
            }
        }
        this.explodeAirBlocks = explodeAir;
    }

    @Redirect(method={"calculateExplodedPositions"}, at=@At(value="NEW", target="()Ljava/util/HashSet;", remap=false))
    public HashSet<BlockPos> skipNewHashSet() {
        return DUMMY_HASHSET;
    }

    @ModifyConstant(method={"calculateExplodedPositions"}, constant={@Constant(intValue=16, ordinal=1)})
    public int skipLoop(int prevValue) {
        return 0;
    }

    @Redirect(method={"explode"}, at=@At(value="INVOKE", target="Ljava/util/List;size()I"))
    private int getExplodedPositionCount(List<?> instance) {
        return this.explodedPositions;
    }

    @Inject(method={"calculateExplodedPositions"}, at={@At(value="RETURN")})
    public void collectBlocks(CallbackInfoReturnable<List<BlockPos>> cir) {
        LongOpenHashSet touched = new LongOpenHashSet(0);
        RandomSource random = this.level.random;
        for (int rayX = 0; rayX < 16; ++rayX) {
            boolean xPlane = rayX == 0 || rayX == 15;
            double vecX = (float)rayX / 15.0f * 2.0f - 1.0f;
            for (int rayY = 0; rayY < 16; ++rayY) {
                boolean yPlane = rayY == 0 || rayY == 15;
                double vecY = (float)rayY / 15.0f * 2.0f - 1.0f;
                for (int rayZ = 0; rayZ < 16; ++rayZ) {
                    boolean zPlane;
                    boolean bl = zPlane = rayZ == 0 || rayZ == 15;
                    if (!xPlane && !yPlane && !zPlane) continue;
                    double vecZ = (float)rayZ / 15.0f * 2.0f - 1.0f;
                    this.performRayCast(random, vecX, vecY, vecZ, touched);
                }
            }
        }
        List affectedBlocks = (List)cir.getReturnValue();
        LongIterator it = touched.iterator();
        while (it.hasNext()) {
            affectedBlocks.add(BlockPos.of((long)it.nextLong()));
        }
    }

    @Unique
    private void performRayCast(RandomSource random, double vecX, double vecY, double vecZ, LongOpenHashSet touched) {
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        double normX = vecX / dist * 0.3;
        double normY = vecY / dist * 0.3;
        double normZ = vecZ / dist * 0.3;
        float strength = this.radius * (0.7f + random.nextFloat() * 0.6f);
        double stepX = this.center.x();
        double stepY = this.center.y();
        double stepZ = this.center.z();
        int prevX = Integer.MIN_VALUE;
        int prevY = Integer.MIN_VALUE;
        int prevZ = Integer.MIN_VALUE;
        float prevResistance = 0.0f;
        int boundMinY = this.bottomY;
        int boundMaxY = this.topY;
        while (strength > 0.0f) {
            float resistance;
            int blockX = Mth.floor((double)stepX);
            int blockY = Mth.floor((double)stepY);
            int blockZ = Mth.floor((double)stepZ);
            if (prevX != blockX || prevY != blockY || prevZ != blockZ) {
                if (blockY < boundMinY || blockY > boundMaxY || blockX < -30000000 || blockZ < -30000000 || blockX >= 30000000 || blockZ >= 30000000) {
                    return;
                }
                resistance = this.traverseBlock(strength, blockX, blockY, blockZ, touched);
                prevX = blockX;
                prevY = blockY;
                prevZ = blockZ;
                prevResistance = resistance;
            } else {
                resistance = prevResistance;
            }
            strength -= resistance;
            strength -= 0.22500001f;
            stepX += normX;
            stepY += normY;
            stepZ += normZ;
        }
    }

    @Unique
    private float traverseBlock(float strength, int blockX, int blockY, int blockZ, LongOpenHashSet touched) {
        float reducedStrength;
        Optional blastResistance;
        LevelChunkSection section;
        BlockPos.MutableBlockPos pos = this.cachedPos.set(blockX, blockY, blockZ);
        int chunkX = Pos.ChunkCoord.fromBlockCoord(blockX);
        int chunkZ = Pos.ChunkCoord.fromBlockCoord(blockZ);
        if (this.prevChunkX != chunkX || this.prevChunkZ != chunkZ) {
            this.prevChunk = this.level.getChunk(chunkX, chunkZ);
            this.prevChunkX = chunkX;
            this.prevChunkZ = chunkZ;
        }
        ChunkAccess chunk = this.prevChunk;
        BlockState blockState = Blocks.AIR.defaultBlockState();
        float totalResistance = 0.0f;
        if (chunk != null && (section = chunk.getSections()[Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)chunk, blockY)]) != null && !section.hasOnlyAir() && (blockState = section.getBlockState(blockX & 0xF, blockY & 0xF, blockZ & 0xF)).getBlock() != Blocks.AIR) {
            FluidState fluidState = blockState.getFluidState();
            blastResistance = this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, (BlockPos)pos, blockState, fluidState);
        } else {
            blastResistance = this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, (BlockPos)pos, Blocks.AIR.defaultBlockState(), Fluids.EMPTY.defaultFluidState());
        }
        if (blastResistance.isPresent()) {
            totalResistance = (((Float)blastResistance.get()).floatValue() + 0.3f) * 0.3f;
        }
        if ((reducedStrength = strength - totalResistance) > 0.0f) {
            ++this.explodedPositions;
            if ((this.explodeAirBlocks || !blockState.isAir()) && this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, (BlockPos)pos, blockState, reducedStrength)) {
                touched.add(pos.asLong());
            }
        }
        return totalResistance;
    }
}

