/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.world.inline_block_access;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={LevelChunk.class}, priority=500)
public abstract class LevelChunkMixin
extends ChunkAccess {
    private static final BlockState DEFAULT_BLOCK_STATE = Blocks.AIR.defaultBlockState();
    private static final FluidState DEFAULT_FLUID_STATE = Fluids.EMPTY.defaultFluidState();

    public LevelChunkMixin(ChunkPos chunkPos, UpgradeData upgradeData, LevelHeightAccessor levelHeightAccessor, PalettedContainerFactory palettedContainerFactory, long l, @Nullable LevelChunkSection[] levelChunkSections, @Nullable BlendingData blendingData) {
        super(chunkPos, upgradeData, levelHeightAccessor, palettedContainerFactory, l, levelChunkSections, blendingData);
    }

    @Overwrite
    public BlockState getBlockState(BlockPos pos) {
        LevelChunkSection section;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int chunkY = this.getSectionIndex(y);
        LevelChunkSection[] sectionArray = this.getSections();
        if (chunkY >= 0 && chunkY < sectionArray.length && !(section = sectionArray[chunkY]).hasOnlyAir()) {
            return section.getBlockState(x & 0xF, y & 0xF, z & 0xF);
        }
        return DEFAULT_BLOCK_STATE;
    }

    @Overwrite
    public FluidState getFluidState(int x, int y, int z) {
        int chunkY = this.getSectionIndex(y);
        LevelChunkSection[] sectionArray = this.getSections();
        if (chunkY >= 0 && chunkY < sectionArray.length) {
            LevelChunkSection section = sectionArray[chunkY];
            return section.getFluidState(x & 0xF, y & 0xF, z & 0xF);
        }
        return DEFAULT_FLUID_STATE;
    }
}

