/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.entity.movement;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.caffeinemc.mods.lithium.common.block.BlockCountingSection;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlags;
import net.caffeinemc.mods.lithium.common.shapes.VoxelShapeCaster;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChunkAwareBlockCollisionSweeper
extends AbstractIterator<VoxelShape> {
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private final AABB box;
    private final VoxelShape shape;
    private final Level world;
    private final CollisionContext context;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private int chunkX;
    private int chunkYIndex;
    private int chunkZ;
    private int cStartX;
    private int cStartZ;
    private int cEndX;
    private int cEndZ;
    private int cX;
    private int cY;
    private int cZ;
    private int maxHitX;
    private int maxHitY;
    private int maxHitZ;
    private VoxelShape maxShape;
    private final boolean hideLastCollision;
    private int cTotalSize;
    private int cIterated;
    private boolean sectionOversizedBlocks;
    private ChunkAccess cachedChunk;
    private LevelChunkSection cachedChunkSection;

    public ChunkAwareBlockCollisionSweeper(Level world, @Nullable Entity entity, AABB box) {
        this(world, entity, box, false);
    }

    public ChunkAwareBlockCollisionSweeper(Level world, @Nullable Entity entity, AABB box, boolean hideLastCollision) {
        this.box = box;
        this.shape = Shapes.create((AABB)box);
        this.context = entity == null ? CollisionContext.empty() : CollisionContext.of((Entity)entity);
        this.world = world;
        this.minX = Mth.floor((double)(box.minX - 1.0E-7));
        this.maxX = Mth.floor((double)(box.maxX + 1.0E-7));
        this.minY = Mth.clamp((int)Mth.floor((double)(box.minY - 1.0E-7)), (int)Pos.BlockCoord.getMinY((LevelHeightAccessor)this.world), (int)Pos.BlockCoord.getMaxYInclusive((LevelHeightAccessor)this.world));
        this.maxY = Mth.clamp((int)Mth.floor((double)(box.maxY + 1.0E-7)), (int)Pos.BlockCoord.getMinY((LevelHeightAccessor)this.world), (int)Pos.BlockCoord.getMaxYInclusive((LevelHeightAccessor)this.world));
        this.minZ = Mth.floor((double)(box.minZ - 1.0E-7));
        this.maxZ = Mth.floor((double)(box.maxZ + 1.0E-7));
        this.chunkX = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minX));
        this.chunkZ = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minZ));
        this.cIterated = 0;
        this.cTotalSize = 0;
        this.maxHitX = Integer.MIN_VALUE;
        this.maxHitY = Integer.MIN_VALUE;
        this.maxHitZ = Integer.MIN_VALUE;
        this.maxShape = null;
        this.hideLastCollision = hideLastCollision;
        --this.chunkX;
    }

    public VoxelShape getLastCollision() {
        return this.maxShape;
    }

    public Iterator<VoxelShape> getLastCollisionIterator() {
        return new Iterator<VoxelShape>(){

            @Override
            public boolean hasNext() {
                return ChunkAwareBlockCollisionSweeper.this.hideLastCollision && ChunkAwareBlockCollisionSweeper.this.maxShape != null;
            }

            @Override
            public VoxelShape next() {
                if (this.hasNext()) {
                    VoxelShape previousMaxShape = ChunkAwareBlockCollisionSweeper.this.maxShape;
                    ChunkAwareBlockCollisionSweeper.this.maxShape = null;
                    return previousMaxShape;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private boolean nextSection() {
        while (true) {
            if (this.cachedChunk != null && this.chunkYIndex < Pos.SectionYIndex.getMaxYSectionIndexInclusive((LevelHeightAccessor)this.world) && this.chunkYIndex < Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)this.world, ChunkAwareBlockCollisionSweeper.expandMax(this.maxY))) {
                ++this.chunkYIndex;
                this.cachedChunkSection = this.cachedChunk.getSections()[this.chunkYIndex];
            } else {
                if (this.chunkX < Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMax(this.maxX))) {
                    ++this.chunkX;
                } else if (this.chunkZ < Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMax(this.maxZ))) {
                    this.chunkX = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minX));
                    ++this.chunkZ;
                } else {
                    return false;
                }
                this.cachedChunk = this.world.getChunk(this.chunkX, this.chunkZ, ChunkStatus.FULL, false);
                if (this.cachedChunk != null) {
                    this.chunkYIndex = Mth.clamp((int)Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)this.world, ChunkAwareBlockCollisionSweeper.expandMin(this.minY)), (int)Pos.SectionYIndex.getMinYSectionIndex((LevelHeightAccessor)this.world), (int)Pos.SectionYIndex.getMaxYSectionIndexInclusive((LevelHeightAccessor)this.world));
                    this.cachedChunkSection = this.cachedChunk.getSections()[this.chunkYIndex];
                }
            }
            if (this.cachedChunk == null || this.cachedChunkSection == null || this.cachedChunkSection.hasOnlyAir()) continue;
            this.sectionOversizedBlocks = ChunkAwareBlockCollisionSweeper.hasChunkSectionOversizedBlocks(this.cachedChunk, this.chunkYIndex);
            int sizeExtension = this.sectionOversizedBlocks ? 1 : 0;
            this.cEndX = Math.min(this.maxX + sizeExtension, Pos.BlockCoord.getMaxInSectionCoord(this.chunkX));
            int cEndY = Math.min(this.maxY + sizeExtension, Pos.BlockCoord.getMaxYInSectionIndex((LevelHeightAccessor)this.world, this.chunkYIndex));
            this.cEndZ = Math.min(this.maxZ + sizeExtension, Pos.BlockCoord.getMaxInSectionCoord(this.chunkZ));
            this.cStartX = Math.max(this.minX - sizeExtension, Pos.BlockCoord.getMinInSectionCoord(this.chunkX));
            int cStartY = Math.max(this.minY - sizeExtension, Pos.BlockCoord.getMinYInSectionIndex((LevelHeightAccessor)this.world, this.chunkYIndex));
            this.cStartZ = Math.max(this.minZ - sizeExtension, Pos.BlockCoord.getMinInSectionCoord(this.chunkZ));
            this.cX = this.cStartX;
            this.cY = cStartY;
            this.cZ = this.cStartZ;
            this.cTotalSize = (this.cEndX - this.cStartX + 1) * (cEndY - cStartY + 1) * (this.cEndZ - this.cStartZ + 1);
            if (this.cTotalSize != 0) break;
        }
        this.cIterated = 0;
        return true;
    }

    public VoxelShape computeNext() {
        while (this.cIterated < this.cTotalSize || this.nextSection()) {
            VoxelShape collidedShape;
            BlockState state;
            int edgesHit;
            ++this.cIterated;
            int x = this.cX;
            int y = this.cY++;
            int z = this.cZ;
            if (this.cX < this.cEndX) {
                ++this.cX;
            } else if (this.cZ < this.cEndZ) {
                this.cX = this.cStartX;
                ++this.cZ;
            } else {
                this.cX = this.cStartX;
                this.cZ = this.cStartZ;
            }
            if ((edgesHit = this.sectionOversizedBlocks ? (x < this.minX || x > this.maxX ? 1 : 0) + (y < this.minY || y > this.maxY ? 1 : 0) + (z < this.minZ || z > this.maxZ ? 1 : 0) : 0) == 3 || !ChunkAwareBlockCollisionSweeper.canInteractWithBlock(state = this.cachedChunkSection.getBlockState(x & 0xF, y & 0xF, z & 0xF), edgesHit)) continue;
            this.pos.set(x, y, z);
            VoxelShape collisionShape = this.context.getCollisionShape(state, (CollisionGetter)this.world, (BlockPos)this.pos);
            if (collisionShape == Shapes.empty() || collisionShape == null || (collidedShape = ChunkAwareBlockCollisionSweeper.getCollidedShape(this.box, this.shape, collisionShape, x, y, z)) == null) continue;
            if (z >= this.maxHitZ && (z > this.maxHitZ || y >= this.maxHitY && (y > this.maxHitY || x > this.maxHitX))) {
                this.maxHitX = x;
                this.maxHitY = y;
                this.maxHitZ = z;
                VoxelShape previousMaxShape = this.maxShape;
                this.maxShape = collidedShape;
                if (previousMaxShape == null) continue;
                return previousMaxShape;
            }
            return collidedShape;
        }
        if (!this.hideLastCollision && this.maxShape != null) {
            VoxelShape previousMaxShape = this.maxShape;
            this.maxShape = null;
            return previousMaxShape;
        }
        return (VoxelShape)this.endOfData();
    }

    private static boolean canInteractWithBlock(BlockState state, int edgesHit) {
        return !(edgesHit == 1 && !state.hasLargeCollisionShape() || edgesHit == 2 && state.getBlock() != Blocks.MOVING_PISTON);
    }

    private static VoxelShape getCollidedShape(AABB entityBox, VoxelShape entityShape, VoxelShape shape, int x, int y, int z) {
        if (shape == Shapes.block()) {
            return entityBox.intersects((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0) ? shape.move((double)x, (double)y, (double)z) : null;
        }
        if (shape instanceof VoxelShapeCaster) {
            if (((VoxelShapeCaster)shape).intersects(entityBox, x, y, z)) {
                return shape.move((double)x, (double)y, (double)z);
            }
            return null;
        }
        if (Shapes.joinIsNotEmpty((VoxelShape)(shape = shape.move((double)x, (double)y, (double)z)), (VoxelShape)entityShape, (BooleanOp)BooleanOp.AND)) {
            return shape;
        }
        return null;
    }

    private static int expandMin(int coord) {
        return coord - 1;
    }

    private static int expandMax(int coord) {
        return coord + 1;
    }

    private static boolean hasChunkSectionOversizedBlocks(ChunkAccess chunk, int chunkY) {
        if (BlockStateFlags.ENABLED) {
            LevelChunkSection section = chunk.getSections()[chunkY];
            return section != null && ((BlockCountingSection)section).lithium$mayContainAny(BlockStateFlags.OVERSIZED_SHAPE);
        }
        return true;
    }

    public List<VoxelShape> collectAll() {
        ArrayList<VoxelShape> collisions = new ArrayList<VoxelShape>();
        while (this.hasNext()) {
            collisions.add((VoxelShape)this.next());
        }
        return collisions;
    }
}

