/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.entity.projectile;

import net.caffeinemc.mods.lithium.common.entity.EntityClassGroup;
import net.caffeinemc.mods.lithium.common.reflection.ReflectionUtil;
import net.caffeinemc.mods.lithium.common.services.PlatformMappingInformation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.entity.projectile.hurtingprojectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.hurtingprojectile.windcharge.AbstractWindCharge;

public class ProjectileEntityClassGroup {
    public static final EntityClassGroup OPTIMIZED_PROJECTILES;
    public static final EntityClassGroup CAN_MAYBE_BE_HIT_BY_OPTIMIZED_PROJECTILE;

    static {
        String remapped_canHitEntity = PlatformMappingInformation.INSTANCE.mapMethodName("intermediary", "net.minecraft.class_1676", "method_26958", "(Lnet/minecraft/class_1297;)Z", "canHitEntity");
        OPTIMIZED_PROJECTILES = new EntityClassGroup((entityClass, entityType) -> {
            Class<Projectile> parentClass = Projectile.class;
            if (AbstractHurtingProjectile.class.isAssignableFrom((Class<?>)entityClass)) {
                parentClass = AbstractHurtingProjectile.class;
                if (AbstractWindCharge.class.isAssignableFrom((Class<?>)entityClass)) {
                    parentClass = AbstractWindCharge.class;
                }
            } else if (AbstractArrow.class.isAssignableFrom((Class<?>)entityClass)) {
                parentClass = AbstractArrow.class;
            } else if (ShulkerBullet.class.isAssignableFrom((Class<?>)entityClass)) {
                parentClass = ShulkerBullet.class;
            }
            return !ReflectionUtil.hasMethodOverride(entityClass, parentClass, true, remapped_canHitEntity, Entity.class);
        });
        String remapped_canBeHitByProjectile = PlatformMappingInformation.INSTANCE.mapMethodName("intermediary", "net.minecraft.class_1297", "method_49108", "()Z", "canBeHitByProjectile");
        String remapped_isPickable = PlatformMappingInformation.INSTANCE.mapMethodName("intermediary", "net.minecraft.class_1297", "method_5863", "()Z", "isPickable");
        CAN_MAYBE_BE_HIT_BY_OPTIMIZED_PROJECTILE = new EntityClassGroup((entityClass, entityType) -> {
            Class<Entity> parentClass_isPickable = Entity.class;
            if (Interaction.class == entityClass) {
                return false;
            }
            if (ReflectionUtil.hasMethodOverride(entityClass, Entity.class, true, remapped_canBeHitByProjectile, new Class[0])) {
                return true;
            }
            if (EnderDragon.class == entityClass) {
                return false;
            }
            if (Projectile.class.isAssignableFrom((Class<?>)entityClass)) {
                parentClass_isPickable = Projectile.class;
                if (AbstractArrow.class.isAssignableFrom((Class<?>)entityClass)) {
                    parentClass_isPickable = AbstractArrow.class;
                }
                if (((EntityType)entityType.get()).is(EntityTypeTags.REDIRECTABLE_PROJECTILE)) {
                    return true;
                }
            }
            return ReflectionUtil.hasMethodOverride(entityClass, parentClass_isPickable, true, remapped_isPickable, new Class[0]);
        });
    }
}

